/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.util.string;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.core.startup.SystemConfiguration;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class TEResourceBundle {
    public static final String T2000_SERVER_RESOURCE_BASE = "/server/core/res/";
    protected static Map<String, ResourceBundle> mappings = new HashMap<String, ResourceBundle>();

    public static ResourceBundle getBundle(String baseDir, String fileName, boolean cache) {
        String lang = Locale.getDefault().getLanguage() + "_" + Locale.getDefault().getCountry();
        String fullPath = SystemConfiguration.getIMapRootPath() + baseDir + lang + "/" + fileName;
        ResourceBundle bundle = mappings.get(fullPath);
        if (bundle == null) {
            bundle = TEResourceBundle.createBundle(fullPath);
            if (cache) {
                mappings.put(fullPath, bundle);
            }
        }
        return bundle;
    }

    public static String getResourceStr(String fileName, String key) {
        ResourceBundle bundle = TEResourceBundle.getBundle(T2000_SERVER_RESOURCE_BASE, fileName, false);
        return bundle.getString(key);
    }

    public static String getString(String file, String key) {
        ResourceBundle bundle = mappings.get(file);
        if (bundle == null) {
            bundle = TEResourceBundle.createBundle(file);
        }
        try {
            return bundle.getString(key);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEResourceBundle.getString fail!", (Throwable)e);
            return null;
        }
    }

    public static int getInt(String file, String key) {
        String str = TEResourceBundle.getString(file, key);
        if (null == str) {
            return -1;
        }
        return Integer.valueOf(str.trim());
    }

    public static float getFloat(String file, String key) {
        String str = TEResourceBundle.getString(file, key);
        if (null == str) {
            return -1.0f;
        }
        return Float.valueOf(str).floatValue();
    }

    protected static ResourceBundle createBundle(String fullPath) {
        try {
            FileInputStream in = new FileInputStream(fullPath);
            PropertyResourceBundle bundle = new PropertyResourceBundle(in);
            ((InputStream)in).close();
            return bundle;
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEResourceBundle.createBundle() fail!", (Throwable)e);
            return null;
        }
    }
}

