/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.util.string;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.util.string.TEStringUtils;
import gnu.trove.TIntArrayList;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.osgi.framework.Bundle;

public class TEFileRegisterer {
    private static final String META_INF_DIRNAME = "META-INF";
    private static final String COM_DIRNAME = "com";
    private static final String SRC_DIRNAME = "src";
    private static final String BIN_DIRNAME = "bin";
    private static final String NEMGR_DIRNAME = "/nemgr";
    private static final String FILEMAPPING_FILENAME = "/filemapping.ini";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TIntArrayList registerFiles(Bundle bundle) {
        int PC_DIR_PATH_SEPARATOR = 92;
        int JAR_FILE_SEPARATOR = 47;
        TIntArrayList filePathHashList = new TIntArrayList();
        BufferedReader br = null;
        try {
            URL fileMappingFileUrl = bundle.getResource(FILEMAPPING_FILENAME);
            if (null != fileMappingFileUrl) {
                URL realFileMappingUrl = FileLocator.toFileURL((URL)fileMappingFileUrl);
                File fileMappingFile = new File(realFileMappingUrl.getFile());
                br = new BufferedReader(new InputStreamReader(new FileInputStream(fileMappingFile)));
                String line = null;
                int hash = -1;
                while (null != (line = br.readLine())) {
                    hash = TEStringUtils.hashString(line = line.replace('\\', '/'));
                    if (filePathHashList.contains(hash)) {
                        TELogFactory.getNormalLogger().info("ERROR --- add file mapping duplicated...." + line);
                        continue;
                    }
                    filePathHashList.add(hash);
                }
            } else {
                File[] subs;
                URL base = bundle.getResource(NEMGR_DIRNAME);
                String realBase = FileLocator.toFileURL((URL)base).getPath();
                File baseDir = new File(realBase);
                baseDir = new File(baseDir.getParent());
                realBase = baseDir.getAbsolutePath();
                for (File sub : subs = baseDir.listFiles()) {
                    if (!TEFileRegisterer.check(sub)) continue;
                    TEFileRegisterer.registerFiles(realBase, sub, bundle, filePathHashList);
                }
            }
            if (null != br) {
                br.close();
            }
            TIntArrayList tIntArrayList = filePathHashList;
            return tIntArrayList;
        }
        catch (IOException e) {
            TELogFactory.getNormalLogger().error("TEFileRegisterer.registerFiles() fail!", (Throwable)e);
        }
        finally {
            if (null != br) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    TELogFactory.getNormalLogger().error("TEFileRegisterer.registerFiles() fail!", (Throwable)e);
                }
            }
        }
        return null;
    }

    public static void registerFiles(String basePath, File file, Bundle bundle, TIntArrayList filePathHashList) {
        if (file.isFile()) {
            String filePath = new File(TEFileRegisterer.getRelativePath(basePath, file.getAbsolutePath())).getPath();
            int hash = TEStringUtils.hashString(filePath = filePath.replace('\\', '/'));
            if (filePathHashList.contains(hash)) {
                TELogFactory.getNormalLogger().info("ERROR --- add file mapping duplicated...." + filePath);
            } else {
                filePathHashList.add(hash);
            }
        } else {
            File[] subs;
            for (File sub : subs = file.listFiles()) {
                TEFileRegisterer.registerFiles(basePath, sub, bundle, filePathHashList);
            }
        }
    }

    protected static String getRelativePath(String basePath, String absPath) {
        if (absPath == null || "".equals(absPath)) {
            return null;
        }
        if (absPath.length() <= basePath.length()) {
            return "";
        }
        return absPath.substring(basePath.length());
    }

    protected static boolean check(File file) {
        if (file.isFile()) {
            return true;
        }
        return !file.getAbsolutePath().endsWith(BIN_DIRNAME) && !file.getAbsolutePath().endsWith(SRC_DIRNAME) && !file.getAbsolutePath().endsWith(COM_DIRNAME) && !file.getAbsolutePath().endsWith(META_INF_DIRNAME);
    }
}

