/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.util.string;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TEParseXMLFile;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.io.File;
import java.util.Hashtable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TEErrorResourceMgr {
    private static Hashtable<Integer, ErrorMessage> errcode_res_map = new Hashtable();
    private String filepath = "res" + File.separator + "trans_errorcode_" + TESysManagerBean.getInstance().getlanguage() + ".xml";
    private static TEErrorResourceMgr instance;

    public static synchronized TEErrorResourceMgr getInstance() {
        if (instance == null) {
            instance = new TEErrorResourceMgr();
        }
        return instance;
    }

    private TEErrorResourceMgr() {
    }

    public void initialErrcodeResFile() {
        Document doc = null;
        try {
            doc = TEParseXMLFile.parseFile("com.huawei.weblct.common", this.filepath);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error(e.toString(), (Throwable)e);
        }
        if (null == doc || !doc.hasChildNodes()) {
            return;
        }
        NodeList nodeList = doc.getElementsByTagName("PARAS");
        Node childTag = null;
        int length = nodeList.getLength();
        for (int i = 0; i < length; ++i) {
            childTag = nodeList.item(i);
            if (!childTag.hasChildNodes()) continue;
            this.parsePARASNodeChildList(childTag);
        }
    }

    private void parsePARASNodeChildList(Node ParasNodeTag) {
        NodeList nodeList = ParasNodeTag.getChildNodes();
        Node childTag = null;
        int length = nodeList.getLength();
        for (int i = 0; i < length; ++i) {
            Element childElm;
            childTag = nodeList.item(i);
            if (!(childTag instanceof Element) || !(childElm = (Element)childTag).getNodeName().equalsIgnoreCase("PARA")) continue;
            String codeName = this.getNodeAttributeValue(childElm, "name");
            String errInfo = this.getNodeAttributeValue(childElm, "value");
            try {
                String erroMsg = this.getErrInfoFromErrcodeINIFile(codeName);
                if (!erroMsg.equalsIgnoreCase(codeName)) continue;
                ErrorMessage errMsg = new ErrorMessage();
                errMsg.setErrorcode(codeName);
                errMsg.setErrorinfo(errInfo);
                errcode_res_map.put(Integer.valueOf(codeName), errMsg);
                continue;
            }
            catch (NumberFormatException ex) {
                TELogFactory.getNormalLogger().error("Unkown error code", (Throwable)ex);
            }
        }
    }

    private String getErrInfoFromErrcodeINIFile(String errorCode) {
        StringBuffer tmp = new StringBuffer();
        tmp.append(TEPathManager.RESOURCE_PROFILE_PATH).append("errcode_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        TEResourceUtil res = null;
        res = TEResourceUtil.getInstance(tmp.toString());
        return res.getString(errorCode);
    }

    private String getNodeAttributeValue(Node childTag, String itemName) {
        NamedNodeMap nodeMap = childTag.getAttributes();
        Node idNode = nodeMap.getNamedItem(itemName);
        if (idNode == null) {
            return null;
        }
        return idNode.getNodeValue();
    }

    public ErrorMessage getErrorMsg(int errorcode) {
        return errcode_res_map.get(errorcode);
    }
}

