/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.util.string;

import com.huawei.nglct.cbb.xmlinterpreter.SDXMLInterpreterMgr;
import com.huawei.nglct.util.string.TEStringUtils;
import gnu.trove.TIntArrayList;
import java.util.ArrayList;
import java.util.List;

public class TEConvertUtil {
    public static boolean str2Ip(String pcIp, long[] ulIP) {
        int second = 0;
        int sec = 0;
        ulIP[0] = 0L;
        int first = pcIp.indexOf(46);
        int value = -1;
        while (second < pcIp.length()) {
            if (first == second) {
                return false;
            }
            String sub = pcIp.substring(second, first).trim();
            try {
                value = Integer.parseInt(sub);
            }
            catch (Exception e) {
                return false;
            }
            if (value < 0 || value > 255 || sec >= 4) {
                return false;
            }
            ulIP[0] = (ulIP[0] << 8) + (long)value;
            ++sec;
            second = first + 1;
            first = (first = pcIp.indexOf(46, second)) == -1 ? pcIp.length() : first;
        }
        return sec == 4;
    }

    public static String ip2String(int a) {
        int d1 = a >> 16 & 0xFF;
        int d2 = a & 0xFFFF;
        StringBuffer sb = new StringBuffer();
        sb.append(d1).append("-").append(d2);
        return sb.toString();
    }

    public static String ipToString(long ip) {
        long ip1 = ip >> 24 & 0xFFL;
        long ip2 = ip >> 16 & 0xFFL;
        long ip3 = ip >> 8 & 0xFFL;
        long ip4 = ip & 0xFFL;
        return "" + ip1 + "." + ip2 + "." + ip3 + "." + ip4;
    }

    public static int neVersion(int v1, int v2, int v3, int v4) {
        return (v1 << 24) + (v2 << 16) + (v3 << 8) + v4;
    }

    public static String neVersionToString(int neVersion) {
        int ver1 = neVersion >> 24 & 0xFF;
        int ver2 = neVersion >> 16 & 0xFF;
        int ver3 = neVersion >> 8 & 0xFF;
        int ver4 = neVersion & 0xFF;
        if (ver3 < 10) {
            return "" + ver1 + "." + ver2 + ".0" + ver3 + "." + ver4;
        }
        return "" + ver1 + "." + ver2 + "." + ver3 + "." + ver4;
    }

    public static int convertVerStrToInt(String verStr1) {
        if (null == verStr1) {
            return 0;
        }
        char[] ch1 = verStr1.toCharArray();
        int result1 = 0;
        int sum1 = 0;
        int TCount = 0;
        boolean frontIsPoint1 = true;
        int[] T = new int[]{0x1000000, 65536, 256};
        int[] nMax = new int[]{223, 255, 255, 255};
        for (int i = 0; i < verStr1.length(); ++i) {
            if (ch1[i] >= '0' && ch1[i] <= '9') {
                sum1 = sum1 * 10 + (ch1[i] - 48);
                frontIsPoint1 = false;
                continue;
            }
            if (ch1[i] == '.') {
                if (frontIsPoint1) {
                    return 0;
                }
                frontIsPoint1 = true;
                if (TCount >= 3) {
                    return 0;
                }
                if (sum1 > nMax[TCount]) {
                    return 0;
                }
                result1 += sum1 * T[TCount++];
                sum1 = 0;
                continue;
            }
            if (ch1[i] == ' ') continue;
            return 0;
        }
        if (frontIsPoint1) {
            return 0;
        }
        if (TCount != 3) {
            return 0;
        }
        if (sum1 > nMax[TCount]) {
            return 0;
        }
        return result1 + sum1;
    }

    public static boolean strToNumList(String str2, TIntArrayList vec) {
        String[] strItem = str2.split(",");
        boolean bSuccess = true;
        vec.clear();
        for (String str2 : strItem) {
            if ("".equals(str2.trim())) continue;
            int[] nStart = new int[1];
            int[] nEnd = new int[1];
            if (!TEStringUtils.getSpan(str2, nStart, nEnd) || nStart[0] > nEnd[0]) {
                bSuccess = false;
            }
            if (!bSuccess) continue;
            for (int j = nStart[0]; j <= nEnd[0]; ++j) {
                vec.add(j);
            }
        }
        return bSuccess;
    }

    public static String convertPathtoUnixMode(String strPath) {
        return strPath.trim().replaceAll("\\\\", "/");
    }

    public static int convertAbsolutePath(String[] strPath) {
        String tmpStr = TEConvertUtil.convertPathtoUnixMode(strPath[0]);
        if ("".equals(tmpStr)) {
            return -1;
        }
        if (tmpStr.startsWith(".")) {
            return -1;
        }
        String subStr = null;
        int pos = -1;
        while (-1 != (pos = tmpStr.lastIndexOf("/../"))) {
            subStr = tmpStr.substring(0, pos);
            int posParent = subStr.lastIndexOf("/");
            if (-1 == posParent) {
                return -1;
            }
            tmpStr = tmpStr.substring(0, posParent) + tmpStr.substring(pos + 3, tmpStr.length());
        }
        while (-1 != tmpStr.indexOf("/./")) {
            tmpStr = tmpStr.replace("/.", "");
        }
        strPath[0] = tmpStr;
        return 0;
    }

    public static String strToMAC(String hexMac) {
        StringBuilder sb = new StringBuilder();
        int len = hexMac.length();
        int m = len - 2;
        for (int i = 0; i < m; i += 2) {
            sb.append(hexMac.substring(i, i + 2)).append("-");
        }
        if (len > 2) {
            sb.append(hexMac.substring(len - 2, len));
        }
        return sb.toString();
    }

    public static final String convertHexIptoTen(String hexip) {
        if (null == hexip || hexip.length() != 8) {
            throw new IllegalArgumentException("invalid hex ip address");
        }
        StringBuffer strbuf = new StringBuffer();
        strbuf.append(Integer.parseInt(hexip.substring(0, 2), 16)).append(".");
        strbuf.append(Integer.parseInt(hexip.substring(2, 4), 16)).append(".");
        strbuf.append(Integer.parseInt(hexip.substring(4, 6), 16)).append(".");
        strbuf.append(Integer.parseInt(hexip.substring(6, 8), 16));
        return strbuf.toString();
    }

    public static final String convertNeIDLongToStr(long neID) {
        return (neID - neID % 65536L) / 65536L + "-" + neID % 65536L;
    }

    public static final List<Integer> parseIntList(String values) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        SDXMLInterpreterMgr.getInstance().parseIntList(values, result);
        return result;
    }

    public static final int parseInt(String value) {
        return SDXMLInterpreterMgr.getInstance().parseInt(value);
    }
}

