/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.util.string;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;

public class TECharsetConverter {
    private static final String CHARSET_GBK = "GBK";
    private static final String CHARSET_ISO8859 = "ISO-8859-1";
    private static final String CHARSET_UTF8 = "UTF-8";
    private static TECharsetConverter instance = null;
    private static CharsetDecoder gbk_decoder = Charset.forName("GBK").newDecoder();
    private static CharsetEncoder gbk_encoder = Charset.forName("GBK").newEncoder();
    private static CharsetDecoder unicode_decoder = Charset.forName("UTF-8").newDecoder();
    private static CharsetEncoder unicode_encoder = Charset.forName("UTF-8").newEncoder();
    private static final String DOUBLE_CODE = "2";
    private static final String THREE_CODE = "3";
    public static final String CHARSET_GBK_NAME = "GBK";
    public static final String CHARSET_ISO8859_NAME = "ISO-8859-1";
    public static final String CHARSET_UTF_8_NAME = "UTF-8";
    public static final String CHARSET_GBK_VALUE = "1";
    public static final String CHARSET_ISO8859_1_VALUE = "2";
    public static final String CHARSET_UTF_8_VALUE = "3";

    private TECharsetConverter() {
    }

    public static synchronized TECharsetConverter getInstance() {
        if (instance == null) {
            instance = new TECharsetConverter();
        }
        return instance;
    }

    public byte[] convertStringToByte(int neid, String s) throws CharacterCodingException {
        String charsetName = this.getNeCharsetName(neid);
        String str = s;
        if (charsetName.equals("GBK")) {
            str = gbk_decoder.decode(gbk_encoder.encode(CharBuffer.wrap(s))).toString();
        } else if (charsetName.equals("ISO-8859-1")) {
            if (s.length() != s.getBytes().length) {
                throw new CharacterCodingException();
            }
            str = new String(s.getBytes(), Charset.forName(charsetName));
        }
        return str.getBytes(Charset.forName(charsetName));
    }

    public String convertByteToString(int neid, byte[] byteArr) {
        String charsetName = this.getNeCharsetName(neid);
        String str = null;
        try {
            if (charsetName.equals("GBK")) {
                str = new String(byteArr, Charset.forName("GBK"));
                str = unicode_decoder.decode(unicode_encoder.encode(CharBuffer.wrap(str))).toString();
            } else if (charsetName.equals("ISO-8859-1")) {
                str = new String(byteArr, Charset.forName("ISO-8859-1"));
                str = unicode_decoder.decode(unicode_encoder.encode(CharBuffer.wrap(str))).toString();
            } else {
                str = new String(byteArr, Charset.forName("UTF-8"));
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TECharsetConverter.convertByteToString() fail!", (Throwable)e);
        }
        return str;
    }

    private String getNeCharsetName(int neid) {
        String sysLangyage = TESysManagerBean.getInstance().getlanguage();
        TENE ne = TEConfigurationDataMgr.getInstance().getNE(neid);
        if (ne == null) {
            return "UTF-8";
        }
        String neGlobalSin = ne.getNeGlobalSign();
        if (neGlobalSin.equals("0")) {
            if (sysLangyage.equals("zh")) {
                return "GBK";
            }
            return "ISO-8859-1";
        }
        if (neGlobalSin.equals(CHARSET_GBK_VALUE)) {
            return "GBK";
        }
        if (neGlobalSin.equals("2")) {
            return "ISO-8859-1";
        }
        return "UTF-8";
    }

    public static String getChineseLength(String globalSign) {
        String sysLangyage = TESysManagerBean.getInstance().getlanguage();
        String strLen = "2";
        if (globalSign.equals("0")) {
            strLen = sysLangyage.equals("en") ? "3" : "2";
        } else if (globalSign.equals("2") || globalSign.equals("3")) {
            strLen = "3";
        }
        return strLen;
    }

    public static String convertNECharset(String charsetValue) {
        if (charsetValue.equals(CHARSET_GBK_VALUE)) {
            return "GBK";
        }
        if (charsetValue.equals("2")) {
            return "ISO-8859-1";
        }
        if (charsetValue.equals("3")) {
            return "UTF-8";
        }
        String sysLangyage = TESysManagerBean.getInstance().getlanguage();
        if (sysLangyage.equals("zh")) {
            return "GBK";
        }
        return "ISO-8859-1";
    }
}

