/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.util.login;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.util.login.WorkerThread;
import java.util.HashSet;
import java.util.LinkedList;

public class Channel {
    private LinkedList requestQueue = new LinkedList();
    private HashSet requestSet = new HashSet();
    private final WorkerThread[] threadPool;

    public Channel(int threads) {
        this.threadPool = new WorkerThread[threads];
        for (int i = 0; i < this.threadPool.length; ++i) {
            this.threadPool[i] = new WorkerThread("Worker-" + i, this);
        }
    }

    public void startWorkers() {
        for (int i = 0; i < this.threadPool.length; ++i) {
            this.threadPool[i].start();
        }
    }

    public synchronized void putRequest(Runnable request) {
        if (!this.requestSet.add(request)) {
            TELogFactory.getNormalLogger().info("Filter duplicated request:" + request);
            return;
        }
        this.requestQueue.add(request);
        this.notifyAll();
    }

    public synchronized Runnable takeRequest() {
        while (this.requestQueue.size() <= 0) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {}
        }
        Runnable request = (Runnable)this.requestQueue.removeFirst();
        this.requestSet.remove(request);
        this.notifyAll();
        return request;
    }
}

