/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.util.io;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.util.device.TEVersionRelationBean;
import com.huawei.nglct.util.device.ne.TEGetNEDomainVersion;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.nglct.util.xml.TEResourceManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class TEGetFilePath {
    private static TEVersionRelationBean versionRelation = TEVersionRelationBean.getInstance();

    private TEGetFilePath() {
    }

    public static String getFilePath(int neid, String filename) {
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        int neType = ne.getNEType();
        String hostVersion = ne.getHostVersion();
        return TEGetFilePath.getFilePath(neType, hostVersion, filename);
    }

    public static String getFilePath(int neType, String hostVersion, String filename) {
        String filePath = null;
        String domain = TEGetFilePath.getNEDomain(neType);
        filePath = TEGetFilePath.getFilePath(neType, domain, hostVersion, filename);
        return filePath;
    }

    public static String getInheritedFilePath(int neType, String hostVersion, String filename) {
        String filePath = null;
        String domain = TEGetFilePath.getNEDomain(neType);
        String version = versionRelation.gerParentVersion(neType, hostVersion);
        filePath = !version.equals(hostVersion) ? TEGetFilePath.getFilePath(neType, domain, version, filename) : "nemgr" + File.separator + "device" + File.separator + domain + File.separator + filename;
        return filePath;
    }

    private static String getFilePath(int neType, String domain, String hostVersion, String filename) {
        String filePath = TEGetFilePath.getCurrentFilePath(neType, domain, hostVersion, filename);
        String bundlename = TEGetFilePath.getNEBundleName(neType);
        File file = TEResourceManager.getFileByName(bundlename, filePath);
        if (!(null != file && file.exists() || null != (file = TEResourceManager.getFileByName(bundlename, filePath = "nemgr" + File.separator + "device" + File.separator + domain + File.separator + filename)) && file.exists())) {
            if (domain.equals("tl1ngwdm")) {
                filePath = "nemgr" + File.separator + "tl1ngwdm" + File.separator + filename;
                file = TEResourceManager.getFileByName(bundlename, filePath);
                if (!file.exists()) {
                    filePath = "nemgr" + File.separator + "tl1necommon" + File.separator + filename;
                }
            } else {
                filePath = null;
            }
        }
        return filePath;
    }

    private static String getCurrentFilePath(int neType, String domain, String hostVersion, String filename) {
        String version;
        String filePath = "nemgr" + File.separator + "device" + File.separator + domain + File.separator + "ne_" + neType + File.separator;
        if (domain.equals("tl1ngwdm")) {
            filePath = "nemgr" + File.separator + domain + File.separator + "ne_" + neType + File.separator;
        }
        if (null == hostVersion) {
            filePath = filePath + filename;
            return filePath;
        }
        filePath = filePath + hostVersion + File.separator + filename;
        String bundlename = TEGetFilePath.getNEBundleName(neType);
        File file = TEResourceManager.getFileByName(bundlename, filePath);
        if (!(null != file && file.exists() || (version = versionRelation.gerParentVersion(neType, hostVersion)).equals(hostVersion))) {
            filePath = TEGetFilePath.getCurrentFilePath(neType, domain, version, filename);
        }
        return filePath;
    }

    public static List<String[]> getQXandFuncFilePath(int neid, String filename) {
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        int neType = ne.getNEType();
        String hostVersion = ne.getHostVersion();
        return TEGetFilePath.getQXandFuncFilePath(neType, hostVersion, filename);
    }

    public static List<String[]> getQXandFuncFilePath(int neType, String hostVersion, String filename) {
        ArrayList<String[]> fileList = new ArrayList<String[]>();
        String filePath = "";
        String domain = TEGetFilePath.getNEDomain(neType);
        String bundlename = TEGetFilePath.getNEBundleName(neType);
        try {
            TEGetFilePath.getFilePathes(neType, domain, bundlename, hostVersion, filename, fileList);
        }
        catch (IOException e) {
            TELogFactory.getNormalLogger().error("TEGetFilePath.getQXandFuncFilePath() fail!", (Throwable)e);
        }
        filePath = "nemgr" + File.separator + "device" + File.separator + domain + File.separator + filename;
        if (TEGetFilePath.isFileExist(bundlename, filePath)) {
            fileList.add(new String[]{bundlename, filePath});
        }
        return fileList;
    }

    private static void getFilePathes(int neType, String domain, String bundlename, String hostVersion, String filename, List<String[]> fileList) throws IOException {
        List<String> pVerList = versionRelation.getParentVersion(neType, hostVersion);
        String filePath = "";
        if (pVerList != null && !pVerList.isEmpty()) {
            int len = pVerList.size();
            for (int i = 0; i < len; ++i) {
                filePath = "nemgr" + File.separator + "device" + File.separator + domain + File.separator + pVerList.get(i) + File.separator + filename;
                if (!TEGetFilePath.isFileExist(bundlename, filePath)) continue;
                fileList.add(new String[]{bundlename, filePath});
            }
            String version = versionRelation.gerParentVersion(neType, hostVersion);
            if (!version.equals(hostVersion)) {
                TEGetFilePath.getFilePathes(neType, domain, bundlename, version, filename, fileList);
            }
        } else {
            String version;
            filePath = "nemgr" + File.separator + "device" + File.separator + domain + File.separator + "ne_" + neType + File.separator + hostVersion + File.separator + filename;
            if (TEGetFilePath.isFileExist(bundlename, filePath)) {
                fileList.add(new String[]{bundlename, filePath});
            }
            if (!(version = versionRelation.gerParentVersion(neType, hostVersion)).equals(hostVersion)) {
                TEGetFilePath.getFilePathes(neType, domain, bundlename, version, filename, fileList);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isFileExist(String bundlename, String filePath) {
        InputStream in = null;
        boolean bExist = false;
        try {
            in = TEResourceManager.getInputStream(bundlename, filePath);
            if (null != in && 0 != in.available()) {
                bExist = true;
            }
        }
        catch (IOException e) {
            TELogFactory.getNormalLogger().error("TEGetFilePath.getQXandFuncFilePath() fail!", (Throwable)e);
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    TELogFactory.getNormalLogger().error("TEGetFilePath.getQXandFuncFilePath() fail!", (Throwable)e);
                }
            }
        }
        return bExist;
    }

    public static String getFirstVersion(int neType, String verId) {
        return TEVersionRelationBean.getInstance().getFirstVersion(neType, verId);
    }

    public static TEResourceUtil getResource(int neId, String filePath) {
        String path = "nemgr" + File.separator + filePath;
        return TEResourceUtil.getInstance(path);
    }

    public static TEResourceUtil getResource(int neId, StringBuffer filePath) {
        return TEGetFilePath.getResource(neId, filePath.toString());
    }

    public static String getNEDomain(int neType) {
        return TEGetNEDomainVersion.getInstance().getDomain(neType);
    }

    public static String getNEBundleName(int neType) {
        return TEGetNEDomainVersion.getInstance().getBundleName(neType);
    }

    public static String getNEBundleName(int neType, String bundleType) {
        String domain = TEGetFilePath.getNEDomain(neType);
        String bundleName = "com.huawei.weblct." + domain + "_" + bundleType;
        return bundleName;
    }

    public static String getDomainFilePath(int neid, String filename) {
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        int neType = ne.getNEType();
        String domain = TEGetNEDomainVersion.getInstance().getDomain(neType);
        String filePath = "nemgr" + File.separator + domain + File.separator + filename;
        String bundlename = TEGetFilePath.getNEBundleName(neType, "domain");
        File file = TEResourceManager.getFileByName(bundlename, filePath);
        if (null == file || !file.exists()) {
            if (domain.equalsIgnoreCase("tl1ngwdm")) {
                filePath = "nemgr" + File.separator + "tl1necommon" + File.separator + filename;
                bundlename = "com.huawei.weblct.tl1necommon";
            } else {
                filePath = "nemgr" + File.separator + "necommon" + File.separator + filename;
                bundlename = "com.huawei.weblct.necommon";
            }
            file = TEResourceManager.getFileByName(bundlename, filePath);
            if (null == file || !file.exists()) {
                filePath = "nemgr" + File.separator + filename;
            }
        }
        return filePath;
    }

    public static String getDomainFilePathAndBundleName(int neid, String filename, StringBuffer domainbundleName) {
        File file;
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        int neType = ne.getNEType();
        String domain = TEGetNEDomainVersion.getInstance().getDomain(neType);
        String filePath = "nemgr" + File.separator + domain + File.separator + filename;
        String bundleName = TEGetFilePath.getNEBundleName(neType, "domain");
        if (filename.indexOf("ason") >= 0) {
            filePath = "nemgr" + File.separator + "ason" + File.separator + domain + File.separator + filename;
            bundleName = TEGetFilePath.getNEBundleName(neType, "ason");
        }
        if (domain.equalsIgnoreCase("tl1ngwdm")) {
            bundleName = "com.huawei.weblct." + domain;
        }
        if (null == (file = TEResourceManager.getFileByName(bundleName, filePath)) || !file.exists()) {
            if (domain.equalsIgnoreCase("tl1ngwdm") || neType == 72 && domain.equalsIgnoreCase("marine")) {
                filePath = "nemgr" + File.separator + "tl1necommon" + File.separator + filename;
                bundleName = "com.huawei.weblct.tl1necommon";
            } else {
                filePath = "nemgr" + File.separator + "necommon" + File.separator + filename;
                bundleName = "com.huawei.weblct.necommon";
            }
            file = TEResourceManager.getFileByName(bundleName, filePath);
            if (null == file || !file.exists()) {
                filePath = "nemgr" + File.separator + filename;
            }
        }
        domainbundleName.append(bundleName);
        return filePath;
    }
}

