/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.util.io;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.util.string.TEConvertUtil;
import com.huawei.nglct.util.system.TESystemUtil;
import com.huawei.nglct.util.xml.TERWCfgFile;
import com.huawei.nglct.util.xml.TEResourceManager;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;

public class TEFileUtil {
    private static String CreateSessionDir(String sessionid, String neid) {
        String dir = File.separator + "report";
        try {
            dir = TERWCfgFile.getBundleRWCfgFilePath(TEResourceManager.class, dir);
            dir = dir + File.separator + sessionid + File.separator + neid;
            if (TEFileUtil.makedir(dir)) {
                return dir;
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("get report path error", (Throwable)e);
        }
        return null;
    }

    public static void SaveFile(String sessionid, String neid, String fileName, String content) {
        String basePath = TEFileUtil.CreateSessionDir(sessionid, neid);
        if (null != basePath) {
            String fName = basePath + File.separator + fileName;
            File file = new File(fName);
            if (file.exists()) {
                file.delete();
            }
            try {
                BufferedWriter out = new BufferedWriter(new FileWriter(fName));
                out.write(content);
                out.flush();
                out.close();
            }
            catch (IOException e) {
                TELogFactory.getNormalLogger().error("save file error," + fName, (Throwable)e);
            }
        }
    }

    public static void SaveFile(String sessionid, String neid, String fileName, byte[] bytesout) {
        String basePath = TEFileUtil.CreateSessionDir(sessionid, neid);
        if (null != basePath) {
            String fName = basePath + File.separator + fileName;
            File file = new File(fName);
            if (file.exists()) {
                file.delete();
            }
            try {
                FileOutputStream fout = new FileOutputStream(fName);
                fout.write(bytesout);
                fout.close();
            }
            catch (IOException e) {
                TELogFactory.getNormalLogger().error("save file error," + fName, (Throwable)e);
            }
        }
    }

    public static boolean makedir(String dirname) {
        File dir = new File(dirname);
        if (dir.exists()) {
            return true;
        }
        boolean success = new File(dirname).mkdirs();
        if (!success) {
            TELogFactory.getNormalLogger().error("can'nt create directory:" + dirname);
        }
        return success;
    }

    public static boolean deleteDir(File dir) {
        if (dir == null) {
            return false;
        }
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = TEFileUtil.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public static String getParentPath(String strPath) {
        String[] strTemp = new String[]{strPath};
        if (0 != TEConvertUtil.convertAbsolutePath(strTemp)) {
            return "";
        }
        int nPosSep = strTemp[0].lastIndexOf("/");
        if (nPosSep == strTemp[0].length() - 1) {
            strTemp[0] = strTemp[0].substring(0, nPosSep);
        }
        strTemp[0] = -1 != (nPosSep = strTemp[0].lastIndexOf("/")) ? strTemp[0].substring(0, nPosSep) : "";
        return strTemp[0];
    }

    public static boolean getNemgrCfgFile(String[] str) {
        str[0] = TEFileUtil.getParentPath(TESystemUtil.getIMAPPath()) + "/nemgr/nemgr_rtn/bin/";
        str[0] = str[0] + "../conf/nemgr.cfg";
        TEConvertUtil.convertAbsolutePath(str);
        return true;
    }

    public static String getCoreFile(String str) {
        String strFileName = TESystemUtil.getIMAPPath();
        if (!"".equals(strFileName)) {
            strFileName = str.endsWith("/") || str.endsWith("\\") ? strFileName + "../core/conf" + str : strFileName + "../core/conf/" + str;
        }
        return strFileName;
    }
}

