/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.util.hfcpfiledata;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.neinterface.neadapter.hfcpadapter.TEHFCPHandler;
import com.huawei.nglct.util.hfcpfiledata.TEHFCPFile;
import com.huawei.nglct.util.hfcpfiledata.TEHFCPFileAdapter;
import com.huawei.nglct.util.hfcpfiledata.TEHFCPFileCopyHandler;
import com.huawei.nglct.util.hfcpfiledata.TEHFCPFileMgr;
import org.slf4j.Logger;

public class TEHFCPFileUtil {
    private static Logger log = TELogFactory.getHFCPFileTransferLogger();
    private static final int BRBASE_UPLOAD_TYPE = 1;
    private static final int BRBASE_DOWNLOAD_TYPE = 2;

    public static int sendFileToNE(String ipAddress, int neid, String neFilePath, String localFilePath, String fileName) {
        log.info("<HFCP> Send File ---- IP address is : " + ipAddress + "File name is : " + fileName + "NE File Path is : " + neFilePath + "Local File Path is : " + localFilePath);
        int isSuccess = 0;
        if (null != TEHFCPFileMgr.instance().findFile(neid)) {
            log.info("<HFCP> Send File ---- The file " + fileName + " is being translated!");
            return 1090613365;
        }
        isSuccess = TEHFCPFileMgr.instance().registerFile(neid, neFilePath, localFilePath, fileName, 2);
        if (0 != isSuccess) {
            log.info("<HFCP> Send File ---- The registration  of the file : " + fileName + " failed!result is : " + isSuccess);
            TEHFCPFileMgr.instance().delFile(neid);
            return isSuccess;
        }
        TEHFCPFile hfcpFile = TEHFCPFileMgr.instance().getFile(neid);
        isSuccess = TEHFCPFileAdapter.sendFile(hfcpFile.getFileData(), neFilePath, localFilePath, fileName, neid);
        log.info("<HFCP> Send File ---- Send file result is " + isSuccess);
        TEHFCPFileMgr.instance().delFile(neid);
        log.info("<HFCP> Send File ---- End!");
        return isSuccess;
    }

    public static int getFileFromNE(String ipAddress, int neid, String neFilePath, String localFilePath, String fileName) {
        log.info("<HFCP> Get File ---- IP address is : " + ipAddress + "File name is : " + fileName + "NE File Path is : " + neFilePath + "Local File Path is : " + localFilePath);
        int isSuccess = 0;
        if (null != TEHFCPFileMgr.instance().findFile(neid)) {
            log.info("<HFCP> Get File ---- The file " + fileName + " is being translated!");
            return 1090613365;
        }
        isSuccess = TEHFCPFileMgr.instance().registerFile(neid, neFilePath, localFilePath, fileName, 1);
        if (0 != isSuccess) {
            log.info("<HFCP> Get File ---- The registration  of the file : " + fileName + " failed! result is : " + isSuccess);
            TEHFCPFileMgr.instance().delFile(neid);
            return isSuccess;
        }
        byte[] fileData = TEHFCPFileAdapter.getFile(neFilePath, localFilePath, fileName, neid);
        TEHFCPFileMgr.instance().delFile(neid);
        isSuccess = TEHFCPHandler.instance().getRet();
        if ((null == fileData || fileData.length == 0) && isSuccess != 0) {
            log.info("<HFCP> Get File ---- The file length is 0 or file is null!");
            return isSuccess;
        }
        String filePathName = localFilePath + fileName;
        int write2FileResult = TEHFCPFileCopyHandler.writeFile(filePathName, fileData);
        return write2FileResult;
    }

    public static int getFileTransferProgress(int neid) {
        TEHFCPFile hfcpFile = TEHFCPFileMgr.instance().getFile(neid);
        if (null == hfcpFile) {
            return -1;
        }
        return TEHFCPFileAdapter.getTransferProgress(neid);
    }

    public static void deleteRawFileFromNE(int neID, String absFilePathName) {
        TEHFCPFileCopyHandler.deleteRawFileFromNE(absFilePathName);
    }

    public static Object acquireFileReadWriteLock(String absFilePathName) {
        return TEHFCPFileCopyHandler.acquireFileReadWriteLock(absFilePathName);
    }
}

