/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.util.hfcpfiledata;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.util.hfcpfiledata.TEHFCPFile;
import com.huawei.nglct.util.hfcpfiledata.TEHFCPFileCopyHandler;
import com.huawei.nglct.util.innerevent.delneevent.TEInnerDelNEEventCenter;
import com.huawei.nglct.util.innerevent.delneevent.TEInnerDelNEEventMsg;
import com.huawei.nglct.util.innerevent.delneevent.TEInnerDelNEObserver;
import gnu.trove.TIntObjectHashMap;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;

public class TEHFCPFileMgr {
    private static Logger log = TELogFactory.getHFCPFileTransferLogger();
    private static final int BRBASE_DOWNLOAD_TYPE = 2;
    private static TEHFCPFileMgr hfcpFileMgr = new TEHFCPFileMgr();
    private TIntObjectHashMap<TEHFCPFile> fileMap = new TIntObjectHashMap();
    private final Map<String, Object> fileInDiskReadWriteLockMap = new HashMap<String, Object>();

    private TEHFCPFileMgr() {
    }

    private static void receiveNEDelEvent(TEInnerDelNEEventMsg eventMsg) {
        TEHFCPFileMgr.instance().delFile(eventMsg.getLogicNEID());
    }

    public static TEHFCPFileMgr instance() {
        return hfcpFileMgr;
    }

    public TEHFCPFile getFile(int neid) {
        return this.findFile(neid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TEHFCPFile addFile(int neid) {
        log.info("<HFCP> File Management ---- Add file of the NE : " + neid + " begin!");
        TIntObjectHashMap<TEHFCPFile> tIntObjectHashMap = this.fileMap;
        synchronized (tIntObjectHashMap) {
            TEHFCPFile hfcpFile = this.findFile(neid);
            if (null == hfcpFile) {
                log.info("<HFCP> File Management ---- The added file is not exist!");
                hfcpFile = new TEHFCPFile(neid);
                log.info("<HFCP> File Management ---- Create file object of the NE : " + neid);
                this.fileMap.put(neid, (Object)hfcpFile);
            }
            log.info("<HFCP> File Management ---- The added file of the NE : " + neid + " is " + hfcpFile.getFileName());
            return hfcpFile;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TEHFCPFile delFile(int neid) {
        TIntObjectHashMap<TEHFCPFile> tIntObjectHashMap = this.fileMap;
        synchronized (tIntObjectHashMap) {
            TEHFCPFile hfcpFile = this.getFile(neid);
            if (null != hfcpFile) {
                this.removeFileInDiskLock(hfcpFile.getLocalFilePath());
            }
            return (TEHFCPFile)this.fileMap.remove(neid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TEHFCPFile findFile(int neid) {
        log.info("<HFCP> File Management ---- Find file begin");
        log.info("<HFCP> File Management ---- The NEID of the file is : " + neid);
        log.info("<HFCP> File Management ---- The file list size is : " + this.fileMap.size());
        TEHFCPFile hfcpFile = null;
        TIntObjectHashMap<TEHFCPFile> tIntObjectHashMap = this.fileMap;
        synchronized (tIntObjectHashMap) {
            hfcpFile = (TEHFCPFile)this.fileMap.get(neid);
        }
        if (null != hfcpFile) {
            log.info("<HFCP> File Management ---- Find file " + hfcpFile.getFileName());
        } else {
            log.info("<HFCP> File Management ---- Didn't found the file of the NE : " + neid);
        }
        return hfcpFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAllFile() {
        TIntObjectHashMap<TEHFCPFile> tIntObjectHashMap = this.fileMap;
        synchronized (tIntObjectHashMap) {
            this.delFileInDiskLock();
            this.fileMap.clear();
        }
    }

    public int registerFile(int neid, String neFilePath, String localFilePath, String fileName, int sendType) {
        log.info("<HFCP> File Management ---- Register the file : " + fileName + " begin!");
        int registeFlag = 0;
        TEHFCPFile hfcpFile = this.addFile(neid);
        hfcpFile.setNeFilePath(neFilePath);
        hfcpFile.setLocalFilePath(localFilePath);
        hfcpFile.setFileName(fileName);
        this.addFileInDiskLock(localFilePath);
        log.info("<HFCP> File Management ---- The registered file name is : " + fileName);
        log.info("<HFCP> File Management ---- The registered local file path is : " + localFilePath);
        log.info("<HFCP> File Management ---- The registered ne file path is : " + neFilePath);
        registeFlag = hfcpFile.checkFileNameVaild();
        if (0 != registeFlag) {
            log.info("<HFCP> File Management ---- Register the file result is  : " + registeFlag);
            return registeFlag;
        }
        String strPath = localFilePath + fileName;
        log.info("<HFCP> File Management ---- The send type is : " + sendType);
        if (2 == sendType) {
            log.info("<HFCP> File Management ---- the send type is download file to NE!");
            registeFlag = TEHFCPFileCopyHandler.checkFileValid(strPath);
            if (0 != registeFlag) {
                return registeFlag;
            }
            byte[] fileData = TEHFCPFileCopyHandler.getFileBytes(strPath);
            if (null == fileData) {
                fileData = new byte[]{};
            }
            hfcpFile.setFileData(fileData);
        } else {
            hfcpFile.setFileData(null);
        }
        return registeFlag;
    }

    public static TEHFCPFileMgr getHfcpFileMgr() {
        return hfcpFileMgr;
    }

    public static void setHfcpFileMgr(TEHFCPFileMgr hfcpFileMgr) {
        TEHFCPFileMgr.hfcpFileMgr = hfcpFileMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object acquireFileReadWriteLock(String absFilePath) {
        Map<String, Object> map = this.fileInDiskReadWriteLockMap;
        synchronized (map) {
            File file = new File(absFilePath);
            absFilePath = file.getAbsolutePath();
            log.info("HFCP ---- BEGIN to acquire file in disk lock, file->" + absFilePath);
            Object lock = this.fileInDiskReadWriteLockMap.get(absFilePath);
            if (null == lock) {
                lock = new Object();
                this.fileInDiskReadWriteLockMap.put(absFilePath, lock);
            }
            return lock;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFileInDiskLock(String absFilePath) {
        Map<String, Object> map = this.fileInDiskReadWriteLockMap;
        synchronized (map) {
            File file = new File(absFilePath);
            absFilePath = file.getAbsolutePath();
            log.info("HFCP ---- BEGIN to add file in disk lock, file->" + absFilePath);
            Object lock = this.fileInDiskReadWriteLockMap.get(absFilePath);
            if (null == lock) {
                lock = new Object();
                this.fileInDiskReadWriteLockMap.put(absFilePath, lock);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFileInDiskLock(String absPath) {
        Map<String, Object> map = this.fileInDiskReadWriteLockMap;
        synchronized (map) {
            File file = new File(absPath);
            absPath = file.getAbsolutePath();
            log.info("HFCP ---- BEGIN to remove file in disk lock, file->" + absPath);
            this.fileInDiskReadWriteLockMap.remove(absPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delFileInDiskLock() {
        Map<String, Object> map = this.fileInDiskReadWriteLockMap;
        synchronized (map) {
            log.info("HFCP ---- Clearing fileInDiskReadWriteLockMap!");
            this.fileInDiskReadWriteLockMap.clear();
        }
    }

    static {
        TEInnerDelNEEventCenter.getInstance().addObserver(new TEInnerDelNEObserver(){

            @Override
            public void handleDelNEEvent(TEInnerDelNEEventMsg eventMsg) {
                TEHFCPFileMgr.receiveNEDelEvent(eventMsg);
            }
        });
    }
}

