/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.util.hfcpfiledata;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.util.hfcpfiledata.TEHFCPFileMgr;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import org.slf4j.Logger;

public class TEHFCPFileCopyHandler {
    private static Logger log = TELogFactory.getHFCPFileTransferLogger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getFileBytes(String fileName) {
        log.info("<HFCP> File Copy Handler ---- Get file bytes begin!");
        byte[] fileContent = null;
        BufferedInputStream bufIn = null;
        try {
            log.info("<HFCP> File Copy Handler ---- The file name is : " + fileName);
            bufIn = new BufferedInputStream(new FileInputStream(fileName));
            int availableSize = bufIn.available();
            log.info("<HFCP> File Copy Handler ---- The file size is : " + availableSize);
            if (availableSize <= 0) {
                log.info("<HFCP> File Copy Handler ---- Get file bytes result is null! ");
                byte[] byArray = null;
                return byArray;
            }
            fileContent = new byte[availableSize];
            Object object = TEHFCPFileMgr.instance().acquireFileReadWriteLock(fileName);
            synchronized (object) {
                bufIn.read(fileContent);
            }
            bufIn.close();
        }
        catch (FileNotFoundException e) {
            log.info("<HFCP> File Copy Handler ---- Get file exception!");
            log.info("", (Throwable)e);
        }
        catch (IOException e) {
            log.info("<HFCP> File Copy Handler ---- Get file exception!");
            log.info("", (Throwable)e);
        }
        catch (Exception e) {
            log.info("<HFCP> File Copy Handler ---- Get file exception!");
            log.info("", (Throwable)e);
        }
        finally {
            if (null != bufIn) {
                try {
                    bufIn.close();
                }
                catch (IOException e) {
                    log.info("", (Throwable)e);
                }
            }
        }
        log.info("<HFCP> File Copy Handler ---- Get file bytes success!");
        return fileContent;
    }

    public static int checkFileValid(String fileName) {
        log.info("<HFCP> File Copy Handler ---- Check file valid!");
        try {
            log.info("<HFCP> File Copy Handler ---- The checked file name is : " + fileName);
            File file = new File(fileName);
            if (!file.exists()) {
                log.info("<HFCP> File Copy Handler ---- The checked file is not exist!");
                log.info("<HFCP> File Copy Handler ---- Check file result is :  -1");
                return -1;
            }
        }
        catch (Exception e) {
            log.info("<HFCP> File Copy Handler ---- The checked file exception!");
            log.info("", (Throwable)e);
        }
        log.info("<HFCP> File Copy Handler ---- Check file result is : 0");
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int writeFile(String fileName, byte[] fileData) {
        log.info("<HFCP> File Copy Handler ---- Write the file : " + fileName + " to local!");
        if (null == fileData || 0 == fileData.length) {
            log.info("<HFCP> File Copy Handler ---- writeFile is failed! The fileData is null or its length is 0.");
            return 1090615269;
        }
        FilterOutputStream bufOut = null;
        File file = new File(fileName);
        try {
            if (file.exists()) {
                log.info("<HFCP> File Copy Handler ---- The written file is not exist!");
                log.info("<HFCP> File Copy Handler ---- Write file result is : 1090613368");
                int n = 1090613368;
                return n;
            }
            Object object = TEHFCPFileMgr.instance().acquireFileReadWriteLock(fileName);
            synchronized (object) {
                bufOut = new BufferedOutputStream(new FileOutputStream(fileName));
                ((BufferedOutputStream)bufOut).write(fileData, 0, fileData.length);
                ((BufferedOutputStream)bufOut).flush();
                bufOut.close();
            }
        }
        catch (Exception e) {
            log.info("<HFCP> File Copy Handler ---- Write file exception! fileName= " + fileName);
            log.info("", (Throwable)e);
            TEHFCPFileCopyHandler.deleteRawFileFromNE(fileName);
            int n = 2;
            return n;
        }
        finally {
            if (null != bufOut) {
                try {
                    bufOut.close();
                }
                catch (IOException e) {
                    log.info("", (Throwable)e);
                }
            }
        }
        log.info("<HFCP> File Copy Handler ---- Write file result is : 0");
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteRawFileFromNE(String absFilePathName) {
        Object object = TEHFCPFileMgr.instance().acquireFileReadWriteLock(absFilePathName);
        synchronized (object) {
            File file = new File(absFilePathName);
            if (file.exists() && file.isFile()) {
                file.delete();
            }
        }
    }

    public static Object acquireFileReadWriteLock(String absFilePathName) {
        return TEHFCPFileMgr.instance().acquireFileReadWriteLock(absFilePathName);
    }
}

