/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.util.hfcpfiledata;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.jni.hfcp.TEHFCPFileService;
import com.huawei.nglct.neinterface.neadapter.hfcpadapter.TEHFCPHandler;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import java.io.File;
import org.slf4j.Logger;

public class TEHFCPFileAdapter {
    private static Logger log = TELogFactory.getHFCPFileTransferLogger();

    public static int sendFile(byte[] fileData, String neFilePath, String localFilePath, String fileName, int neid) {
        int ret = 0;
        if (TESysManagerBean.getInstance().isIntegratedStatus()) {
            TEHFCPFileService.sendFileWait(fileData, neFilePath, fileName, neid);
        } else {
            log.info("<HFCP> File Adapter ---- HFCP file adapter send file " + fileName + " begin!");
            ret = TEHFCPHandler.instance().sendHFCPFile(fileData, neFilePath, localFilePath, fileName, neid);
            log.info("<HFCP> File Adapter ---- HFCP file adapter send file result is : " + ret);
        }
        return ret;
    }

    public static byte[] getFile(String neFilePath, String localFilePath, String fileName, int neid) {
        byte[] fileData = null;
        if (TESysManagerBean.getInstance().isIntegratedStatus()) {
            fileData = TEHFCPFileService.getFileWait(neFilePath + File.separator + fileName, fileName, neid);
        } else {
            log.info("<HFCP> File Adapter ---- HFCP file adapter get file " + fileName + " from NE begin!");
            fileData = TEHFCPHandler.instance().getHFCPFile(neFilePath, localFilePath, fileName, neid);
        }
        return fileData;
    }

    public static int getTransferProgress(int neid) {
        return TEHFCPHandler.instance().getTransferProgress(neid);
    }
}

