/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.util.fdn;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.nemgr.f_interface.asncommon.AsnBMSDistinguishedResourceSeqOf;
import com.huawei.nglct.nemgr.f_interface.asncommon.AsnCommonResource;
import com.huawei.nglct.util.fdn.TopoAgentResource;
import java.math.BigInteger;
import java.util.StringTokenizer;
import java.util.Vector;
import org.slf4j.Logger;

public class ResourceUtil {
    private static Logger normalLogger = TELogFactory.getNormalLogger();

    public static String getShortResID(String resID) {
        if (resID != null && resID.indexOf(".-1") != -1) {
            return resID.substring(0, resID.indexOf(".-1"));
        }
        return resID;
    }

    public static AsnCommonResource chgToResAsn(String resID) {
        return ResourceUtil.chgToResAsn(resID, -1, -1);
    }

    public static AsnCommonResource chgToResAsn(String resID, int mainType, int subType) {
        AsnCommonResource resAsn = new AsnCommonResource();
        resAsn.resID = ResourceUtil.chgToResIDObj(resID);
        if (mainType > 0) {
            resAsn.maintype = mainType;
        }
        if (subType > 0) {
            resAsn.subtype = subType;
        }
        return resAsn;
    }

    public static AsnBMSDistinguishedResourceSeqOf chgToResIDObj(String resID) {
        return ResourceUtil.chgToResIDObj(resID, true);
    }

    public static AsnBMSDistinguishedResourceSeqOf chgToResIDObj(String resID, boolean bIncludeEmpty) {
        int i;
        if (resID == null || resID.length() == 0) {
            return null;
        }
        AsnBMSDistinguishedResourceSeqOf asnDistinguishedResourceSeqOf = new AsnBMSDistinguishedResourceSeqOf();
        Vector resIDVec = TopoAgentResource.stringToResID(resID);
        if (resIDVec == null) {
            return null;
        }
        int resIDCnt = resIDVec.size();
        for (i = 0; i < resIDCnt; ++i) {
            asnDistinguishedResourceSeqOf.add(i, resIDVec.get(i));
        }
        for (i = resIDCnt; i < 8; ++i) {
            asnDistinguishedResourceSeqOf.add(i, (Object)new BigInteger("-1"));
        }
        return asnDistinguishedResourceSeqOf;
    }

    public static String chgToString(Vector resIDVec) {
        int resIDCnt;
        for (int i = resIDCnt = resIDVec.size(); i < 8; ++i) {
            resIDVec.add(i, new BigInteger("-1"));
        }
        return ResourceUtil.resIDToTopoString(resIDVec);
    }

    public static String chgToString(Vector resIDVec, int layerIndex) {
        Vector v = (Vector)resIDVec.clone();
        int size = v.size();
        for (int i = layerIndex; i < size; ++i) {
            v.setElementAt(new BigInteger("-1"), i);
        }
        return ResourceUtil.chgToString(v);
    }

    public static String resIDToTopoString(Vector resVec) {
        if (resVec == null || resVec.isEmpty()) {
            return null;
        }
        StringBuffer strBuff = new StringBuffer();
        for (int i = 0; i < resVec.size() - 1; ++i) {
            strBuff.append(resVec.get(i)).append('.');
        }
        strBuff.append(resVec.get(resVec.size() - 1));
        return strBuff.toString();
    }

    public static String resIDToNodeID(String resID) {
        int i = 0;
        Vector<BigInteger> vt = new Vector<BigInteger>(8);
        for (i = 0; i < 8; ++i) {
            vt.add(i, new BigInteger("-1"));
        }
        AsnBMSDistinguishedResourceSeqOf vtDev = ResourceUtil.chgToResIDObj(resID);
        if (vtDev.size() < 2 && !vtDev.isEmpty()) {
            vt.set(0, (BigInteger)vtDev.get(0));
            vt.set(1, BigInteger.ZERO);
        } else {
            vt.set(0, (BigInteger)vtDev.get(0));
            vt.set(1, (BigInteger)vtDev.get(1));
        }
        return ResourceUtil.chgToString(vt);
    }

    public static String getDeviceIDByResourceID(String resID) {
        return ResourceUtil.getStringIndexOf(resID, 1);
    }

    public static String getFrameIDByChildID(String frameChildID) {
        return ResourceUtil.getStringIndexOf(frameChildID, 2);
    }

    public static int getFrameID(String resID) {
        return Integer.parseInt(ResourceUtil.getResourceIndex(ResourceUtil.getFrameIDByChildID(resID)));
    }

    public static int getBoardID(String resID) {
        return Integer.parseInt(ResourceUtil.getResourceIndex(ResourceUtil.getBoardIDByChildID(resID)));
    }

    public static int getSubslotID(String resID) {
        return Integer.parseInt(ResourceUtil.getResourceIndex(ResourceUtil.getSubslotIDByChildID(resID)));
    }

    public static int getPortID(String resID) {
        return Integer.parseInt(ResourceUtil.getResourceIndex(ResourceUtil.getPortIDByChildID(resID)));
    }

    public static String getBoardIDByChildID(String boardChildID) {
        return ResourceUtil.getStringIndexOf(boardChildID, 3);
    }

    public static String getSubslotIDByChildID(String portId) {
        return ResourceUtil.getStringIndexOf(portId, 4);
    }

    public static String getPortIDByChildID(String subPortID) {
        return ResourceUtil.getStringIndexOf(subPortID, 5);
    }

    public static String getOntIDByChildID(String resID) {
        return ResourceUtil.getStringIndexOf(resID, 6);
    }

    public static String getStringIndexOf(String resID, int resLayer) {
        AsnBMSDistinguishedResourceSeqOf tmp = ResourceUtil.chgToResIDObj(resID);
        for (int i = resLayer; i < tmp.size(); ++i) {
            tmp.set(i, new BigInteger("-1"));
        }
        return ResourceUtil.chgToString((Vector)tmp);
    }

    public static String getResourceIndex(String strResID) {
        String tmpID = strResID.substring(0, strResID.indexOf(".-1"));
        tmpID = tmpID.substring(tmpID.lastIndexOf(".") + 1);
        return tmpID;
    }

    public static int getResourceIndex(AsnCommonResource asnRes) {
        String strResID = ResourceUtil.chgToString((Vector)asnRes.resID);
        strResID = ResourceUtil.getResourceIndex(strResID);
        return Integer.parseInt(strResID);
    }

    public static int getFrameIndexByChild(AsnCommonResource asnRes) {
        return ((BigInteger)asnRes.resID.get(1)).intValue();
    }

    public static int getBoardIndexByChild(AsnCommonResource asnRes) {
        return ((BigInteger)asnRes.resID.get(2)).intValue();
    }

    public static int getSubSlotIndexByRes(AsnCommonResource subChildRes) {
        return ((BigInteger)subChildRes.resID.get(3)).intValue();
    }

    public static int getPortIndexByChild(AsnCommonResource asnRes) {
        return ((BigInteger)asnRes.resID.get(4)).intValue();
    }

    public static boolean isDevResByResID(String strResID) {
        return 1 == ResourceUtil.getResLayerCount(strResID) && strResID.indexOf("S") == -1;
    }

    public static boolean isFrameResByResID(String strResID) {
        return 2 == ResourceUtil.getResLayerCount(strResID);
    }

    public static boolean isCardResByResID(String strResID) {
        return 3 == ResourceUtil.getResLayerCount(strResID);
    }

    public static boolean isSubslotResByResID(String strResID) {
        return 4 == ResourceUtil.getResLayerCount(strResID);
    }

    public static boolean isPortResByResID(String strResID) {
        return 5 == ResourceUtil.getResLayerCount(strResID);
    }

    public static boolean isONTResByResID(String strResID) {
        return 6 == ResourceUtil.getResLayerCount(strResID);
    }

    public static boolean isSubmapResByResID(String strResID) {
        return strResID.indexOf("S") != -1;
    }

    public static int getResLayerCount(String strResID) {
        String tmp = strResID;
        if (tmp.indexOf(".-1") > -1) {
            tmp = tmp.substring(0, tmp.indexOf(".-1"));
        }
        StringTokenizer k = new StringTokenizer(tmp, ".");
        return k.countTokens();
    }

    public static int getDevID(Vector resID) {
        String devIDStr = ResourceUtil.chgToString(resID, 1);
        return ResourceUtil.getDevID(devIDStr);
    }

    public static int getDevID(String resID) {
        try {
            int index = resID.indexOf(".");
            if (index != -1) {
                String devIDStr = resID.substring(0, index);
                return Integer.parseInt(devIDStr);
            }
            return Integer.parseInt(resID);
        }
        catch (Exception ex) {
            normalLogger.error("error:", (Throwable)ex);
            return -1;
        }
    }

    public static boolean isSameDevice(String resID1, String resID2) {
        String subStr1 = resID1.substring(0, resID1.indexOf("."));
        return resID2.startsWith(subStr1);
    }

    public static long getLocalIDbyResID(AsnCommonResource oResID) {
        int imaintype = 0;
        int iDevID = 0;
        int iFrameID = 0;
        int iSlotID = 0;
        int iVirtualFlag = 0;
        int iSubSlotID = 0;
        int iPortID = 0;
        try {
            AsnBMSDistinguishedResourceSeqOf resID = oResID.resID;
            if (resID == null) {
                return -1L;
            }
            imaintype = oResID.maintype;
            iDevID = Integer.parseInt(String.valueOf(resID.get(0))) - 0x700000;
            iFrameID = Integer.parseInt(String.valueOf(resID.get(1)));
            if (iFrameID == -1) {
                iFrameID = 0;
            }
            if ((iSlotID = Integer.parseInt(String.valueOf(resID.get(2)))) == -1) {
                iSlotID = 0;
            }
            if ((iSubSlotID = Integer.parseInt(String.valueOf(resID.get(3)))) == -1) {
                iSubSlotID = 0;
            }
            if ((iPortID = Integer.parseInt(String.valueOf(resID.get(4)))) == -1) {
                iPortID = 0;
            }
            if (65535 == iSubSlotID) {
                iVirtualFlag = 1;
                iSubSlotID = 0;
            } else {
                iVirtualFlag = 0;
            }
        }
        catch (NumberFormatException e) {
            normalLogger.error("error:", (Throwable)e);
        }
        long omaintype = imaintype & 0x3FF;
        long oDevID = iDevID & 0xFFFFF;
        long oFrameID = iFrameID & 0x7FF;
        long oSlotID = iSlotID & 0xFF;
        long oVirtualFlag = iVirtualFlag & 1;
        long oSubSlotID = iSubSlotID & 0xF;
        long oPortID = iPortID & 0xFF;
        long oLocalID = omaintype << 52 | oDevID << 32 | oFrameID << 21 | oSlotID << 13 | oVirtualFlag << 12 | oSubSlotID << 8 | oPortID;
        return oLocalID;
    }

    public static String[] fastSplit(String strInput, String strSeperator) {
        String[] values;
        if (strInput.startsWith(strSeperator)) {
            values = new String[]{"", strInput.substring(strSeperator.length())};
        } else if (strInput.endsWith(strSeperator)) {
            values = new String[]{strInput.substring(0, strInput.length() - strSeperator.length())};
        } else {
            StringTokenizer token = new StringTokenizer(strInput, strSeperator);
            values = new String[token.countTokens()];
            if (values.length > 0) {
                int start = 0;
                while (token.hasMoreTokens()) {
                    values[start++] = token.nextToken();
                }
            } else {
                values = new String[]{strInput};
            }
        }
        return values;
    }
}

