/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.util.fdn;

import com.huawei.nglct.util.fdn.DomainIDEnum;
import com.huawei.nglct.util.fdn.FDNUtil;

public class PortFDNValue {
    private int portID;
    private int portType = -1;
    private DomainIDEnum domainID;
    private String cliName;

    public PortFDNValue(String fdnPortValue) {
        String[] values = FDNUtil.parseFDNValue(fdnPortValue);
        if (values.length < 3 || values[2].isEmpty()) {
            throw new IllegalArgumentException("fdnPortValue = " + fdnPortValue);
        }
        if (!values[0].isEmpty()) {
            this.domainID = DomainIDEnum.getEnum(Integer.parseInt(values[0]));
        }
        if (!values[1].isEmpty()) {
            this.portType = Integer.parseInt(values[1]);
        }
        this.portID = Integer.parseInt(values[2]);
        if (values.length == 4 && !values[3].isEmpty()) {
            this.cliName = FDNUtil.undoTransferMeaning(values[3]);
        }
    }

    public int getPortID() {
        return this.portID;
    }

    public int getPortType() {
        return this.portType;
    }

    public DomainIDEnum getDomainID() {
        return this.domainID;
    }

    public String getCLIName() {
        return this.cliName;
    }

    public static String buildFDNValue(int portID) {
        return FDNUtil.buildFDNValue("", "", String.valueOf(portID), "");
    }

    public static String buildFDNValue(int portID, int portType) {
        return FDNUtil.buildFDNValue("", String.valueOf(portType), String.valueOf(portID), "");
    }

    public static String buildFDNValue(int portID, int portType, DomainIDEnum domain, String cliName) {
        return FDNUtil.buildFDNValue(String.valueOf(domain.intValue()), String.valueOf(portType), String.valueOf(portID), cliName);
    }
}

