/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.util.fdn;

import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.ngwdm_pub.TEOTNModelDataMgr;
import com.huawei.nglct.ngwdm_pub.TEOTNModelShowPathMgr;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.fdn.FDNBuilder;
import com.huawei.nglct.util.fdn.FDNParser;
import com.huawei.nglct.util.fdn.FDNTypeEnum;
import com.huawei.nglct.util.fdn.PortFDNValue;
import com.huawei.nglct.util.fdn.ResourceUtil;

public final class FDNUtil {
    public static final int MAX_LEN = 255;
    public static final String SEPARATOR = ",";
    public static final String EQUIVALENCE = "=";
    public static final String MULTI_VALUE_SEPARATOR = "|";
    public static final String LEGAL_FDN_CHARACTER = "[\\x20-\\x7f]*";
    public static final String LEGAL_TYPE_CHARACTER = "[\\w\\-]*";
    public static final String LEGAL_VALUE_CHARACTER = "[\\x20-\\x7f]*";
    public static final String TRANSFER_CHARACTER = ".*[,=\\\\|].*";
    public static final String UNDO_TRANSFER_CHARACTER = ".*[\\\\c\\\\e\\\\\\|].*";
    public static final int[] FBTYPE_SUPPORTMOC = new int[]{4, 43, 44, 91, 93, 94, 92, 95, 96, 928, 925, 25, 200, 201, 202, 12, 57, 58, 203, 204, 205, 755, 832, 833, 834, 829, 831, 823, 825, 820, 822, 826, 828, 810, 812, 804, 806, 801, 803, 807, 809, 11, 59, 60, 841, 843};

    private FDNUtil() {
    }

    public static boolean checkFDN(String fdn) {
        String[] values;
        if (fdn == null || fdn.isEmpty()) {
            return false;
        }
        for (String value : values = ResourceUtil.fastSplit(fdn, SEPARATOR)) {
            String[] content = ResourceUtil.fastSplit(value, EQUIVALENCE);
            if (content.length != 2) {
                return false;
            }
            if (FDNUtil.checkFDNType(content[0]) && FDNUtil.checkFDNValue(content[1])) continue;
            return false;
        }
        return true;
    }

    public static boolean checkFDNType(String type) {
        return type != null && !type.isEmpty();
    }

    public static boolean checkFDNValue(String value) {
        return value != null && !value.isEmpty();
    }

    public static int getDevID(String fdn) {
        return new FDNParser(fdn).getIntValue(FDNTypeEnum.NE);
    }

    public static int getFrameID(String fdn) {
        return new FDNParser(fdn).getIntValue(FDNTypeEnum.FRAME);
    }

    public static int getSlotID(String fdn) {
        return new FDNParser(fdn).getIntValue(FDNTypeEnum.SLOT);
    }

    public static int getSubSlotID(String fdn) {
        return new FDNParser(fdn).getIntValue(FDNTypeEnum.SUB_SLOT);
    }

    public static int getPortID(String fdn) {
        String fdnValue = new FDNParser(fdn).getValue(FDNTypeEnum.PORT);
        if (null == fdnValue) {
            fdnValue = new FDNParser(fdn).getValue(FDNTypeEnum.LOGICAL_PORT);
        }
        return new PortFDNValue(fdnValue).getPortID();
    }

    public static String getFDN(String resID) {
        FDNBuilder builder = new FDNBuilder();
        int layer = ResourceUtil.getResLayerCount(resID);
        switch (layer - 1) {
            case 4: {
                String fdn = PortFDNValue.buildFDNValue(ResourceUtil.getPortID(resID));
                builder.append(FDNTypeEnum.PORT, fdn);
                builder.append(FDNTypeEnum.SUB_CARD, -1);
            }
            case 3: {
                builder.append(FDNTypeEnum.SUB_SLOT, ResourceUtil.getSubslotID(resID));
                builder.append(FDNTypeEnum.CARD, -1);
            }
            case 2: {
                builder.append(FDNTypeEnum.SLOT, ResourceUtil.getBoardID(resID));
            }
            case 1: {
                builder.append(FDNTypeEnum.FRAME, ResourceUtil.getFrameID(resID));
            }
            case 0: {
                builder.append(FDNTypeEnum.NE, ResourceUtil.getDevID(resID));
                break;
            }
        }
        return builder.getValue();
    }

    public static String getResID(String fdn) {
        FDNParser parser = new FDNParser(fdn);
        return FDNUtil.getResID(parser);
    }

    public static String getResID(FDNParser parser) {
        String port;
        if (parser.containsType(FDNTypeEnum.OS)) {
            return parser.getValue(FDNTypeEnum.OS);
        }
        String elementID = parser.getValue(FDNTypeEnum.ONE);
        if (elementID != null) {
            return elementID;
        }
        StringBuilder sb = new StringBuilder();
        String devID = parser.getValue(FDNTypeEnum.NE);
        if (devID == null) {
            throw new IllegalArgumentException("fdn = " + parser.getStrFDN());
        }
        sb.append(devID);
        String frame = parser.getValue(FDNTypeEnum.FRAME);
        if (frame == null) {
            return sb.toString();
        }
        sb.append('.');
        sb.append(frame);
        String slot = parser.getValue(FDNTypeEnum.SLOT);
        if (slot == null) {
            return sb.toString();
        }
        sb.append('.');
        sb.append(slot);
        String subSlot = parser.getValue(FDNTypeEnum.SUB_SLOT);
        if (subSlot != null) {
            sb.append('.');
            sb.append(subSlot);
        }
        if ((port = parser.getValue(FDNTypeEnum.PORT)) != null) {
            int portID = new PortFDNValue(port).getPortID();
            sb.append('.');
            sb.append(portID);
        }
        return sb.toString();
    }

    public static String buildFDNValue(String ... values) {
        String result;
        if (values.length == 0) {
            throw new IllegalArgumentException("values is empty");
        }
        if (values.length == 1) {
            result = FDNUtil.transferMeaning(values[0]);
        } else {
            StringBuilder sb = new StringBuilder();
            for (String value : values) {
                sb.append(FDNUtil.transferMeaning(value));
                sb.append(MULTI_VALUE_SEPARATOR);
            }
            sb.deleteCharAt(sb.length() - 1);
            result = sb.toString();
        }
        if (!FDNUtil.checkFDNValue(result)) {
            throw new IllegalArgumentException("result character is not valid: " + result);
        }
        return result;
    }

    public static String[] parseFDNValue(String fdnValue) {
        if (fdnValue == null) {
            throw new IllegalArgumentException("fdnValue == null");
        }
        if (!FDNUtil.checkFDNValue(fdnValue)) {
            throw new IllegalArgumentException("fdnValue = " + fdnValue);
        }
        return fdnValue.split("\\|");
    }

    public static String transferMeaning(String content) {
        return content;
    }

    public static String undoTransferMeaning(String content) {
        return content;
    }

    public static String getLSMPGFdnStr(int neID, int pgno) {
        FDNBuilder builder = new FDNBuilder();
        builder.append(FDNTypeEnum.NE, neID);
        String LMSP_FLAG = "L";
        String fdn = FDNUtil.buildFDNValue("L", String.valueOf(pgno));
        builder.append(FDNTypeEnum.MSPG, fdn);
        return builder.getValue();
    }

    public static String getLSMPGPortFdnStr(int neID, int slotID, int domianPortID) {
        FDNBuilder builder = new FDNBuilder();
        builder.append(FDNTypeEnum.NE, neID);
        int relativeSlotID = TEBoardUtil.bigSlotToSmall(slotID);
        builder.append(FDNTypeEnum.SLOT, relativeSlotID);
        builder.append(FDNTypeEnum.CARD, -1);
        int domainType = TEConfigurationDataMgr.getPortDomainType(domianPortID);
        int realPort = TEConfigurationDataMgr.getPortRelativeID(domianPortID);
        String fdn = FDNUtil.buildFDNValue(String.valueOf(domainType), "", String.valueOf(realPort), "");
        builder.append(FDNTypeEnum.PORT, fdn);
        return builder.getValue();
    }

    public static String getFdnStr(int neID, int slotID, int portID) {
        int shelfID;
        FDNBuilder builder = new FDNBuilder();
        builder.append(FDNTypeEnum.NE, neID);
        if (-1 != neID && -1 != (shelfID = TEBoardUtil.getSubrackIDFromSlot(neID, slotID))) {
            builder.append(FDNTypeEnum.FRAME, shelfID);
        }
        int relativeSlotID = TEBoardUtil.bigSlotToSmall(slotID);
        builder.append(FDNTypeEnum.SLOT, relativeSlotID);
        builder.append(FDNTypeEnum.CARD, -1);
        int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neID, slotID);
        int domain = TEConfigurationDataMgr.getInstance().getPortDomain(neID, boardType, portID);
        String fdn = FDNUtil.buildFDNValue(String.valueOf(domain), "", String.valueOf(portID), "");
        builder.append(FDNTypeEnum.PORT, fdn);
        return builder.getValue();
    }

    public static String getFdnStr(int oneID, int neID, int slotID, int portID, int pathID, String funBlockID, String funBlockName) {
        int boardType;
        FDNBuilder builder = new FDNBuilder();
        if (oneID > 0 && oneID != neID) {
            builder.append(FDNTypeEnum.ONE, oneID);
        }
        builder.append(FDNTypeEnum.NE, neID);
        if (slotID > 0) {
            int shelfID = TEBoardUtil.getSubrackIDFromSlot(neID, slotID);
            if (-1 != shelfID) {
                builder.append(FDNTypeEnum.FRAME, shelfID);
            }
            int relativeSlotID = TEBoardUtil.bigSlotToSmall(slotID);
            builder.append(FDNTypeEnum.SLOT, relativeSlotID);
            builder.append(FDNTypeEnum.CARD, -1);
        }
        if (portID > 0) {
            boardType = TEConfigurationDataMgr.getInstance().getBoardType(neID, slotID);
            int domain = TEConfigurationDataMgr.getInstance().getPortDomain(neID, boardType, portID);
            String fdn = FDNUtil.buildFDNValue(String.valueOf(domain), "", String.valueOf(portID), "");
            builder.append(FDNTypeEnum.PORT, fdn);
        }
        boardType = TEConfigurationDataMgr.getInstance().getBoardType(neID, slotID);
        if (TEOTNModelDataMgr.getInstance().isSimpleModelBoard(boardType) && pathID > 1280) {
            String path = TEOTNModelShowPathMgr.getInstance().getOTNModelShowPath(pathID);
            builder.append(FDNTypeEnum.PATH, path);
        } else if (pathID > 0) {
            if (FDNUtil.isSupportMOC(Integer.parseInt(funBlockID))) {
                builder.append(FDNTypeEnum.getTypeEnum(funBlockName), pathID);
            } else {
                String fdn = FDNUtil.buildFDNValue(funBlockID, String.valueOf(pathID), "", "");
                builder.append(FDNTypeEnum.FB, fdn);
            }
        }
        return builder.getValue();
    }

    public static boolean isSupportMOC(int fbType) {
        for (int type : FBTYPE_SUPPORTMOC) {
            if (type != fbType) continue;
            return true;
        }
        return false;
    }
}

