/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.util.fdn;

import java.util.HashMap;
import java.util.Map;

public enum FDNTypeEnum {
    OS("OS", 1),
    ONE("ONE", 3),
    NE("NE", 4),
    FRAME("FR", 5),
    SLOT("S", 6),
    CARD("CP", 7),
    SUB_SLOT("SS", 8),
    SUB_CARD("SC", 9),
    PORT("PP", 10, true),
    LOGICAL_PORT("LP", 11, true),
    ONU("ONU", 11),
    VR("VR", 12),
    VRF("VRF", 39, true),
    PW("PW", 13, true),
    AP("AP", 14, true),
    SUBIF("SUBIF", 15),
    OSCTRAIL("OSCTRAIL", 0),
    OSPF("OSPF", 0),
    OTNPG("OTNPG", 62, true),
    OTSTRAILL("OTSTRAILL", 0),
    OTUTRAIL("OTUTRAIL", 0),
    PPG("PPG", 0),
    PWE3("PWE3", 0, true),
    PWPG("PWPG", 0),
    PWSW("PWSW", 55, true),
    PWTMP("PWTMP", 0),
    QOS("QOS", 0),
    RIP("RIP", 0),
    RLINK("RLINK", 0),
    ROUTING("ROUTING", 0),
    RSTRAIL("RSTRAIL", 0),
    SDH_TRAIL("SDHTRAIL", 0),
    SNCPG("SNCPG", 0),
    SPITRAIL("SPITRAIL", 0),
    PORT_TYPE("T", 0),
    TDM_CONN("TDMCONN", 0),
    TDM_VCL("TDMVCL", 0),
    TPG("TPG", 0),
    TRUNK_LINK("TRUNKLINK", 0),
    TUNNEL("TUNNEL", 0, true),
    UNI("UNI", 0, true),
    VC12("VC12", 0),
    VC3("VC3", 0),
    VC4("VC4", 44),
    VFIBER("VFIBER", 0),
    VLAN("VLAN", 5),
    INNERVLAN("INNERVLAN", 6),
    VLINK("VLINK", 0),
    VPLS("VPLS", 0, true),
    VSI("VSI", 56, true),
    ATMTD("ATMTD", 0),
    BGP("BGP", 0),
    BGPPG("BGPPG", 48, true),
    CABLE("CABLE", 0),
    CLI_NAME("CLI_NAME", 12),
    CLIENTTRAIL("CLIENTTRAIL", 0),
    CSHPW("CSHPW", 0),
    DOMAIN("D", 0),
    E1("E1", 0),
    E3("E3", 0),
    E4("E4", 0),
    EPG("EPG", 0),
    EPL("EPL", 0),
    EPLAN("EPLAN", 0),
    EVPL("EVPL", 0),
    EVPLAN("EVPLAN", 0),
    FIBER("FIBER", 0),
    FLOWPARA("FLOWPARA", 0, true),
    IPLINK("IPLINK", 0),
    ISIS("ISIS", 0),
    L2LINK("L2LINK", 0),
    L3VPN("L3VPN", 0, true),
    LDPSESSION("LDPSESSION", 0),
    LSP("LSP", 57, true),
    MA("MA", 0),
    MEP("MEP", 0),
    MSPG("MSPG", 78),
    MSTPATMTRAIL("MSTPATMTRAIL", 0),
    MSTRAIL("MSTRAIL", 0),
    OCH("OCH", 12),
    CLIENT("CLIENT", 14),
    OMS("OMS", 13),
    ODU0("ODU0", 30),
    ODU1("ODU1", 31),
    ODU2("ODU2", 32),
    ODU3("ODU3", 33),
    ODU5G("ODU5G", 35),
    OTU1("OTU1", 31),
    OTU2("OTU2", 32),
    OTU3("OTU3", 33),
    OTU5G("OTU5G", 35),
    ODUFLEX("ODUflex", 35),
    OCHTRAIL("OCHTRAIL", 0),
    ODUTRAIL("ODUTRAIL", 0),
    OMSTRAIL("OMSTRAIL", 0),
    IGMPVLAN("IGMPVLAN", 13, true),
    IGMPUSER("IGMPUSER", 13),
    PVCID("PVCID", 13),
    VCL("VCL", 14, true),
    FLOWID("FLOWID", 13),
    MEDIAGATEWAY("MEDIAGATEWAY", 13),
    SIGNGATEWAY("SIGNGATEWAY", 13),
    ASSOCIATION("ASSOCIATION", 13),
    IMAGROUP("IMAGROUP", 13),
    IMALINK("IMALINK", 13),
    PROFILE("PROFILE", 13),
    GEMPORT("GEM", 15),
    V5INTERFACE("V5INTERFACE", 13),
    V5LINK("V5LINK", 14),
    V5CHANNEL("V5CHANNEL", 15),
    TDMVC12_BRANCEH("TDMVCLBRANCH", 13),
    BFD("BFD", 13, true),
    PATH("PATH", 13),
    FB("FB", 13),
    ERPS("ERPS", 15);

    private String type;
    private int serialNumber;
    private boolean allowMultiValue;
    private static Map<String, FDNTypeEnum> map;

    private FDNTypeEnum(String type, int serialNumber) {
        this.type = type;
        this.serialNumber = serialNumber;
        this.allowMultiValue = false;
    }

    private FDNTypeEnum(String type, int serialNumber, boolean allowMultiValue) {
        this(type, serialNumber);
        this.allowMultiValue = allowMultiValue;
    }

    public boolean allowMultiValue() {
        return this.allowMultiValue;
    }

    public int getSerialNumber() {
        return this.serialNumber;
    }

    public String strValue() {
        return this.type;
    }

    public static FDNTypeEnum getTypeEnum(String type) {
        return map.get(type);
    }

    static {
        map = new HashMap<String, FDNTypeEnum>(300);
        for (FDNTypeEnum fdn : FDNTypeEnum.values()) {
            map.put(fdn.type, fdn);
        }
    }
}

