/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.util.fdn;

import com.huawei.nglct.util.fdn.FDNTypeEnum;
import com.huawei.nglct.util.fdn.FDNUtil;
import com.huawei.nglct.util.fdn.ResourceUtil;
import java.util.HashMap;
import java.util.Map;

public class FDNParser {
    private Map<FDNTypeEnum, String> fdnMap;
    private String fdn;

    public FDNParser(String fdn) {
        this(fdn, true);
    }

    public FDNParser(String fdn, boolean check) {
        if (check && (fdn == null || fdn.isEmpty() || !FDNUtil.checkFDN(fdn))) {
            throw new IllegalArgumentException("uid = " + fdn);
        }
        this.fdnMap = new HashMap<FDNTypeEnum, String>();
        this.fdn = fdn;
        this.parse(fdn);
    }

    private void parse(String fdn) {
        String[] values;
        for (String value : values = ResourceUtil.fastSplit(fdn, ",")) {
            String[] content = ResourceUtil.fastSplit(value, "=");
            this.fdnMap.put(FDNTypeEnum.getTypeEnum(content[0]), FDNUtil.undoTransferMeaning(content[1]));
        }
    }

    public boolean containsType(String type) {
        return this.containsType(FDNTypeEnum.getTypeEnum(type));
    }

    public boolean containsType(FDNTypeEnum type) {
        return this.fdnMap.containsKey((Object)type);
    }

    public String getValue(String type) {
        return this.getValue(FDNTypeEnum.getTypeEnum(type));
    }

    public String getValue(FDNTypeEnum type) {
        return this.fdnMap.get((Object)type);
    }

    public int getIntValue(String type) {
        return this.getIntValue(FDNTypeEnum.getTypeEnum(type));
    }

    public int getIntValue(FDNTypeEnum type) {
        String value = this.getValue(type);
        if (null == value || value.isEmpty()) {
            return -1;
        }
        return Integer.parseInt(value);
    }

    public String getStrFDN() {
        return this.fdn;
    }
}

