/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.util.fdn;

import com.huawei.nglct.util.fdn.FDNTypeEnum;
import com.huawei.nglct.util.fdn.FDNUtil;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;

public class FDNBuilder {
    Map<FDNTypeEnum, String> fdnMap = new TreeMap<FDNTypeEnum, String>(new Comparator<FDNTypeEnum>(){

        @Override
        public int compare(FDNTypeEnum o1, FDNTypeEnum o2) {
            return o1.getSerialNumber() - o2.getSerialNumber();
        }
    });

    public FDNBuilder append(FDNTypeEnum type, String value) {
        if (type == null) {
            throw new IllegalArgumentException("type == null");
        }
        if (!FDNUtil.checkFDNValue(value)) {
            throw new IllegalArgumentException("value = " + value);
        }
        if (type.allowMultiValue()) {
            this.fdnMap.put(type, value);
        } else {
            this.fdnMap.put(type, FDNUtil.transferMeaning(value));
        }
        return this;
    }

    public FDNBuilder append(FDNTypeEnum type, int value) {
        return this.append(type, String.valueOf(value));
    }

    public String getValue() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<FDNTypeEnum, String> entry : this.fdnMap.entrySet()) {
            sb.append(entry.getKey().strValue());
            sb.append("=");
            sb.append(entry.getValue());
            sb.append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    public String toString() {
        return this.getValue();
    }
}

