/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.util.device.port;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.xmlinterpreter.SDXMLInterpreterMgr;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.nelist.model.TECircuitPackDescription;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.circuitpack.TECPAddiblePortRecord;
import com.huawei.nglct.nelist.model.circuitpack.TECPMappingAbility;
import com.huawei.nglct.nelist.model.datamgr.TEBoardConfigurationDataMgr;
import com.huawei.nglct.nelist.model.datamgr.TEPortModelConfigurationDataMgr;
import com.huawei.nglct.ngwdm_pub.TEOTNModelDataMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.string.TEConvertUtil;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TEVirtualPortUtil {
    private static final int ALL = 0;
    private static final int VSDH_BASE = 50;
    private static final int MIN_VSDH_PORT = 51;
    private static final int MAX_VSDH_PORT = 254;
    private static final int VETH_BASE = 40000;
    private static final int VPORTTYPE_STM16 = 1;
    private static final int VPORTTYPE_STM64 = 2;
    private static final int VPORTTYPE_SDH = 1;
    private static final int VPORTTYPE_ETH = 3;
    private static final int VPORTTYPE_INVALID = 255;
    private static final String PORTTYPE_SDH = "SDH";
    private static final String PORTTYPE_ETH = "ETH";
    private static Map<String, List<Map<String, Integer>>> odukToPathrange = new HashMap<String, List<Map<String, Integer>>>();
    private static final String CAPACITY_UNIT = "1.25G";

    public static boolean isMSOTNBoard(int bdType) {
        boolean result = false;
        List<TECPAddiblePortRecord> addPorts = TECircuitPackDescription.getInstance().getAddibleCPPort(bdType);
        for (TECPAddiblePortRecord portObj : addPorts) {
            if (!portObj.isVirtualPort()) continue;
            result = true;
            break;
        }
        return result;
    }

    public static boolean isMSOTNBoard(int neid, int slotid) {
        int boardType = TEBoardConfigurationDataMgr.getInstance().getBoardType(neid, slotid);
        return TEVirtualPortUtil.isMSOTNBoard(boardType);
    }

    public static String getVirtualPortName(int port) {
        StringBuilder portName = new StringBuilder();
        if (port >= 51 && port <= 254) {
            portName.append(port).append("(V_SDH-").append(port - 50).append(")");
        } else {
            portName.append(port).append("(V_ETH-").append(port - 40000).append(")");
        }
        return portName.toString();
    }

    public static String getVirtualPortNameWithoutPortid(int port) {
        StringBuilder portName = new StringBuilder();
        if (port >= 51 && port <= 254) {
            portName.append("V_SDH-").append(port - 50);
        } else {
            portName.append("V_ETH-").append(port - 40000);
        }
        return portName.toString();
    }

    public static boolean isVirtualPort(int bdType, int port, int level) {
        boolean result = false;
        TECPAddiblePortRecord portObj = TECircuitPackDescription.getInstance().getAddibleCPPort(bdType, port, level);
        if (portObj != null) {
            result = portObj.isVirtualPort();
        }
        return result;
    }

    public static boolean isSimpleVirtualBoard(int bdType) {
        boolean isSimpleVirtual = true;
        List<TECPAddiblePortRecord> addiblePorts = TECircuitPackDescription.getInstance().getAddibleCPPort(bdType);
        int len = addiblePorts.size();
        for (int i = 0; i < len; ++i) {
            if (addiblePorts.get(i).isVirtualPort()) continue;
            isSimpleVirtual = false;
            break;
        }
        return isSimpleVirtual;
    }

    public static boolean isVirtualPort(int bdType, int port, String level) {
        return TEVirtualPortUtil.isVirtualPort(bdType, port, SDXMLInterpreterMgr.getInstance().parseInt(level));
    }

    public static List<Integer> getMappingPortsByDomain(int bdType, int domain) {
        TECPMappingAbility mappingAbility = (TECPMappingAbility)((TECPMappingAbility)TECircuitPackDescription.getInstance().getMappingAbilityMap().get(bdType)).clone();
        return mappingAbility.getPortsByDomain(domain);
    }

    public static List<Integer> getVPortsByPortType(int bdType, int portType) {
        ArrayList<Integer> ports = new ArrayList<Integer>();
        if (portType == 0) {
            ports.addAll(TEConfigurationDataMgr.getInstance().getPortListFromPortType(0, bdType, 63210));
            ports.addAll(TEConfigurationDataMgr.getInstance().getPortListFromPortType(0, bdType, 63213));
        } else if (portType == 63210) {
            ports.addAll(TEConfigurationDataMgr.getInstance().getPortListFromPortType(0, bdType, 63210));
        } else if (portType == 63213) {
            ports.addAll(TEConfigurationDataMgr.getInstance().getPortListFromPortType(0, bdType, 63213));
        }
        return ports;
    }

    public static List<Integer> getVPortsByDomain(int bdType, int domain) {
        int portType = TEVirtualPortUtil.getPortTypeByDomain(domain);
        return TEVirtualPortUtil.getVPortsByPortType(bdType, portType);
    }

    public static int getVC4NumByVSDHPortLevel(int neid, int slotid, int port) {
        int cacheSpeed = TEPortModelConfigurationDataMgr.getInstance().getCacheSpeed(neid, slotid, port);
        return TEVirtualPortUtil.convertLogicPortSpeedLevelToVC4Num(cacheSpeed);
    }

    public static int getNMSLevlValueByVSDHPortLevel(int neid, int slotid, int port) {
        int cacheSpeed = TEPortModelConfigurationDataMgr.getInstance().getCacheSpeed(neid, slotid, port);
        int levalValue = -1;
        switch (cacheSpeed) {
            case 1: {
                levalValue = 6401;
                break;
            }
            case 2: {
                levalValue = 6404;
                break;
            }
            case 3: {
                levalValue = 6416;
                break;
            }
            case 4: {
                levalValue = 6464;
                break;
            }
            case 5: {
                levalValue = 6656;
                break;
            }
        }
        return levalValue;
    }

    private static int convertLogicPortSpeedLevelToVC4Num(int level) {
        int num = 0;
        switch (level) {
            case 1: 
            case 6401: {
                num = 1;
                break;
            }
            case 2: 
            case 6404: {
                num = 4;
                break;
            }
            case 3: 
            case 6416: {
                num = 16;
                break;
            }
            case 4: 
            case 6464: {
                num = 64;
                break;
            }
            case 5: 
            case 6656: {
                num = 256;
                break;
            }
            default: {
                num = 0;
            }
        }
        return num;
    }

    public static int getPortSpeedLevelByVPortType(int type) {
        int speedLevel = 255;
        switch (type) {
            case 1: {
                speedLevel = 3;
                break;
            }
            case 2: {
                speedLevel = 4;
                break;
            }
            default: {
                speedLevel = 255;
            }
        }
        return speedLevel;
    }

    private static int getPortTypeByDomain(int domain) {
        int portType = 0;
        portType = domain == 1 ? 63210 : 63213;
        return portType;
    }

    public static List<Integer> getExistVPortsByPortType(int neid, int slotid, int portType) {
        TEConfigurationDataMgr mgr = TEConfigurationDataMgr.getInstance();
        List<Integer> ports = TEVirtualPortUtil.getVPortsByPortType(mgr.getBoardType(neid, slotid), portType);
        ArrayList existPorts = mgr.getLogicPortList(neid, slotid);
        Iterator<Integer> iter = ports.iterator();
        while (iter.hasNext()) {
            if (existPorts.contains(iter.next())) continue;
            iter.remove();
        }
        return ports;
    }

    public static List<Integer> getExistVPortsByDomain(int neid, int slotid, int domain) {
        int portType = TEVirtualPortUtil.getPortTypeByDomain(domain);
        return TEVirtualPortUtil.getExistVPortsByPortType(neid, slotid, portType);
    }

    public static List<Integer> getMappingNMPathsByDomainAndMappingPort(int bdType, int port, int domain) {
        TECPMappingAbility mappingAbility = (TECPMappingAbility)((TECPMappingAbility)TECircuitPackDescription.getInstance().getMappingAbilityMap().get(bdType)).clone();
        return mappingAbility.getPathsByDomainAndport(port, domain);
    }

    public static List<Integer> getMappingNEPathsByDomainAndMappingPort(int bdType, int port, int domain) {
        List<Integer> paths = TEVirtualPortUtil.getMappingNMPathsByDomainAndMappingPort(bdType, port, domain);
        TEVirtualPortUtil.convertNMPathToNEPath(bdType, paths);
        return paths;
    }

    public static Map<Integer, List<Integer>> getMappingPortsAndNMPathsByDoamin(int bdType, int domain) {
        TECPMappingAbility mappingAbility = (TECPMappingAbility)((TECPMappingAbility)TECircuitPackDescription.getInstance().getMappingAbilityMap().get(bdType)).clone();
        return mappingAbility.getPortsAndPathsByDoamin(domain);
    }

    public static Map<Integer, List<Integer>> getMappingPortsAndNEPathsByDoamin(int bdType, int domain) {
        Map<Integer, List<Integer>> tempMap = TEVirtualPortUtil.getMappingPortsAndNMPathsByDoamin(bdType, domain);
        for (List<Integer> paths : tempMap.values()) {
            TEVirtualPortUtil.convertNMPathToNEPath(bdType, paths);
        }
        return tempMap;
    }

    public static void convertNMPathToNEPath(int bdType, List<Integer> paths) {
        ArrayList<Integer> tempPaths = new ArrayList<Integer>();
        if (TEOTNModelDataMgr.getInstance().isSimpleModelBoard(bdType)) {
            for (int path : paths) {
                int tempPath = TEOTNModelDataMgr.getInstance().getNePath(path, bdType);
                if (tempPath == -1) {
                    tempPath = path;
                }
                tempPaths.add(tempPath);
            }
        } else {
            tempPaths.addAll(paths);
        }
        paths.clear();
        paths.addAll(tempPaths);
    }

    public static int convertNMPathToNEPath(int bdType, int path) {
        int result = -1;
        result = TEOTNModelDataMgr.getInstance().isSimpleModelBoard(bdType) ? TEOTNModelDataMgr.getInstance().getNePath(path, bdType) : path;
        if (result == -1) {
            result = path;
        }
        return result;
    }

    public static int convertNEPathToNMPath(int bdType, int path) {
        int result = -1;
        result = TEOTNModelDataMgr.getInstance().isSimpleModelBoard(bdType) ? TEOTNModelDataMgr.getInstance().getNmPath(1, TEOTNModelDataMgr.getInstance().getGradeFromBoard(bdType), path, bdType) : path;
        if (result == -1) {
            result = path;
        }
        return result;
    }

    public static void addVirtualInfoToAddiblePort(int bdType, int port, int level, boolean isVirtual) {
        TECPAddiblePortRecord portObj = TECircuitPackDescription.getInstance().getAddibleCPPort(bdType, port, level);
        if (portObj == null) {
            TELogFactory.getNormalLogger().error("can not find addible port already existed!bdType:" + bdType + ";port:" + port + ";level:" + level);
            return;
        }
        portObj.setVirtualPort(isVirtual);
    }

    public static String getPathLevel(int path) {
        TEVirtualPortUtil.initodukToPathrangeMap();
        String level = "";
        level = TEVirtualPortUtil.judgeLevel(path, "ODU4") ? "ODU4" : (TEVirtualPortUtil.judgeLevel(path, "ODU3") ? "ODU3" : (TEVirtualPortUtil.judgeLevel(path, "ODU2") ? "ODU2" : (TEVirtualPortUtil.judgeLevel(path, "ODU1") ? "ODU1" : (TEVirtualPortUtil.judgeLevel(path, "ODU0") ? "ODU0" : (TEVirtualPortUtil.judgeLevel(path, "ODUflex") ? "ODUflex" : "")))));
        return level;
    }

    public static boolean judgeLevel(int path, String level) {
        boolean result = false;
        TEVirtualPortUtil.initodukToPathrangeMap();
        List<Map<String, Integer>> rangeArr = odukToPathrange.get(level);
        for (Map<String, Integer> tempMap : rangeArr) {
            if (path < tempMap.get("MIN") || path > tempMap.get("MAX")) continue;
            result = true;
            break;
        }
        return result;
    }

    public static String getCapacity(int vPortType, int path, int timeSlots) {
        String level = TEVirtualPortUtil.getPathLevel(path);
        StringBuilder resStr = new StringBuilder();
        if (level.equals("ODUflex") && timeSlots > 0) {
            resStr.append(CAPACITY_UNIT).append("*").append(timeSlots);
        } else if (vPortType == 1) {
            resStr.append("STM-16");
        } else if (vPortType == 2) {
            resStr.append("STM-64");
        } else if (vPortType == 3) {
            if (level.equalsIgnoreCase("ODU0")) {
                resStr.append("GE");
            } else if (level.equalsIgnoreCase("ODU1")) {
                resStr.append("2GE");
            } else if (level.equalsIgnoreCase("ODU2")) {
                resStr.append("10GE");
            } else if (level.equalsIgnoreCase("ODU3")) {
                resStr.append("40GE");
            } else if (level.equalsIgnoreCase("ODU4")) {
                resStr.append("100GE");
            }
        }
        return resStr.toString();
    }

    private static void initodukToPathrangeMap() {
        if (odukToPathrange.isEmpty()) {
            odukToPathrange = new HashMap<String, List<Map<String, Integer>>>();
            TEVirtualPortUtil.addDataToMap("ODUflex", new int[][]{{4609, 4709}, {8193, 8293}, {13313, 13413}, {18945, 19045}});
            TEVirtualPortUtil.addDataToMap("ODU0", new int[][]{{4353, 4453}, {7169, 7269}, {7681, 7781}, {11265, 11365}, {12289, 12389}, {17921, 18021}});
            TEVirtualPortUtil.addDataToMap("ODU1", new int[][]{{1409, 1535}, {8705, 8805}, {14337, 14437}, {19969, 20069}});
            TEVirtualPortUtil.addDataToMap("ODU2", new int[][]{{1665, 1791}, {14849, 20581}});
            TEVirtualPortUtil.addDataToMap("ODU3", new int[][]{{1921, 2047}, {20993, 21993}});
            TEVirtualPortUtil.addDataToMap("ODU4", new int[][]{{2177, 2303}});
        }
    }

    public static String getPortType(int vPortType) {
        String portType = "";
        switch (vPortType) {
            case 1: 
            case 2: {
                portType = PORTTYPE_SDH;
                break;
            }
            case 3: {
                portType = PORTTYPE_ETH;
                break;
            }
            default: {
                portType = PORTTYPE_SDH;
            }
        }
        return portType;
    }

    private static void addDataToMap(String level, int[][] rangeArr) {
        ArrayList list = new ArrayList();
        for (int[] tempArr : rangeArr) {
            HashMap<String, Integer> tempMap = new HashMap<String, Integer>();
            tempMap.put("MIN", tempArr[0]);
            tempMap.put("MAX", tempArr[1]);
            list.add(tempMap);
        }
        odukToPathrange.put(level, list);
    }

    public static void interpretMappingAbility(int bdType, Node node) {
        if (!node.hasChildNodes()) {
            return;
        }
        NodeList nodeList = node.getChildNodes();
        TECPMappingAbility mappingAbility = (TECPMappingAbility)TECircuitPackDescription.getInstance().getMappingAbilityMap().get(bdType);
        if (mappingAbility != null) {
            return;
        }
        mappingAbility = new TECPMappingAbility();
        TECircuitPackDescription.getInstance().getMappingAbilityMap().put(bdType, (Object)mappingAbility);
        Node tmpNode = null;
        Node attr = null;
        NamedNodeMap attrs = null;
        String attrName = null;
        String attrValue = null;
        ArrayList<Integer> portList = new ArrayList<Integer>();
        SDXMLInterpreterMgr mgr = SDXMLInterpreterMgr.getInstance();
        int iLen = nodeList.getLength();
        for (int i = 0; i < iLen; ++i) {
            tmpNode = nodeList.item(i);
            if (!"port_def".equalsIgnoreCase(tmpNode.getNodeName())) continue;
            attrs = tmpNode.getAttributes();
            int jLen = attrs.getLength();
            for (int j = 0; j < jLen; ++j) {
                portList.clear();
                attr = attrs.item(j);
                attrName = attr.getNodeName();
                attrValue = attr.getNodeValue();
                if ("port_no_list".equalsIgnoreCase(attrName)) {
                    mgr.parseIntList(attrValue, portList);
                }
                if (portList.isEmpty()) continue;
                TEVirtualPortUtil.addMappingObj(mappingAbility, portList, tmpNode);
            }
        }
    }

    private static void addMappingObj(TECPMappingAbility mappingAbility, List<Integer> porList, Node node) {
        if (!node.hasChildNodes()) {
            return;
        }
        NodeList nodeList = node.getChildNodes();
        Node tmpNode = null;
        Node attr = null;
        ArrayList<Integer> paths = null;
        ArrayList<Integer> serviceTypes = null;
        NamedNodeMap attrs = null;
        String attrName = null;
        String attrValue = null;
        SDXMLInterpreterMgr mgr = SDXMLInterpreterMgr.getInstance();
        int iLen = nodeList.getLength();
        for (int i = 0; i < iLen; ++i) {
            tmpNode = nodeList.item(i);
            if (!"oduk_mapping".equalsIgnoreCase(tmpNode.getNodeName())) continue;
            paths = new ArrayList<Integer>();
            serviceTypes = new ArrayList<Integer>();
            attrs = tmpNode.getAttributes();
            int jLen = attrs.getLength();
            for (int j = 0; j < jLen; ++j) {
                attr = attrs.item(j);
                attrName = attr.getNodeName();
                attrValue = attr.getNodeValue();
                if ("path".equalsIgnoreCase(attrName)) {
                    mgr.parseIntList(attrValue, paths);
                    continue;
                }
                if (!"svr_type".equalsIgnoreCase(attrName)) continue;
                mgr.parseIntList(attrValue, serviceTypes);
            }
            mappingAbility.createMappingObj(porList, paths, serviceTypes);
        }
    }

    public static List<Integer> queryVPortsAndCache(int neID, int slotID) {
        Operation opera;
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        TEConfigurationDataMgr mgr = TEConfigurationDataMgr.getInstance();
        int boardType = mgr.getBoardType(neID, slotID);
        int neVersion = TEConvertUtil.convertVerStrToInt(mgr.getNE(neID).getHostVersion());
        List<TECPAddiblePortRecord> addiblePortRecordList = TECircuitPackDescription.getInstance().getAddibleCPPort(boardType);
        HashSet<Integer> set = new HashSet<Integer>();
        TECPAddiblePortRecord addiblePortRecord = null;
        int m = addiblePortRecordList.size();
        for (int i = 0; i < m; ++i) {
            addiblePortRecord = addiblePortRecordList.get(i);
            if (!addiblePortRecord.isWithInRange(neVersion) || TEVirtualPortUtil.isVirtualPort(boardType, addiblePortRecord.portID, 0)) continue;
            set.add(addiblePortRecord.portID);
        }
        Operation oper = TECreateObjectFactory.getOperation(neID, "NSCMD_CFG_GET_PORT");
        ArrayList<Integer> phyList = new ArrayList<Integer>();
        if (!set.isEmpty()) {
            phyList.addAll(set);
            Collections.sort(phyList);
            int n = phyList.size();
            for (int j = 0; j < n; ++j) {
                if (null == oper) continue;
                int portId = (Integer)phyList.get(j);
                Input input = oper.getInput();
                Part part = input.getPart("slotID");
                part.setValue(String.valueOf(slotID));
                part = input.getPart("portID");
                part.setValue(String.valueOf(portId));
                operationList.add((Operation)oper.clone());
            }
        }
        if (null != (opera = TECreateObjectFactory.getOperation(neID, "NSCMD_CFG_GET_PORT_SERVICEMAP"))) {
            opera.getInput().setPartValue("slotid", String.valueOf(slotID));
            operationList.add(opera);
        }
        if (operationList.isEmpty()) {
            TELogFactory.getNormalLogger().error("operationList is null!");
            return null;
        }
        int retCode = TENECommMgr.getInstance().sendCommand((int)neID, operationList, (int)10).retCode;
        for (int count = 0; retCode != 0 && count < 3; ++count) {
            retCode = TENECommMgr.getInstance().sendCommand((int)neID, operationList, (int)10).retCode;
        }
        if (retCode != 0) {
            return null;
        }
        ArrayList<Integer> ports = new ArrayList<Integer>();
        int m2 = operationList.size();
        for (int k = 0; k < m2; ++k) {
            int faultCode = 1090650120;
            oper = (Operation)operationList.get(k);
            if (oper.getOutputCount() == 0) continue;
            if (!oper.getName().equals("NSCMD_CFG_GET_PORT_SERVICEMAP")) {
                Output output = oper.getOutput()[0];
                if (!"".equalsIgnoreCase(output.getFault()[0].getCode())) {
                    faultCode = new Integer(output.getFault()[0].getCode());
                }
                if (faultCode != 0) continue;
                int portId = Integer.valueOf(output.getPartValue("portID"));
                int portType = Integer.valueOf(output.getPart(output.getPartCount() - 2).getValue());
                int portLevel = Integer.valueOf(output.getPart(output.getPartCount() - 1).getValue());
                ports.add(portId);
                if (TESysManagerConstants.SYS_SINGLE_STATUS != TESysManagerBean.getInstance().getSysStauts()) continue;
                mgr.addLogicPort(neID, slotID, portId, portType, portLevel);
                continue;
            }
            int len = oper.getOutputCount();
            for (int i = 0; i < len; ++i) {
                Output output = oper.getOutput(i);
                if (!String.valueOf(0).equals(output.getFault(0).getCode())) continue;
                int portId = Integer.valueOf(output.getPartValue("vPort"));
                int portLevel = TEVirtualPortUtil.getPortSpeedLevelByVPortType(Integer.valueOf(output.getPartValue("vPortType")));
                int portType = PORTTYPE_SDH.equals(TEVirtualPortUtil.getPortType(Integer.valueOf(output.getPartValue("vPortType")))) ? 1 : 255;
                ports.add(portId);
                if (TESysManagerConstants.SYS_SINGLE_STATUS != TESysManagerBean.getInstance().getSysStauts()) continue;
                mgr.addLogicPort(neID, slotID, portId, portType, portLevel);
            }
        }
        return ports;
    }
}

