/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.util.device.port;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.consts.system.TESystemVariable;
import com.huawei.nglct.db.CommonDaoService;
import com.huawei.nglct.mo.TECPPort;
import com.huawei.nglct.mo.TECPPortIndex;
import com.huawei.nglct.mo.TEPortInfo;
import com.huawei.nglct.mo.ttp.TETTPKey;
import com.huawei.nglct.neinterface.neadapter.TECommuNEMgr;
import com.huawei.nglct.nelist.model.TECircuitPackDescription;
import com.huawei.nglct.nelist.model.TEFuncBlockDescription;
import com.huawei.nglct.nelist.model.TEPortDescription;
import com.huawei.nglct.nelist.model.circuitpack.TECPAddiblePortRecord;
import com.huawei.nglct.po.TECircuitPack;
import com.huawei.nglct.po.TENEPO;
import com.huawei.nglct.po.TEPortPO;
import com.huawei.nglct.util.string.TEStringUtils;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class TEPortUtil {
    public static int[] g_iSlotOrder = new int[]{0, 1, 22, 43, 4, 25, 46, 7, 28, 49, 10, 31, 52, 13, 34, 55, 16, 37, 58, 19, 40, 61, 2, 23, 44, 5, 26, 47, 8, 29, 50, 11, 32, 53, 14, 35, 56, 17, 38, 59, 20, 41, 62, 3, 24, 45, 6, 27, 48, 9, 30, 51, 12, 33, 54, 15, 36, 57, 18, 39, 60, 21, 42, 63};
    private static int TIME_OUT = 20;
    private static final int CES_MODE = 1;

    public static int getPortID(int domain, int portNo) {
        return (domain << 16 & 0xFFFF0000) + (portNo & 0xFFFF);
    }

    public static int getPortNo(int portID) {
        return portID & 0xFFFF;
    }

    public static int getDomain(int portID) {
        return portID >> 16 & 0xFFFF;
    }

    public static String getPortTypeName(int type) {
        return TEPortDescription.getInstance().getTypeName(type);
    }

    public static boolean isPortInDomain(TEPortPO pPort, int domain) {
        if (null == pPort) {
            return false;
        }
        TIntArrayList fbs = new TIntArrayList();
        TEFuncBlockDescription.getInstance().getDomainContainFB(domain, fbs);
        int m = fbs.size();
        for (int i = 0; i < m; ++i) {
            if (!pPort.isSupportFB(fbs.get(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean isPortInDomain(TECPPortIndex port, int domain, boolean bNeedLock) {
        TEPortPO pPort;
        TECircuitPack pCP = new TECircuitPack(port.m_neID, port.m_slotID);
        if (null != (pCP = (TECircuitPack)CommonDaoService.getById(TECircuitPack.class, pCP)) && null != (pPort = pCP.getCPPort(port.m_portID))) {
            return TEPortUtil.isPortInDomain(pPort, domain);
        }
        return false;
    }

    public static boolean isPortInDomain(int type, int domain) {
        TEFuncBlockDescription pFB = TEFuncBlockDescription.getInstance();
        TIntArrayList fbs = new TIntArrayList();
        TEFuncBlockDescription.getInstance().getDomainContainFB(domain, fbs);
        TIntHashSet fbSet = new TIntHashSet();
        fbSet.addAll(fbs.toNativeArray());
        int m = fbs.size();
        for (int i = 0; i < m; ++i) {
            TIntHashSet tmp = new TIntHashSet();
            pFB.getFBTypeByBiType(fbs.get(i), tmp);
            fbSet.addAll(tmp.toArray());
        }
        ArrayList fbList = TEPortDescription.getInstance().getPortFBList(type, 0, false);
        TIntIterator iter = fbSet.iterator();
        while (iter.hasNext()) {
            if (!fbList.contains(iter.next())) continue;
            return true;
        }
        return false;
    }

    public static boolean isTUPort(TEPortPO pPort) {
        if (null == pPort) {
            return false;
        }
        return TEPortUtil.isPortInDomain(pPort, 129);
    }

    public static boolean isTUPort(TECPPortIndex port, boolean bNeedLock) {
        return TEPortUtil.isPortInDomain(port, 129, bNeedLock);
    }

    public static boolean isTUPort(int type) {
        return TEPortUtil.isPortInDomain(type, 129);
    }

    public static boolean isLinePort(TEPortPO pPort) {
        if (null == pPort) {
            return false;
        }
        return TEPortUtil.isPortInDomain(pPort, 130);
    }

    public static boolean isLinePort(TECPPortIndex port, boolean bNeedLock) {
        return TEPortUtil.isPortInDomain(port, 130, bNeedLock);
    }

    public static boolean isLinePort(int type) {
        return TEPortUtil.isPortInDomain(type, 130);
    }

    public static boolean isNeedConver(int fb) {
        if (0 == TESystemVariable.g_SlotMode) {
            return false;
        }
        return 92 == fb || 95 == fb || 96 == fb;
    }

    public static void TTPSlotTrans(TETTPKey ttp) {
        if (TEPortUtil.isNeedConver(ttp.getTTPType()) && ttp.getTTPLow() <= 63) {
            int ts = g_iSlotOrder[ttp.getTTPLow()];
            ttp.setTTPLow(ts);
        }
    }

    public static int TTPSlotTrans(int fb, int ttpID) {
        if (TEPortUtil.isNeedConver(fb) && ttpID <= 63) {
            ttpID = g_iSlotOrder[ttpID];
        }
        return ttpID;
    }

    public static int getPortList(int neID, int slotID, int portType, List<TECPPort> portList, boolean bNeedLock) {
        int retCode;
        block6: {
            ArrayList<TEPortInfo> tmpList;
            TECPPort tmpPort;
            TEPortInfo portInfo;
            block5: {
                retCode = 0;
                portInfo = null;
                tmpPort = null;
                tmpList = new ArrayList<TEPortInfo>();
                TECircuitPack pCP = null;
                portList.clear();
                if (0 == slotID) break block5;
                pCP = new TECircuitPack(neID, slotID);
                if (null == (pCP = (TECircuitPack)CommonDaoService.getById(TECircuitPack.class, pCP))) {
                    retCode = 1090596479;
                }
                if (0 != retCode) break block6;
                pCP.getCPPortes(tmpList, portType, 0, false);
                int m = tmpList.size();
                for (int i = 0; i < m; ++i) {
                    portInfo = (TEPortInfo)tmpList.get(i);
                    tmpPort = new TECPPort();
                    tmpPort.m_Index.m_neID = neID;
                    tmpPort.m_Index.m_slotID = slotID;
                    tmpPort.m_Index.m_portID = portInfo.m_PortID;
                    tmpPort.m_PortType = portInfo.m_Type;
                    tmpPort.m_Level = portInfo.m_Level;
                    portList.add(tmpPort);
                }
                break block6;
            }
            TENEPO pNE = (TENEPO)CommonDaoService.getById(TENEPO.class, Integer.valueOf(neID));
            if (null == pNE) {
                return 1090646020;
            }
            Set<TECircuitPack> set = pNE.getBoardSet();
            for (TECircuitPack pCP : set) {
                if (null == pCP) continue;
                tmpList.clear();
                pCP.getCPPortes(tmpList, portType, 0, false);
                int n = tmpList.size();
                for (int j = 0; j < n; ++j) {
                    portInfo = (TEPortInfo)tmpList.get(j);
                    tmpPort = new TECPPort();
                    tmpPort.m_Index.m_neID = neID;
                    tmpPort.m_Index.m_slotID = pCP.getSlotId();
                    tmpPort.m_Index.m_portID = portInfo.m_PortID;
                    tmpPort.m_PortType = portInfo.m_Type;
                    tmpPort.m_Level = portInfo.m_Level;
                    portList.add(tmpPort);
                }
            }
        }
        return retCode;
    }

    public static int getPortName(TECircuitPack pCP, int portID, String[] sName) {
        int retCode = 0;
        sName[0] = "";
        TEPortPO pPort = new TEPortPO(pCP.getLogicNeId(), pCP.getSlotId(), portID);
        if (null == (pPort = (TEPortPO)CommonDaoService.getById(TEPortPO.class, pPort))) {
            return 1092743466;
        }
        sName[0] = pPort.getName();
        return retCode;
    }

    public static int getPortName(int neID, int slotID, int portID, String[] sName) {
        TECircuitPack pCP = new TECircuitPack(neID, slotID);
        if (null != (pCP = (TECircuitPack)CommonDaoService.getById(TECircuitPack.class, pCP))) {
            return 1090596479;
        }
        return TEPortUtil.getPortName(pCP, portID, sName);
    }

    public static String getPortDefaultName(int type, int portID, int cptype, int iSlot, int iCPtype, int iPortID) {
        TECircuitPackDescription cpd = TECircuitPackDescription.getInstance();
        String defName = "";
        if (iSlot == 0 || iCPtype == 0 || iPortID == 0) {
            if (0 != cptype) {
                String inName = cpd.getCPPortINName(cptype, portID);
                String outName = cpd.getCPPortOUTName(cptype, portID);
                if (!"".equals(inName) && !"".equals(outName)) {
                    defName = inName + "/" + outName;
                } else if (!"".equals(inName)) {
                    defName = inName;
                } else if (!"".equals(outName)) {
                    defName = outName;
                }
            }
            if ("".equals(defName)) {
                defName = TEStringUtils.snprintf(254, "%s-%d", TEPortDescription.getInstance().getTypeName(type), portID & 0xFFFF);
            }
            return defName;
        }
        String inName = cpd.getCPPortINName(iCPtype, iPortID);
        String outName = cpd.getCPPortOUTName(iCPtype, iPortID);
        if (!"".equals(inName) && !"".equals(outName)) {
            defName = inName + "/" + outName;
        } else if (!"".equals(inName)) {
            defName = inName;
        } else if (!"".equals(outName)) {
            defName = outName;
        }
        String portName = TEPortDescription.getInstance().getTypeName(type);
        String cpName = TECircuitPackDescription.getInstance().getTypeName(iCPtype);
        String name = "".equals(defName) ? TEStringUtils.snprintf(254, "%d-%s.%s-%d", iSlot, cpName, portName, iPortID & 0xFFFF) : TEStringUtils.snprintf(254, "%d-%s.%s", iSlot, cpName, defName);
        return name;
    }

    public static List<TECPAddiblePortRecord> getAddiblePorts(int neVersion, int cpType) {
        List<TECPAddiblePortRecord> addiblePortList = TECircuitPackDescription.getInstance().getAddibleCPPort(cpType);
        Iterator<TECPAddiblePortRecord> iter = addiblePortList.iterator();
        while (iter.hasNext()) {
            if (iter.next().isWithInRange(neVersion)) continue;
            iter.remove();
        }
        return addiblePortList;
    }

    public static List<Integer> getCESModePortList(int neid, int slotid, List<Integer> portids) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        Operation oper = TECreateObjectFactory.getOperation(neid, "NSCMD_CFG_GET_VC12SRVMODE");
        if (oper == null) {
            return list;
        }
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        Input input = oper.getInput();
        int m = portids.size();
        for (int i = 0; i < m; ++i) {
            int port = portids.get(i);
            input.setPartValue("slotid", String.valueOf(slotid));
            input.setPartValue("port", String.valueOf(port));
            operationList.add((Operation)oper.clone());
        }
        if (!operationList.isEmpty()) {
            OperationResult result = TECommuNEMgr.getInstance().sendCommand(neid, operationList, TIME_OUT, null);
            Output output = null;
            if (result.retCode == 0) {
                int n = operationList.size();
                for (int j = 0; j < n; ++j) {
                    oper = (Operation)operationList.get(j);
                    output = oper.getOutput(0);
                    if (0 != Integer.valueOf(output.getFault(0).getCode()) || 1 != Integer.valueOf(output.getPartValue("srvmode"))) continue;
                    int portId = Integer.valueOf(output.getPartValue("port"));
                    list.add(portId);
                    portids.remove((Object)portId);
                }
            }
        }
        return list;
    }
}

