/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.util.device.ne;

import com.huawei.nglct.bscfg.TEIndexOfNEID;
import com.huawei.nglct.bscfg.equipment.TELicenseMgr;
import com.huawei.nglct.core.mdp.TEASN1CommMgr;
import com.huawei.nglct.core.necoordinator.SPParameter;
import com.huawei.nglct.core.necoordinator.TENESPTransaction;
import com.huawei.nglct.db.CommonDaoService;
import com.huawei.nglct.nemgr.f_interface.asnbaseequipmentinfo.AsnGetShelfControlONEReq;
import com.huawei.nglct.nemgr.f_interface.asnbaseequipmentinfo.AsnGetShelfControlONERsp;
import com.huawei.nglct.nemgr.f_interface.asnbaseequipmentinfo.AsnShelfOne;
import com.huawei.nglct.po.TENEPO;
import com.huawei.nglct.util.datastruct.TEReturnValue;
import java.util.ArrayList;
import java.util.List;
import net.commustru.fstru.FStruct;

public class TENEUtils {
    public static int isOverMaxNENumber(TENEPO ne) {
        TENESPTransaction trans = new TENESPTransaction();
        ArrayList<SPParameter> spParameters = new ArrayList<SPParameter>();
        SPParameter para = new SPParameter(12, ne.getType());
        spParameters.add(para);
        trans.addNESP("p_GetLicenseNumOfNE", spParameters);
        int curNeNum = trans.resultOf("p_GetLicenseNumOfNE");
        return TELicenseMgr.getInstance().isOverMaxNENum(ne.getType(), curNeNum + 1);
    }

    public static int getNEName(int neID, StringBuffer name, boolean needLock) {
        TENEPO nePO = (TENEPO)CommonDaoService.getById(TENEPO.class, Integer.valueOf(neID));
        if (nePO != null) {
            name.append(nePO.getName());
            return 0;
        }
        return -1;
    }

    public static boolean isVNE(TENEPO ne) {
        return TENEUtils.isVNE(ne.getType());
    }

    public static boolean isVNE(int neType) {
        return neType == 1894;
    }

    public static int getNEPara(int neID, List<Integer> hook, boolean needLock) {
        int retCode = 0;
        TENEPO nePO = (TENEPO)CommonDaoService.getById(TENEPO.class, Integer.valueOf(neID));
        if (nePO == null) {
            return -1;
        }
        hook.add(nePO.getType());
        hook.add(nePO.getShelfType());
        hook.add(nePO.getVersion());
        return retCode;
    }

    public static boolean isDWDMNE(int neID) {
        return neID >= 0x3E0000 && neID <= 0x3F7FFF;
    }

    public static int getDWDMNEName(int dwdmNEID, String[] oneName) {
        oneName[0] = "";
        return 0;
    }

    public static TEReturnValue getDWDMNEName(int dwdmNEID) {
        TEReturnValue retValue = new TEReturnValue();
        retValue.strValue = "";
        return retValue;
    }

    public static String formatNEID(int phyNeID) {
        StringBuffer buf = new StringBuffer();
        buf.append(phyNeID >> 16);
        buf.append("-");
        buf.append(phyNeID & 0xFFFF);
        return buf.toString();
    }

    public static int deformatNEID(String neIDstr) {
        if (neIDstr == null) {
            return 0;
        }
        String[] snippts = neIDstr.split("-");
        if (snippts == null || snippts.length < 2) {
            return 0;
        }
        int neID = Integer.parseInt(snippts[0]) << 16;
        return neID |= Integer.parseInt(snippts[1]);
    }

    public static int realNEID(int neID) {
        if (TENEUtils.isDWDMNE(neID)) {
            return neID;
        }
        return neID & 0xFFFF;
    }

    public static int getDWDMNEIDByShelfID(int[] dwdmNEID, int shelfID) {
        int ret = 0;
        dwdmNEID[0] = TEIndexOfNEID.getInstance().getValue(shelfID).getOneID();
        if (0 != dwdmNEID[0]) {
            return ret;
        }
        AsnGetShelfControlONEReq req = new AsnGetShelfControlONEReq();
        AsnGetShelfControlONERsp rsp = new AsnGetShelfControlONERsp();
        req.neID = shelfID;
        ret = TEASN1CommMgr.sendCommand(TEASN1CommMgr.INVENTORY_SERVER_PROC_ID, (FStruct)req, (FStruct)rsp, 0x2122B1);
        if (0 != ret) {
            return ret;
        }
        if (!rsp.result.isSuccess) {
            ret = rsp.result.getRetCode();
            return ret;
        }
        int m = rsp.oneList.size();
        for (int i = 0; i < m; ++i) {
            AsnShelfOne pshelfone = (AsnShelfOne)rsp.oneList.get(i);
            if (!pshelfone.isControlOne) continue;
            dwdmNEID[0] = pshelfone.oneID;
            return ret;
        }
        return ret;
    }

    public static TEReturnValue getDWDMNEIDByShelfID(int shelfID) {
        TEReturnValue ret = new TEReturnValue();
        int dwdmNEID = TEIndexOfNEID.getInstance().getValue(shelfID).getOneID();
        if (0 != dwdmNEID) {
            ret.intValue = dwdmNEID;
            return ret;
        }
        int errCode = 0;
        AsnGetShelfControlONEReq req = new AsnGetShelfControlONEReq();
        AsnGetShelfControlONERsp rsp = new AsnGetShelfControlONERsp();
        req.neID = shelfID;
        errCode = TEASN1CommMgr.sendCommand(TEASN1CommMgr.INVENTORY_SERVER_PROC_ID, (FStruct)req, (FStruct)rsp, 0x2122B1);
        if (0 != errCode) {
            ret.errorCode = errCode;
            return ret;
        }
        if (!rsp.result.isSuccess) {
            ret.errorCode = rsp.result.getRetCode();
            return ret;
        }
        int m = rsp.oneList.size();
        for (int i = 0; i < m; ++i) {
            AsnShelfOne pshelfone = (AsnShelfOne)rsp.oneList.get(i);
            if (!pshelfone.isControlOne) continue;
            ret.intValue = dwdmNEID = pshelfone.oneID;
            return ret;
        }
        return ret;
    }
}

