/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.util.device.ne;

import com.huawei.nglct.cbb.pnp.TESDMgrInterface;
import com.huawei.nglct.cbb.xmlinterpreter.SDXMLInterpreterMgr;
import com.huawei.nglct.common.TEParseXMLFile;
import com.huawei.nglct.util.device.ne.TEDomainVersion;
import com.huawei.nglct.util.xml.TEResourceManager;
import gnu.trove.TIntIntHashMap;
import gnu.trove.TIntObjectHashMap;
import java.io.File;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TEGetNEDomainVersion
implements TESDMgrInterface {
    private TIntObjectHashMap<TEDomainVersion> domainVerMap = new TIntObjectHashMap();
    private TIntIntHashMap devType2NEType = new TIntIntHashMap();
    private TIntIntHashMap neType2DevType = new TIntIntHashMap();
    private static TEGetNEDomainVersion m_instance = null;
    public static final String CNEMGR_DOMAIN_STR = "cnemgrDomain";

    private TEGetNEDomainVersion() {
        this.loadNeDomainVersion();
    }

    public static synchronized TEGetNEDomainVersion getInstance() {
        if (null == m_instance) {
            m_instance = new TEGetNEDomainVersion();
        }
        return m_instance;
    }

    private void loadNeDomainVersion() {
        String filepath = TEResourceManager.getPath() + File.separator + "nemgr" + File.separator + "device" + File.separator + "ne_domain_version.xml";
        Document doc = TEParseXMLFile.parseFile(filepath);
        if (null == doc) {
            return;
        }
        NodeList nodeList = doc.getElementsByTagName("ne");
        int m = nodeList.getLength();
        for (int i = 0; i < m; ++i) {
            Node node = nodeList.item(i);
            this.parseNENode(node);
        }
    }

    public void parseNENode(Node node) {
        String cnemgrDomain = null;
        Node cnemgrDomainNode = null;
        NamedNodeMap nodeMap = node.getAttributes();
        int neType = Integer.parseInt(nodeMap.getNamedItem("type").getNodeValue());
        int devType = Integer.parseInt(nodeMap.getNamedItem("devtype").getNodeValue());
        int isSupportSlaveShelf = 0;
        if (null != nodeMap.getNamedItem("issupportshelf")) {
            isSupportSlaveShelf = Integer.parseInt(nodeMap.getNamedItem("issupportshelf").getNodeValue());
        }
        this.addDevAndNeTypeMap(neType, devType);
        String domain = nodeMap.getNamedItem("domain").getNodeValue();
        String bundlename = nodeMap.getNamedItem("bundlename").getNodeValue();
        String neTypeName = nodeMap.getNamedItem("licensename").getNodeValue();
        cnemgrDomainNode = nodeMap.getNamedItem(CNEMGR_DOMAIN_STR);
        cnemgrDomain = null;
        if (null != cnemgrDomainNode) {
            cnemgrDomain = cnemgrDomainNode.getNodeValue();
        }
        SDXMLInterpreterMgr.getInstance().addMacorValue(neTypeName, devType);
        if (null == cnemgrDomain || cnemgrDomain.isEmpty()) {
            cnemgrDomain = domain;
        }
        this.addDomain(neType, new TEDomainVersion(neType, devType, domain, bundlename, neTypeName, cnemgrDomain, isSupportSlaveShelf));
    }

    public void addDevAndNeTypeMap(int neType, int devType) {
        this.devType2NEType.put(devType, neType);
        this.neType2DevType.put(neType, devType);
    }

    public void addDomain(int neType, TEDomainVersion domainVer) {
        if (!this.domainVerMap.containsKey(neType)) {
            this.domainVerMap.put(neType, (Object)domainVer);
        }
    }

    public String getDomain(int neType) {
        String domain = "";
        TEDomainVersion domainVersion = (TEDomainVersion)this.domainVerMap.get(neType);
        if (null != domainVersion) {
            domain = domainVersion.getDomain();
        }
        return domain;
    }

    public boolean isSupportSlaveShelf(int neType) {
        int isSupportSlaveShelf = 0;
        TEDomainVersion domainVersion = (TEDomainVersion)this.domainVerMap.get(neType);
        if (null != domainVersion) {
            isSupportSlaveShelf = domainVersion.getIsSupportSlaveShelf();
        }
        return isSupportSlaveShelf != 0;
    }

    public int getNeType(int devType) {
        return this.devType2NEType.get(devType);
    }

    public int getDevType(int neType) {
        return this.neType2DevType.get(neType);
    }

    public String getBundleName(int neType) {
        String bundlename = "";
        TEDomainVersion domainVersion = (TEDomainVersion)this.domainVerMap.get(neType);
        if (null != domainVersion) {
            bundlename = domainVersion.getBundlename();
        }
        return bundlename;
    }

    public String getNETypeName(int neType) {
        String neTypeName = "";
        TEDomainVersion domainVersion = (TEDomainVersion)this.domainVerMap.get(neType);
        if (null != domainVersion) {
            neTypeName = domainVersion.getNeTypeName();
        }
        return neTypeName;
    }

    public String getCnemgrDomain(int neType) {
        String domain = null;
        TEDomainVersion domainVersion = (TEDomainVersion)this.domainVerMap.get(neType);
        if (null != domainVersion) {
            domain = domainVersion.getCnemgrDomain();
        }
        return domain;
    }

    @Override
    public void clear() {
        this.domainVerMap.clear();
        this.loadNeDomainVersion();
    }
}

