/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.util.device.board;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEPortFBModel;
import com.huawei.nglct.nelist.model.TESpecialBoardData;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class TEQueryBoardInfoBean {
    private static final int TIME_OUT = 20;

    private TEQueryBoardInfoBean() {
    }

    public static void queryBoardInfo(int neId, List<Integer> slotIdList) {
        if (null == slotIdList || slotIdList.isEmpty()) {
            return;
        }
        ArrayList<Operation> operList = new ArrayList<Operation>();
        ArrayList<Operation> payloadOperList = new ArrayList<Operation>();
        Operation queryPayloadOper = null;
        try {
            Operation queryOper = TECreateObjectFactory.getOperation(neId, "NSCMD_CFG_GET_PORT_MODEL");
            int size = slotIdList.size();
            for (int i = 0; i < size; ++i) {
                int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neId, slotIdList.get(i));
                if (boardType != 1573) continue;
                queryOper.getInput().setPartValue("slotid", String.valueOf(slotIdList.get(i)));
                operList.add((Operation)queryOper.clone());
            }
            queryPayloadOper = TECreateObjectFactory.getOperation(neId, "NSCMD_CFG_GET_SUPPORT_PAYLOADTYPE");
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEQueryBoardInfoBean.queryBoardInfo() fail!", (Throwable)e);
        }
        if (null == operList || operList.isEmpty()) {
            return;
        }
        OperationResult result = TENECommMgr.getInstance().sendCommand(neId, operList, 20);
        if (result.retCode != 0) {
            TELogFactory.getNormalLogger().error("Query board info fail, the errorCode is" + result.retCode);
            return;
        }
        TEConfigurationDataMgr cfgInstance = TEConfigurationDataMgr.getInstance();
        ArrayList<TEPortFBModel> fbList = null;
        HashMap<Integer, List<Integer>> portMap = null;
        ArrayList<Integer> pathList = null;
        int size = operList.size();
        for (int operIndex = 0; operIndex < size; ++operIndex) {
            Output[] outputArr = ((Operation)operList.get(operIndex)).getOutput();
            for (int i = 0; i < outputArr.length; ++i) {
                int pathCount;
                Output output = outputArr[i];
                if (!"0".equals(output.getFault()[0].getCode())) continue;
                int slotID = Integer.parseInt(output.getPartValue("slotid"));
                String portStr = output.getPartValue("portStr");
                portMap = new HashMap<Integer, List<Integer>>();
                fbList = new ArrayList<TEPortFBModel>();
                for (int j = 0; j < portStr.length(); j += 8 * pathCount) {
                    int port = Integer.parseInt(portStr.substring(j += 2, j + 2), 16);
                    payloadOperList.add(TEQueryBoardInfoBean.getPayloadOper((Operation)queryPayloadOper.clone(), slotID, port));
                    pathCount = Integer.parseInt(portStr.substring(j += 4, j + 4), 16);
                    j += 4;
                    TEPortFBModel portRootFB = new TEPortFBModel(neId, slotID, port, 0, 0);
                    portRootFB.setSeqenceLevel();
                    fbList.add(portRootFB);
                    pathList = new ArrayList<Integer>();
                    for (int k = 0; k < pathCount; ++k) {
                        int path = Integer.parseInt(portStr.substring(j + 8 * k, j + 8 * k + 4), 16);
                        int pathType = Integer.parseInt(portStr.substring(j + 8 * k + 4, j + 8 * k + 8), 16);
                        TEPortFBModel fbModel = new TEPortFBModel(neId, slotID, port, path, pathType);
                        fbModel.setPathCount(pathCount);
                        fbModel.setSeqenceLevel();
                        fbList.add(fbModel);
                        pathList.add(path);
                    }
                    TESpecialBoardData.getInstance().setBoardFB(neId, slotID, fbList);
                    portMap.put(port, pathList);
                }
                cfgInstance.addBoardPortList(neId, slotID, portMap);
            }
        }
        if (null != payloadOperList) {
            TEQueryBoardInfoBean.querySupPayloadType(payloadOperList, neId);
        }
    }

    private static Operation getPayloadOper(Operation oper, int slotId, int portId) {
        oper.getInput().setPartValue("slotid", String.valueOf(slotId));
        oper.getInput().setPartValue("port", String.valueOf(portId));
        oper.getInput().setPartValue("path", "0");
        return oper;
    }

    private static void querySupPayloadType(List<Operation> payloadOperList, int neId) {
        OperationResult result = TENECommMgr.getInstance().sendCommand(neId, payloadOperList, 20);
        if (result.retCode != 0) {
            TELogFactory.getNormalLogger().error("Query support payload info fail, the errorCode is" + result.retCode);
            return;
        }
        TEConfigurationDataMgr cfgInstance = TEConfigurationDataMgr.getInstance();
        ArrayList<Integer> payloadList = null;
        int size = payloadOperList.size();
        for (int operIndex = 0; operIndex < size; ++operIndex) {
            Output[] outputArr = payloadOperList.get(operIndex).getOutput();
            for (int i = 0; i < outputArr.length; ++i) {
                Output output = outputArr[i];
                if (!"0".equals(output.getFault()[0].getCode())) continue;
                int slotID = Integer.parseInt(output.getPartValue("slotid"));
                int port = Integer.parseInt(output.getPartValue("port"));
                int path = Integer.parseInt(output.getPartValue("path"));
                int payloadNum = Integer.parseInt(output.getPartValue("payloadcount"));
                String payloadStr = output.getPartValue("payloadStr");
                payloadList = new ArrayList<Integer>();
                if (payloadNum > 0) {
                    payloadList.add(0);
                }
                if (null != payloadStr) {
                    int num = payloadStr.length() / 4;
                    String str = null;
                    for (int j = 0; j < num; ++j) {
                        str = payloadStr.substring(j * 4, (j + 1) * 4);
                        int payloadType = Integer.parseInt(str, 16);
                        payloadList.add(payloadType);
                    }
                }
                cfgInstance.addddPayloadTypeList(neId, slotID, port, path, payloadList);
            }
        }
    }
}

