/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.util.device.board;

import com.huawei.nglct.bscfg.cpdyncfg.TEDyncBrdMgr;
import com.huawei.nglct.bscfg.equipment.TEEquipmentDescription;
import com.huawei.nglct.bscfg.installcp.TENECircuitPackInstall;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.script.TEBDName;
import com.huawei.nglct.cbb.script.TEDataMapKey;
import com.huawei.nglct.cbb.script.TEScriptEnumMgr;
import com.huawei.nglct.db.CommonDaoService;
import com.huawei.nglct.mo.CfgDataMgr;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.TESubrack;
import com.huawei.nglct.nelist.model.TECircuitPackDescription;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEFuncBlockDescription;
import com.huawei.nglct.nelist.model.clientitem.TEBoardInfo;
import com.huawei.nglct.nelist.model.datamgr.TEBoardConfigurationDataMgr;
import com.huawei.nglct.nelist.model.datamgr.TENEConfigurationDataMgr;
import com.huawei.nglct.po.TECircuitPack;
import com.huawei.nglct.po.TENEPO;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.device.board.TESubrackSlotCovertFunc;
import com.huawei.nglct.util.device.board.TESubrackTypeMapping;
import com.huawei.nglct.util.device.ne.TEGetNEDomainVersion;
import com.huawei.nglct.util.device.ne.TENETypeUtil;
import com.huawei.nglct.util.device.ne.TENEUtils;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEStringUtils;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntIterator;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class TEBoardUtil {
    public static final int BI_ALL = 0;
    public static final int BI_BOARD = 2;
    public static final int BI_PORT = 3;
    public static final int BI_VC4 = 5;
    public static final int BI_VC12 = 7;
    public static final int BOARD_OFFSET = 65536;
    public static final int BOARD_OUT = 0;
    public static final int BOARD_OUT_LOGIC = 1;
    public static final int BOARD_IN_RUN = 3;
    public static final int BOARD_IN_PHY = 2;
    public static TESubrackSlotCovertFunc subrackSlotCovertFunc;
    private static final String BASE_PATH;
    private static final String PAKAGE_PATH;

    private TEBoardUtil() {
    }

    public static void setSubrackSlotCovertFunc(TESubrackSlotCovertFunc func) {
        subrackSlotCovertFunc = func;
    }

    public static int getAllCPs(TENEPO nePO, List<TENECircuitPackInstall> cps, boolean needLock) {
        if (nePO == null) {
            return 1090646016;
        }
        return TEBoardUtil.getAllCPs(nePO.getNeid(), cps, needLock);
    }

    public static int getAllCPs(int neID, List<TENECircuitPackInstall> cps, boolean needLock) {
        int retCode = 0;
        cps.clear();
        String hql = " from TECircuitPack where cLogicNeId =:clogicNeId";
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("clogicNeId", neID);
        List circuitPacks = CommonDaoService.getListByHql(hql, params);
        int size = circuitPacks.size();
        for (int i = 0; i < size; ++i) {
            TECircuitPack circuitPack = (TECircuitPack)circuitPacks.get(i);
            TENECircuitPackInstall one = new TENECircuitPackInstall();
            one.setM_SlotID(circuitPack.getSlotId());
            one.setM_CircuitPackType(circuitPack.getTypeId());
            cps.add(one);
        }
        return retCode;
    }

    public static String getCPTypeName(int type) {
        return TECircuitPackDescription.getInstance().getTypeName(type);
    }

    public static int getBoardType(int neID, int slotID, int[] cpType) {
        TECircuitPack cp = new TECircuitPack(neID, slotID);
        cp = (TECircuitPack)CommonDaoService.getById(TECircuitPack.class, cp);
        cpType[0] = cp.getTypeId();
        return 0;
    }

    public static int getSubSlotIDbyPortID(int portID) {
        return (portID & 0xFF000000) >> 24;
    }

    public static String board2Str(int neID, int slot, int bdtype, int port, String other) {
        String strRet = "\"0-null\"";
        int[] cpType = new int[1];
        if (TEBoardUtil.getBoardType(neID, slot, cpType) != 0 || cpType[0] == 0) {
            TELogFactory.getNormalLogger().trace(String.format("get cp type fail, neid = %d, slot = %d\n", TENEUtils.realNEID(neID), slot));
            return strRet;
        }
        if (0 == bdtype || cpType[0] == bdtype) {
            strRet = port != 0 ? String.format("\"%d-%s-%d%s\"", slot, TEBoardUtil.getCPTypeName(cpType[0]), port & 0xFFFF, other) : String.format("\"%d-%s%s\"", TEBoardUtil.getCPTypeName(cpType[0]), other);
        }
        return strRet.toLowerCase(Locale.ENGLISH);
    }

    public static boolean str2BoardInfo(String src, TEBoardInfo info, int neID, int level) {
        int neType = TENETypeUtil.getNEType(neID);
        String str = src;
        String strBDName = "";
        int index = 0;
        int second = 0;
        info.vc4s.clear();
        info.slot = 0;
        info.bdtype = 0;
        info.port = 0;
        int first = str.indexOf(45, second);
        boolean stillInName = false;
        while (second < str.length()) {
            if (first == second) {
                return false;
            }
            String sub = str.substring(second, second + first - second);
            if (sub.trim().length() == 0) {
                return false;
            }
            switch (index) {
                case 0: 
                case 2: {
                    if (sub.trim().length() == 0) {
                        return false;
                    }
                    int value = Integer.parseInt(sub);
                    if (0 == index) {
                        info.slot = value;
                        break;
                    }
                    if (2 != index) break;
                    info.port = value;
                    break;
                }
                case 1: {
                    strBDName = stillInName ? strBDName + "-" + sub : sub;
                    int[] cpType = new int[]{0};
                    if (TENEUtils.isVNE(neType)) {
                        TEDyncBrdMgr.getInstance().getTypeIDByName(cpType, strBDName);
                    } else {
                        cpType[0] = TEBoardUtil.getBoardTypeFromName(strBDName, neID, info.slot);
                    }
                    if (0 == cpType[0]) {
                        return false;
                    }
                    info.bdtype = cpType[0];
                    break;
                }
                case 3: {
                    if (!"vc4".equals(sub)) break;
                    return false;
                }
                case 4: {
                    if (TEStringUtils.str2Vec(sub, info.vc4s) != 0) break;
                    return false;
                }
                case 5: {
                    if (!"slot".equals(sub)) break;
                    return false;
                }
                case 6: {
                    if (TEStringUtils.str2Vec(sub, info.timeSlots) != 0) break;
                    return false;
                }
                default: {
                    return false;
                }
            }
            second = first + 1;
            first = str.indexOf(45, second);
            int n = first = first == -1 ? str.length() : first;
            if (0 == level || ++index < level) continue;
        }
        return index != 0 && index != 1 && index != 4 && index != 6 && (0 == level || index >= level);
    }

    public static int getBoardTypeFromName(String brdName, int neID, int slotID) {
        int value;
        int i;
        ArrayList<Integer> hook = new ArrayList<Integer>(3);
        int retCode = TENEUtils.getNEPara(neID, hook, false);
        if (0 != retCode) {
            TELogFactory.getNormalLogger().trace(String.format("get ne para fail, neid = %d, err = %d\n", TENEUtils.realNEID(neID), retCode));
            return 0;
        }
        int neType = (Integer)hook.get(0);
        String[] strBoardName = new String[]{brdName};
        if (TENEUtils.isVNE(neType)) {
            int[] cpType = new int[]{0};
            TEDyncBrdMgr.getInstance().getTypeIDByName(cpType, strBoardName[0]);
            return cpType[0];
        }
        TIntArrayList cpTypes = new TIntArrayList();
        TESubrackTypeMapping mapping = new TESubrackTypeMapping();
        TEBoardUtil.getTypeInfoOfCurSlot(neID, slotID, mapping, false);
        TEEquipmentDescription.getInstance().getInstallCPTypeBySlot(mapping.equipmentType, mapping.shelfType, TEBoardUtil.subrackGetSlotNo(neID, slotID), cpTypes);
        TECircuitPackDescription cpd = TECircuitPackDescription.getInstance();
        for (i = 0; i < cpTypes.size(); ++i) {
            value = cpTypes.get(i);
            if (!strBoardName[0].equalsIgnoreCase(cpd.getTypeName(value))) continue;
            return value;
        }
        TEBoardUtil.convertBDName(neID, strBoardName);
        for (i = 0; i < cpTypes.size(); ++i) {
            value = cpTypes.get(i);
            if (!strBoardName[0].equalsIgnoreCase(cpd.getTypeName(value))) continue;
            return value;
        }
        TEEquipmentDescription.getInstance().getOccupyCPTypeBySlot(mapping.equipmentType, mapping.shelfType, TEBoardUtil.subrackGetSlotNo(neID, slotID), cpTypes);
        for (i = 0; i < cpTypes.size(); ++i) {
            value = cpTypes.get(i);
            if (!strBoardName[0].equalsIgnoreCase(cpd.getTypeName(value))) continue;
            return value;
        }
        return 0;
    }

    public static int getTypeInfoOfCurSlot(int neID, int slotID, TESubrackTypeMapping typeInfo, boolean lockNE) {
        TENEPO ne = (TENEPO)CommonDaoService.getById(TENEPO.class, Integer.valueOf(neID));
        TEBoardUtil.getTypeInfoOfCurSlot(ne, slotID, typeInfo);
        return 0;
    }

    public static void getTypeInfoOfCurSlot(TENEPO ne, int slotID, TESubrackTypeMapping typeInfo) {
        int subrackID = TEBoardUtil.subrackGetSubrackIDOfSlot(ne.getNeid(), slotID);
        if (subrackID != 0) {
            int subrackType = 0;
            Set<com.huawei.nglct.mo.TESubrack> subracks = ne.getSubracks();
            for (com.huawei.nglct.mo.TESubrack subrack : subracks) {
                if (subrack.subrackID != subrackID) continue;
                subrackType = subrack.getSubrackType();
            }
            typeInfo.subrackType = subrackType;
            CfgDataMgr.getInstance().getTypeInfoBySubrack(typeInfo);
        } else {
            typeInfo.equipmentType = ne.getType();
            typeInfo.shelfType = ne.getShelfType();
        }
    }

    public static int subrackGetSubrackIDOfSlot(int neID, int slotID) {
        if (null != subrackSlotCovertFunc && subrackSlotCovertFunc.needConvert(neID)) {
            return slotID / 65536;
        }
        return 0;
    }

    public static int subrackGetSlotNo(int neID, int slotID) {
        if (null != subrackSlotCovertFunc && subrackSlotCovertFunc.needConvert(neID)) {
            return slotID % 65536;
        }
        return slotID;
    }

    public static void convertBDName(int neID, String[] bdName) {
        bdName[0] = bdName[0].toUpperCase();
        String brdName = bdName[0];
        Map<TEDataMapKey, List<TEBDName>> dataMap = TEScriptEnumMgr.instance().getDataMap();
        if (null == dataMap) {
            return;
        }
        int neType = TENETypeUtil.getNEType(neID);
        if (neType == 0) {
            return;
        }
        List<TEBDName> value = dataMap.get(new TEDataMapKey(neType, "boardnamechange"));
        if (value == null) {
            return;
        }
        for (TEBDName names : value) {
            if (!names.v1name.equals(brdName)) continue;
            bdName[0] = names.v2name;
            break;
        }
    }

    public static boolean isTUCircuitPack(int type) {
        return TEBoardUtil.isCPInDomain(type, 129);
    }

    public static boolean isCPInDomain(int type, int domain) {
        TEFuncBlockDescription fb = TEFuncBlockDescription.getInstance();
        TIntHashSet fbSet = new TIntHashSet();
        TIntArrayList fbs = new TIntArrayList();
        fb.getDomainContainFB(domain, fbs);
        fbSet.addAll(fbs.toNativeArray());
        int m = fbs.size();
        for (int i = 0; i < m; ++i) {
            TIntHashSet tmp = new TIntHashSet();
            fb.getFBTypeByBiType(fbs.get(i), tmp);
            fbSet.addAll(tmp.toArray());
        }
        ArrayList fbList = TECircuitPackDescription.getInstance().getCPContainFBList(type, true);
        TIntIterator iter = fbSet.iterator();
        while (iter.hasNext()) {
            if (!fbList.contains(iter.next())) continue;
            return true;
        }
        return false;
    }

    public static boolean isEthernetBoard(int type) {
        return TEBoardUtil.isCPInDomain(type, 4);
    }

    public static int getSubrackIDFromSlot(int neID, int slotID) {
        if (TEBoardUtil.isSupportShelfDevice(neID)) {
            return slotID / 65536;
        }
        return -1;
    }

    public static int getSlotIDFromSlot(int neID, int slotID) {
        return slotID % 65536;
    }

    public static boolean isSupportShelfDevice(int neID) {
        TENE neObj = null;
        neObj = !TESysManagerBean.getInstance().isIntegratedStatus() ? TENEListMgr.getInstance().getNE(neID) : TENEListMgr.getInstance().getInterNE(neID);
        if (neObj.getNEType() == 67 && neObj.getShelfType() == Integer.parseInt("153")) {
            return false;
        }
        boolean slaveShelf = TEGetNEDomainVersion.getInstance().isSupportSlaveShelf(neObj.getNEType());
        if (!slaveShelf) {
            int devType = TEGetNEDomainVersion.getInstance().getDevType(neObj.getNEType());
            slaveShelf = TEEquipmentDescription.getInstance().isSupportSlaveShelf(devType);
        }
        return slaveShelf;
    }

    public static String getSubrackNameFromSlot(int neID, int slotID) {
        String subrackName = "";
        if (slotID > 0) {
            int subrackid = slotID / 65536;
            subrackName = TEBoardUtil.getSubrackNameFromSubrackID(neID, subrackid);
        }
        return subrackName;
    }

    public static String getSubrackNameFromSubrackID(int neID, int subrackid) {
        TENE neObj = TENEListMgr.getInstance().getNE(neID);
        String subrackName = "";
        if (neObj == null) {
            return TEGetFilePath.getResource(neID, PAKAGE_PATH).getString("shelf") + subrackid;
        }
        if (TEBoardUtil.isSupportShelfDevice(neID)) {
            Vector<TESubrack> subrackList = TENEConfigurationDataMgr.getInstance().getSubrackListRef(neID);
            if (!subrackList.isEmpty()) {
                for (int i = subrackList.size() - 1; i >= 0; --i) {
                    TESubrack sigleSubrack = subrackList.get(i);
                    if (!sigleSubrack.getSubrackID().equals(String.valueOf(subrackid))) continue;
                    subrackName = sigleSubrack.getSubrackName();
                    break;
                }
                subrackName = TEGetFilePath.getResource(neID, PAKAGE_PATH).getString("shelf") + subrackid + "(" + subrackName + ")";
            } else if (neObj.getNEType() == 51) {
                subrackName = subrackid == 0 ? TEGetFilePath.getResource(neID, PAKAGE_PATH).getString("mainsubtrack") + subrackid : TEGetFilePath.getResource(neID, PAKAGE_PATH).getString("subtrack") + subrackid;
                subrackName = TEGetFilePath.getResource(neID, PAKAGE_PATH).getString("shelf") + subrackid + "(" + subrackName + ")";
            }
        }
        return subrackName;
    }

    public static String getAsonShowSlotFromSlot(int neID, int slotID) {
        String showslot = slotID + "";
        if (slotID > 0) {
            int subrackid = slotID / 65536;
            showslot = TEGetFilePath.getResource(neID, PAKAGE_PATH).getString("shelf") + subrackid + "-" + slotID % 65536;
        }
        return showslot;
    }

    public static String getShelfSlotShow(int neID, int shelfID, int slotID, int portID) {
        String showShelfSlot = shelfID + "-" + slotID + "-" + portID;
        if (slotID > 0) {
            showShelfSlot = TEGetFilePath.getResource(neID, PAKAGE_PATH).getString("shelf") + shelfID + "-" + slotID + "-" + portID;
        }
        return showShelfSlot;
    }

    public static int subrackIDNEToNM(int slotID) {
        int slot = slotID & 0xFF;
        int shelfID = slotID & 0xFF00;
        return slot += (shelfID >>>= 8) * 65536;
    }

    public static int subrackIDNMToNE(int slotID) {
        int shelfID = slotID / 65536;
        int slot = slotID % 65536;
        slot = (shelfID <<= 8) + slot;
        return slot;
    }

    public static int slotIDNEToNM(int slotID) {
        int slot = slotID & 0x1F;
        int shelfID = slotID & 0xE0;
        return slot += (shelfID >>>= 5) * 65536;
    }

    public static int slotIDNMToNE(int slotID) {
        int shelfID = slotID / 65536;
        int slot = slotID % 65536;
        slot = (shelfID <<= 5) + slot;
        return slot;
    }

    public static int neToSlotIDNM(int shelfID, int slotID) {
        int countShlefID = 0;
        if (shelfID > 0) {
            countShlefID = shelfID;
        }
        return countShlefID * 65536 + slotID;
    }

    public static int convertShelfID(Integer shelfID) {
        return shelfID == null ? 0 : shelfID;
    }

    public static int bigSlotToSmall(int slotID) {
        return slotID % 65536;
    }

    public static int getSubrackType(int neId, int neType, int slotId) {
        int subrackType = neType;
        TENE ne = TENEListMgr.getInstance().getNE(neId);
        if (null != ne && TEBoardUtil.isSupportShelfDevice(neId)) {
            TESubrack subrack = null;
            int subrackId = TEBoardUtil.getSubrackIDFromSlot(neId, slotId);
            Vector subrackVec = ne.getClonedSubrackList();
            int m = subrackVec.size();
            for (int i = 0; i < m; ++i) {
                subrack = (TESubrack)subrackVec.get(i);
                if (subrackId != Integer.valueOf(subrack.getSubrackID())) continue;
                return Integer.valueOf(subrack.getNeType());
            }
        }
        return subrackType;
    }

    public static int getShelfType(int neId, int slotId) {
        int subrackType = -1;
        TENE ne = TENEListMgr.getInstance().getNE(neId);
        if (null != ne) {
            if (TEBoardUtil.isSupportShelfDevice(neId)) {
                TESubrack subrack = null;
                int subrackId = TEBoardUtil.getSubrackIDFromSlot(neId, slotId);
                Vector subrackVec = ne.getClonedSubrackList();
                int m = subrackVec.size();
                for (int i = 0; i < m; ++i) {
                    subrack = (TESubrack)subrackVec.get(i);
                    if (subrackId != Integer.valueOf(subrack.getSubrackID())) continue;
                    return Integer.valueOf(subrack.getLogicSubrackType());
                }
            } else {
                subrackType = ne.getNEType();
            }
        }
        return subrackType;
    }

    public static int getLogicSubrackType(int neId, int neType, int slotId) {
        int logicsubrackType = neType;
        TENE ne = TENEListMgr.getInstance().getNE(neId);
        if (null != ne && TEBoardUtil.isSupportShelfDevice(neId)) {
            TESubrack subrack = null;
            int subrackId = TEBoardUtil.getSubrackIDFromSlot(neId, slotId);
            Vector subrackVec = ne.getClonedSubrackList();
            int m = subrackVec.size();
            for (int i = 0; i < m; ++i) {
                subrack = (TESubrack)subrackVec.get(i);
                if (subrackId != Integer.valueOf(subrack.getSubrackID())) continue;
                return Integer.valueOf(subrack.getLogicSubrackType());
            }
        }
        return logicsubrackType;
    }

    public static String getTl1SubrackType(int neId, int neType, int slotId) {
        String subrackType = neType + "";
        TENE ne = TENEListMgr.getInstance().getNE(neId);
        if (null != ne && TEBoardUtil.isSupportShelfDevice(neId)) {
            TESubrack subrack = null;
            int subrackId = TEBoardUtil.getSubrackIDFromSlot(neId, slotId);
            Vector subrackVec = ne.getClonedSubrackList();
            int m = subrackVec.size();
            for (int i = 0; i < m; ++i) {
                subrack = (TESubrack)subrackVec.get(i);
                if (subrackId != Integer.valueOf(subrack.getSubrackID())) continue;
                return subrack.getNeType();
            }
        }
        return subrackType;
    }

    public static int getTl1SubrackTypeInt(int neId, int neType, int slotId) {
        int subrackType = neType;
        TENE ne = TENEListMgr.getInstance().getNE(neId);
        if (null != ne && TEBoardUtil.isSupportShelfDevice(neId)) {
            TESubrack subrack = null;
            int subrackId = TEBoardUtil.getSubrackIDFromSlot(neId, slotId);
            Vector subrackVec = ne.getClonedSubrackList();
            int m = subrackVec.size();
            for (int i = 0; i < m; ++i) {
                subrack = (TESubrack)subrackVec.get(i);
                if (subrackId != Integer.valueOf(subrack.getSubrackID())) continue;
                return subrack.getTl1NeTypeInt();
            }
        }
        return subrackType;
    }

    public static int getRelativeShelfID(int cnemgrSlotID) {
        return cnemgrSlotID / 65536;
    }

    public static boolean isSupportSubCard(int boardType) {
        return TEBoardConfigurationDataMgr.getInstance().isSupportSubCard(boardType);
    }

    public static String getSupportSubCardTypes(int neID, int boardType) {
        String result = "";
        if (TEBoardUtil.isSupportSubCard(boardType)) {
            result = "2319-" + TEConfigurationDataMgr.getInstance().getBoardTypeName(neID, 2319);
        }
        return result;
    }

    public static String getShelfBoardName(int neID, int slotID) {
        StringBuffer fullNameBuffer = new StringBuffer();
        TEBoard board = TEConfigurationDataMgr.getInstance().getBoard(neID, slotID);
        if (null == board) {
            return String.valueOf(slotID);
        }
        String subrackname = TEBoardUtil.getSubrackNameFromSlot(neID, slotID);
        if (!subrackname.isEmpty()) {
            fullNameBuffer.append(subrackname);
        }
        if (0 != fullNameBuffer.length()) {
            fullNameBuffer.append('-');
        }
        int relativeSlotID = TEBoardUtil.getSlotIDFromSlot(neID, slotID);
        fullNameBuffer.append(relativeSlotID);
        fullNameBuffer.append('-').append(board.getBoardName());
        return fullNameBuffer.toString();
    }

    static {
        BASE_PATH = "necommon" + File.separator + "res" + File.separator;
        PAKAGE_PATH = BASE_PATH + "subrackres_" + TESysManagerBean.getInstance().getlanguage() + ".ini";
    }

    public static enum TEINDICATIONAttr {
        INDICATION_UNLOAD,
        INDICATION_LOAD;

    }
}

