/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.util.device;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TEParseXMLFile;
import com.huawei.nglct.util.device.ne.TEGetNEDomainVersion;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.xml.TEResourceManager;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TEVersionRelationBean {
    private Map versionMap = new HashMap();
    private Map<Integer, Map<String, List<String>>> parentVerMap = new HashMap<Integer, Map<String, List<String>>>();
    private Map<String, Map<String, String>> domainRelationMap = new Hashtable<String, Map<String, String>>();
    private static TEVersionRelationBean m_instance = null;
    private Map versionNeTypeMap = new HashMap();
    public static final String DOMAIN_CONF_TYPE = "neadpter";

    private TEVersionRelationBean() {
    }

    public static synchronized TEVersionRelationBean getInstance() {
        if (null == m_instance) {
            m_instance = new TEVersionRelationBean();
        }
        return m_instance;
    }

    public void loadVersionRelation(int neType) {
        String domain = TEGetNEDomainVersion.getInstance().getDomain(neType);
        String filePath = TEResourceManager.getPath() + File.separator + "nemgr" + File.separator + "device" + File.separator + domain + File.separator + "ne_" + neType + File.separator + "conf" + File.separator + "versionrelation.xml";
        Document doc = null;
        try {
            String bundleName = TEGetFilePath.getNEBundleName(neType);
            doc = TEParseXMLFile.parseFile(bundleName, filePath);
        }
        catch (Exception ex) {
            TELogFactory.getNormalLogger().error("TEVersionRelationBean.loadVersionRelation() fail!", (Throwable)ex);
        }
        if (null != doc) {
            int versionNeType = -1;
            int pNeType = -1;
            try {
                NodeList relationNodeList = doc.getElementsByTagName("relation");
                Element neTypeNode = (Element)relationNodeList.item(0);
                versionNeType = Integer.parseInt(neTypeNode.getAttribute("netype"));
                if (neTypeNode.hasAttribute("pnetype")) {
                    pNeType = Integer.parseInt(neTypeNode.getAttribute("pnetype"));
                }
            }
            catch (Exception ex) {
                versionNeType = -1;
            }
            if (!this.versionNeTypeMap.containsKey(neType) && versionNeType != neType) {
                this.versionNeTypeMap.put(neType, versionNeType);
            }
            NodeList nodeList = doc.getElementsByTagName("version");
            int m = nodeList.getLength();
            for (int i = 0; i < m; ++i) {
                Map<String, String> verMap;
                Node node = nodeList.item(i);
                NamedNodeMap nodeMap = node.getAttributes();
                String verId = nodeMap.getNamedItem("verid").getNodeValue();
                String parent = nodeMap.getNamedItem("parent").getNodeValue();
                TELogFactory.getNormalLogger().info("verId is " + verId + ",parent is " + parent);
                if (this.versionMap.containsKey(neType)) {
                    verMap = (Map)this.versionMap.get(neType);
                    verMap.put(verId, parent);
                } else {
                    verMap = new HashMap<String, String>();
                    verMap.put(verId, parent);
                    this.versionMap.put(neType, verMap);
                }
                if (nodeMap.getNamedItem("pverid") == null || nodeMap.getNamedItem("pverid").getNodeValue().equals("")) continue;
                String pverid = nodeMap.getNamedItem("pverid").getNodeValue();
                Map<String, List<String>> cfgMap = this.parentVerMap.get(neType);
                if (cfgMap == null) {
                    cfgMap = new HashMap<String, List<String>>();
                    this.parentVerMap.put(neType, cfgMap);
                }
                if (pverid.equals("")) continue;
                String[] verids = pverid.split(",");
                ArrayList<String> veridList = new ArrayList<String>();
                int lenj = verids.length;
                for (int j = 0; j < lenj; ++j) {
                    if (pNeType == -1) {
                        veridList.add(DOMAIN_CONF_TYPE + File.separator + verids[j]);
                        continue;
                    }
                    veridList.add("ne_" + pNeType + File.separator + verids[j]);
                }
                cfgMap.put(verId, veridList);
            }
        }
        if (!this.versionMap.containsKey(neType)) {
            filePath = TEResourceManager.getPath() + File.separator + "nemgr" + File.separator + "device" + File.separator + domain + File.separator + "ne_" + neType;
            File file = null;
            try {
                String bundleName = TEGetFilePath.getNEBundleName(neType);
                file = TEResourceManager.getFileByName(bundleName, filePath);
            }
            catch (Exception ex) {
                TELogFactory.getNormalLogger().error("TEVersionRelationBean.loadVersionRelation() fail!", (Throwable)ex);
            }
            if (null != file && file.exists() && file.isDirectory()) {
                File[] files = file.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.matches("\\d*\\.\\d*\\.\\d*\\.\\d*");
                    }
                });
                int n = files.length;
                for (int j = 0; j < n; ++j) {
                    Map<String, String> verMap;
                    String fileName = files[j].getName();
                    if (this.versionMap.containsKey(neType)) {
                        verMap = (Map)this.versionMap.get(neType);
                        verMap.put(fileName, fileName);
                        continue;
                    }
                    verMap = new HashMap<String, String>();
                    verMap.put(fileName, fileName);
                    this.versionMap.put(neType, verMap);
                }
            }
        }
    }

    public List<String> getParentVersion(int neType, String verId) {
        Map<String, List<String>> verMap;
        if (null == verId || "".equals(verId)) {
            return null;
        }
        List<String> pVersions = null;
        Integer nType = neType;
        if (!this.versionMap.containsKey(nType)) {
            this.loadVersionRelation(neType);
        }
        if (this.parentVerMap.containsKey(nType) && (verMap = this.parentVerMap.get(nType)).containsKey(verId)) {
            pVersions = verMap.get(verId);
        }
        return pVersions;
    }

    public String gerParentVersion(int neType, String verId) {
        Map verMap;
        if (null == verId || "".equals(verId)) {
            return verId;
        }
        String version = verId;
        Integer nType = neType;
        if (!this.versionMap.containsKey(nType)) {
            this.loadVersionRelation(neType);
        }
        if (this.versionMap.containsKey(nType) && (verMap = (Map)this.versionMap.get(nType)).containsKey(verId)) {
            version = (String)verMap.get(verId);
        }
        if (version.equalsIgnoreCase(verId)) {
            version = this.getOldVersion(nType, version);
        }
        return version;
    }

    public String getFirstVersion(int neType, String verId) {
        if (null == verId || "".equals(verId)) {
            return verId;
        }
        String firstVersion = verId;
        if (!this.versionMap.containsKey(neType)) {
            TELogFactory.getNormalLogger().info("TEVersionRelationBean.loadVersionRelation,netype is:" + neType);
            this.loadVersionRelation(neType);
        }
        if (this.versionMap.containsKey(neType)) {
            Map verMap = (Map)this.versionMap.get(neType);
            if (verMap.containsKey(verId)) {
                if ((verId = (String)verMap.get(verId)).equals(firstVersion)) {
                    return verId;
                }
                firstVersion = this.getFirstVersion(neType, verId);
            } else if (!firstVersion.equals(verId = this.getOldVersion(neType, verId))) {
                firstVersion = this.getFirstVersion(neType, verId);
            }
        } else if (!firstVersion.equals(verId = this.getOldVersion(neType, verId))) {
            firstVersion = this.getFirstVersion(neType, verId);
        }
        return firstVersion;
    }

    private String getOldVersion(int neType, String version) {
        long verLong = this.convertLong(version);
        String ver = "";
        long tmp = 0L;
        Map.Entry entry2 = null;
        HashMap<Long, String> tmpVer = new HashMap<Long, String>();
        ArrayList cverList = new ArrayList();
        HashMap versions = (HashMap)this.versionMap.get(neType);
        if (versions == null) {
            return version;
        }
        Set key = versions.entrySet();
        for (Map.Entry entry2 : key) {
            ver = (String)entry2.getKey();
            tmp = this.convertLong(ver);
            if (tmp == verLong) {
                return version;
            }
            if (tmp < verLong) {
                tmpVer.put(tmp, ver);
            }
            if ((tmp = this.convertLong(ver = (String)entry2.getValue())) == verLong) {
                return version;
            }
            if (tmp > verLong) continue;
            tmpVer.put(tmp, ver);
        }
        cverList.addAll(tmpVer.keySet());
        Collections.sort(cverList);
        if (cverList.size() == 0) {
            return version;
        }
        version = (String)tmpVer.get(cverList.get(cverList.size() - 1));
        return version;
    }

    private long convertLong(String version) {
        String[] vers = version.split("\\.");
        StringBuffer ver = new StringBuffer();
        int m = vers.length;
        for (int i = 0; i < m; ++i) {
            ver.append(vers[i]);
        }
        return Long.parseLong(ver.toString());
    }

    public int getNEType(int neType) {
        if (this.versionNeTypeMap.containsKey(neType)) {
            return (Integer)this.versionNeTypeMap.get(neType);
        }
        return -1;
    }
}

