/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.util.datetime;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TEParseXMLFile;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.gencfg.TETimeTocalizationSwitchBean;
import com.huawei.nglct.nelist.TENEListInterface;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.xml.TERWCfgFile;
import com.huawei.nglct.util.xml.TEResourceManager;
import java.io.File;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TESetTimeFormatBean
implements TENEListInterface {
    private static final String TIME_FORMAT_FILE_NAME = "timeformat.xml";

    @Override
    public Datainterface subFuncProcessed(SubFunc subFunc, Datainterface inputData, String ipAddress) {
        Datainterface outputData = new Datainterface();
        try {
            RowParams rows = inputData.getBussinessParams().getRowParams(0);
            String newFormatType = rows.getParam("timeformattype").getValue();
            String newFormatName = rows.getParam("timeformatname").getValue();
            TETimeTocalizationSwitchBean.setTimeFormatStr(newFormatName);
            if (!this.setTimeFormat(newFormatType, newFormatName)) {
                outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(2));
            } else {
                outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(0));
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TESetTimeFormatBean.subFuncProcessed() fail!", (Throwable)e);
        }
        return outputData;
    }

    private boolean setTimeFormat(String newFormatType, String newFormatName) {
        String ROOT_PATH_STR = "";
        String rwCfgFilePath = TERWCfgFile.getBundleRWCfgFilePath(TEResourceManager.class, "");
        StringBuffer filePath = new StringBuffer(rwCfgFilePath).append(File.separator).append(TEPathManager.CONFIG_PROFILE_PATH).append(TIME_FORMAT_FILE_NAME);
        Document doc = null;
        try {
            File file = new File(filePath.toString());
            doc = TEParseXMLFile.parseFile(file.toURL().openStream());
            NodeList timeFormatNodeList = doc.getElementsByTagName("timeformat");
            Element timeFormat = (Element)timeFormatNodeList.item(0);
            timeFormat.getElementsByTagName("formatType").item(0).getFirstChild().setNodeValue(newFormatType);
            timeFormat.getElementsByTagName("formatName").item(0).getFirstChild().setNodeValue(newFormatName);
            file.delete();
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(new File(filePath.toString()));
            transformer.transform(source, result);
            return true;
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TESetTimeFormatBean.setTimeFormat() fail!", (Throwable)e);
            return false;
        }
    }
}

