/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.util.datetime;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.gencfg.TETimeTocalizationSwitchBean;
import com.huawei.nglct.gencfg.TimeZoneDateBean;
import com.huawei.nglct.nemgr.f_interface.asncommon.AsnDateTimeType;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.SimpleTimeZone;
import java.util.TimeZone;

public class TEDateUtils {
    public static final int BASE_YEAR = 1990;
    public static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String DEFAULT_DATEYMD_FORMAT = "yyyy-MM-dd";
    public static final String DEFAULT_DATEHMS_FORMAT = "HH:mm:ss";

    public static Calendar byteStrToCalendar(String byteStr) {
        if (TEDateUtils.isNull(byteStr) || !TEDateUtils.isValid(byteStr)) {
            return null;
        }
        byte[] bytes = byteStr.getBytes();
        byte year = bytes[0];
        byte month = bytes[1];
        byte day = bytes[2];
        byte h = bytes[3];
        byte m = bytes[4];
        byte s = bytes[5];
        Calendar calendar = Calendar.getInstance();
        calendar.set(year + 1990, month - 1, day, h, m, s);
        return calendar;
    }

    public static Calendar byteStrToCalendarYmd(String byteStr) {
        if (TEDateUtils.isNullThr(byteStr) || !TEDateUtils.isValidYmd(byteStr)) {
            return null;
        }
        byte[] bytes = byteStr.getBytes();
        byte year = bytes[0];
        byte month = bytes[1];
        byte day = bytes[2];
        Calendar calendar = Calendar.getInstance();
        calendar.set(year + 1990, month - 1, day);
        return calendar;
    }

    public static Calendar byteStrToCalendarHms(String byteStr) {
        if (TEDateUtils.isNullThr(byteStr) || !TEDateUtils.isValidHms(byteStr)) {
            return null;
        }
        byte[] bytes = byteStr.getBytes();
        byte h = bytes[0];
        byte m = bytes[1];
        byte s = bytes[2];
        Calendar calendar = Calendar.getInstance();
        calendar.set(h, m, s);
        return calendar;
    }

    public static String calendarToByteStr(Calendar cal) {
        int year = cal.get(1) - 1990;
        int month = cal.get(2) + 1;
        int day = cal.get(5);
        int h = cal.get(11);
        int m = cal.get(12);
        int s = cal.get(13);
        byte[] bDate = new byte[]{(byte)year, (byte)month, (byte)day, (byte)h, (byte)m, (byte)s};
        return new String(bDate);
    }

    public static String calendarToByteStrYmd(Calendar cal) {
        int year = cal.get(1) - 1990;
        int month = cal.get(2) + 1;
        int day = cal.get(5);
        byte[] bDate = new byte[]{(byte)year, (byte)month, (byte)day};
        return new String(bDate);
    }

    public static String calendarToByteStrHms(Calendar cal) {
        int h = cal.get(11);
        int m = cal.get(12);
        int s = cal.get(13);
        byte[] bDate = new byte[]{(byte)h, (byte)m, (byte)s};
        return new String(bDate);
    }

    public static String calendarToStr(Calendar cal) {
        return TEDateUtils.calendarToStr(cal, TimeZoneDateBean.getTimeConvertFormat());
    }

    public static String calendarToStrYmd(Calendar cal) {
        return TEDateUtils.calendarToStr(cal, DEFAULT_DATEYMD_FORMAT);
    }

    public static String calendarToStrHms(Calendar cal) {
        return TEDateUtils.calendarToStr(cal, DEFAULT_DATEHMS_FORMAT);
    }

    public static String calendarToStr(Calendar cal, String format) {
        if (null == cal) {
            return "";
        }
        SimpleDateFormat formatter = new SimpleDateFormat(format, Locale.ENGLISH);
        return formatter.format(cal.getTime());
    }

    public static Calendar strToCalendar(String dateStr) {
        Calendar result;
        String timeformat = DEFAULT_DATE_FORMAT;
        if (!TESysManagerBean.getInstance().isIntegratedStatus()) {
            timeformat = TimeZoneDateBean.getTimeConvertFormat();
        }
        if ((result = TEDateUtils.strToCalendar(dateStr, timeformat)) == null) {
            String timeformat2 = "MM/dd/yyyy HH:mm:ss";
            result = TEDateUtils.strToCalendar(dateStr, timeformat2);
        }
        return result;
    }

    public static Calendar strToCalendar(String dateStr, String format) {
        SimpleDateFormat formatter = new SimpleDateFormat(format, Locale.ENGLISH);
        try {
            Date date = formatter.parse(dateStr);
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(date);
            return cal;
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("strToCalendar Exception.", (Throwable)e);
            return null;
        }
    }

    public static String byteStrToDateStr(String byteStr) {
        return TEDateUtils.calendarToStr(TEDateUtils.byteStrToCalendar(byteStr));
    }

    public static String byteStrToDateStrYmd(String byteStr) {
        return TEDateUtils.calendarToStrYmd(TEDateUtils.byteStrToCalendarYmd(byteStr));
    }

    public static String byteStrToDateStrHms(String byteStr) {
        return TEDateUtils.calendarToStrHms(TEDateUtils.byteStrToCalendarHms(byteStr));
    }

    public static String dateStrToByteStr(String dateStr) {
        return TEDateUtils.calendarToByteStr(TEDateUtils.strToCalendar(dateStr));
    }

    public static String dateStrToByteStrHms(String dateStr) {
        return TEDateUtils.calendarToByteStrHms(TEDateUtils.strToCalendar(dateStr));
    }

    public static String dateStrToByteStrYmd(String dateStr) {
        return TEDateUtils.calendarToByteStrYmd(TEDateUtils.strToCalendar(dateStr));
    }

    public static String nullDate() {
        byte[] bytes = new byte[]{0, 0, 0, 0, 0, 0};
        return new String(bytes);
    }

    public static boolean isNull(String byteStr) {
        byte[] bytes = byteStr.getBytes();
        return bytes[0] == 0 && bytes[1] == 0 && bytes[2] == 0 && bytes[3] == 0 && bytes[4] == 0 && bytes[5] == 0;
    }

    public static boolean isNullThr(String byteStr) {
        byte[] bytes = byteStr.getBytes();
        return bytes[0] == 0 && bytes[1] == 0 && bytes[2] == 0;
    }

    public static boolean isValid(String byteStr) {
        byte[] bytes = byteStr.getBytes();
        return bytes[0] < 48 || bytes[1] >= 1 && bytes[1] <= 12 || bytes[2] >= 1 && bytes[2] <= 31 || bytes[3] <= 24 && bytes[4] <= 60 && bytes[5] <= 60;
    }

    public static boolean isValidYmd(String byteStr) {
        byte[] bytes = byteStr.getBytes();
        return bytes[0] < 48 || bytes[1] >= 1 && bytes[1] <= 12 || bytes[2] >= 1 && bytes[2] <= 31;
    }

    public static boolean isValidHms(String byteStr) {
        byte[] bytes = byteStr.getBytes();
        return bytes[0] <= 24 && bytes[1] <= 60 && bytes[2] <= 60;
    }

    public static ArrayList computeZeroPeriod(ArrayList tmList, int period) {
        int nMaxEventCount = 0;
        long nInterval = 0L;
        if (1 == period) {
            nInterval = 900000L;
            nMaxEventCount = 16;
        } else {
            nMaxEventCount = 6;
            nInterval = 86400000L;
        }
        ArrayList<Object> tmTmpList = new ArrayList<Object>();
        if (!tmList.isEmpty()) {
            Calendar tmpTime = (Calendar)tmList.get(0);
            TELogFactory.getNormalLogger().info("\u00bc\u00c6\u00cb\u00e3\u00b5\u00c4\u00d6\u00dc\u00c6\u00da\u00ca\u00b1\u00bc\u00e4\u00b5\u00e3\u00c8\u00e7\u00cf\u00c2:");
            for (int i = 0; i < nMaxEventCount; ++i) {
                TELogFactory.getNormalLogger().info(TEDateUtils.calendarToStr(tmpTime));
                tmTmpList.add(tmpTime.clone());
                tmpTime.setTimeInMillis(tmpTime.getTimeInMillis() - nInterval);
            }
        }
        return tmTmpList;
    }

    public static ArrayList computeZeroPeriod2(ArrayList tmList, int period) {
        int nMaxEventCount = 0;
        long nInterval = 0L;
        if (1 == period) {
            nInterval = 900000L;
            nMaxEventCount = 16;
        } else {
            nMaxEventCount = 6;
            nInterval = 86400000L;
        }
        ArrayList<Object> tmTmpList = new ArrayList<Object>();
        if (!tmList.isEmpty()) {
            Calendar tmpTime = (Calendar)tmList.get(0);
            TELogFactory.getNormalLogger().info("\u00bc\u00c6\u00cb\u00e3\u00b5\u00c4\u00d6\u00dc\u00c6\u00da\u00ca\u00b1\u00bc\u00e4\u00b5\u00e3\u00c8\u00e7\u00cf\u00c2:");
            for (int i = 0; i < nMaxEventCount; ++i) {
                TELogFactory.getNormalLogger().info(TEDateUtils.calendarToStr(tmpTime));
                tmTmpList.add(tmpTime.clone());
                tmpTime.setTimeInMillis(tmpTime.getTimeInMillis() - nInterval);
            }
        }
        return tmTmpList;
    }

    public static String convertDateFormat(Calendar cal, String dateFormat) {
        SimpleDateFormat prbsFormat = null;
        GregorianCalendar calendar = null;
        prbsFormat = new SimpleDateFormat(dateFormat, Locale.ENGLISH);
        int year = cal.get(1);
        int month = cal.get(2);
        int day = cal.get(7);
        int h = cal.get(11);
        int m = cal.get(12);
        int s = cal.get(13);
        calendar = new GregorianCalendar(year, month - 1, day + 10, h, m, s);
        Date time = calendar.getTime();
        String timeStr = prbsFormat.format(time, new StringBuffer(), new FieldPosition(20)).toString();
        return timeStr;
    }

    public static Calendar pageTimeToCal(String pageTime) {
        int year = new Integer(pageTime.substring(0, 2));
        int month = new Integer(pageTime.substring(2, 4));
        int day = new Integer(pageTime.substring(4, 6));
        int h = new Integer(pageTime.substring(6, 8));
        int m = new Integer(pageTime.substring(8, 10));
        int s = new Integer(pageTime.substring(10, 12));
        Calendar calendar = Calendar.getInstance();
        calendar.set(year + 1990, month - 1, day, h, m, s);
        return calendar;
    }

    public static Calendar parseTimeDesc(String timeDesc) {
        String[] snippets = timeDesc.split(" ");
        if (snippets == null || snippets.length < 2) {
            return null;
        }
        String first = snippets[0].trim();
        String second = snippets[1].trim();
        String[] subSnippets = first.split("-");
        if (subSnippets == null || subSnippets.length < 3) {
            return null;
        }
        if (second == null || second.length() < 8) {
            return null;
        }
        String zoneOffset = null;
        if (second.length() > 8 && (zoneOffset = second.substring(8, 11)).startsWith("+")) {
            zoneOffset = zoneOffset.substring(1);
        }
        GregorianCalendar calendar = null;
        if (zoneOffset == null) {
            calendar = new GregorianCalendar();
        } else {
            String[] ids = TimeZone.getAvailableIDs(Integer.parseInt(zoneOffset) * 60 * 60 * 1000);
            SimpleTimeZone pdt = new SimpleTimeZone(Integer.parseInt(zoneOffset) * 60 * 60 * 1000, ids[0]);
            calendar = new GregorianCalendar(pdt);
        }
        calendar.set(1, Integer.parseInt(subSnippets[0].trim()));
        calendar.set(2, Integer.parseInt(subSnippets[1].trim()) - 1);
        calendar.set(5, Integer.parseInt(subSnippets[2].trim()));
        calendar.set(11, Integer.parseInt(second.substring(0, 2)));
        calendar.set(12, Integer.parseInt(second.substring(3, 5)));
        calendar.set(13, Integer.parseInt(second.substring(6, 8)));
        return calendar;
    }

    public static long TEUTC2UTC(Calendar utcTm) {
        TimeZone timeZone = TimeZone.getDefault();
        long sysTimeZoneOffset = timeZone.getOffset(System.currentTimeMillis());
        utcTm.set(16, 0);
        long utcTime = utcTm.getTimeInMillis();
        return utcTime -= sysTimeZoneOffset;
    }

    public static Calendar TEUTC2UTC(long utcTime) {
        Calendar utcTm = Calendar.getInstance();
        utcTm.set(16, 0);
        utcTm.setTimeInMillis(utcTime);
        return utcTm;
    }

    public static void AsnDatetime2UTC(AsnDateTimeType utcAsnDateTime, Calendar utcTm) {
        utcTm.set(16, 0);
        utcTm.set(1, utcAsnDateTime.year);
        utcTm.set(2, utcAsnDateTime.month - 1);
        utcTm.set(5, utcAsnDateTime.day);
        utcTm.set(11, utcAsnDateTime.hour);
        utcTm.set(12, utcAsnDateTime.minute);
        utcTm.set(13, utcAsnDateTime.second);
    }

    public static void UTC2AsnDatetime(Calendar utcTm, AsnDateTimeType utcAsnDateTime) {
        utcAsnDateTime.year = utcTm.get(1);
        utcAsnDateTime.month = utcTm.get(2) + 1;
        utcAsnDateTime.day = utcTm.get(5);
        utcAsnDateTime.hour = utcTm.get(11);
        utcAsnDateTime.minute = utcTm.get(12);
        utcAsnDateTime.second = utcTm.get(13);
    }

    public static boolean ifValidateNETime(int nyear, int nmonth, int nday, int nhour, int nminute, int nsecond) {
        if (nyear < 1990 || nyear > 2246) {
            return false;
        }
        if (nmonth < 1 || nmonth > 12) {
            return false;
        }
        if (nday < 1 || nday > 31) {
            return false;
        }
        if (nhour > 23 || nhour < 0) {
            return false;
        }
        if (nminute > 59 || nminute < 0) {
            return false;
        }
        return nsecond <= 59 && nsecond >= 0;
    }

    public static int getNMUTCTime(Calendar tNmTime) {
        long serverT = System.currentTimeMillis();
        Calendar serverTime = TEDateUtils.TEUTC2UTC(serverT);
        if (!TEDateUtils.ifValidateNETime(serverTime.get(1), serverTime.get(2) + 1, serverTime.get(5), serverTime.get(11), serverTime.get(12), serverTime.get(13))) {
            return 1090595587;
        }
        tNmTime.set(1, serverTime.get(1));
        tNmTime.set(2, serverTime.get(2));
        tNmTime.set(5, serverTime.get(5));
        tNmTime.set(11, serverTime.get(11));
        tNmTime.set(12, serverTime.get(12));
        tNmTime.set(13, serverTime.get(13));
        return 0;
    }

    public static Calendar getTL1NMTimeFromNETime(int neid, long neDate) {
        TimeZone serverZone = TimeZone.getDefault();
        Calendar cal = TEDateUtils.getTL1UTCTimeFromNETime(neid, neDate);
        Date date = null;
        date = serverZone.inDaylightTime(new Date(neDate)) ? new Date(cal.getTimeInMillis() + (long)serverZone.getRawOffset() + (long)serverZone.getDSTSavings()) : new Date(cal.getTimeInMillis() + (long)serverZone.getRawOffset());
        Calendar rtnCal = Calendar.getInstance();
        rtnCal.setTime(date);
        return rtnCal;
    }

    public static Calendar getTL1UTCTimeFromNETime(int neid, long neDate) {
        TimeZoneDateBean timeProccessor = TETimeTocalizationSwitchBean.getTimeZoneDateInstance(neid);
        Calendar car = Calendar.getInstance();
        car.setTime(new Date(neDate));
        timeProccessor.getNETimeParams().getUTCFromTime(car);
        return car;
    }

    public static Calendar setNETimeToUtcDstDate(long neDate, String timeZone, int dstTime) {
        String neZone = TEDateUtils.setNEStrToUtcStr(timeZone);
        TimeZone zone = TimeZone.getTimeZone(neZone);
        TimeZone serverZone = TimeZone.getDefault();
        long dstTimeMill = dstTime * 60 * 1000;
        Date date = new Date(neDate - (long)zone.getRawOffset() + (long)serverZone.getRawOffset() - dstTimeMill);
        Calendar car = Calendar.getInstance();
        car.setTime(date);
        return car;
    }

    public static String setNEStrToUtcStr(String neStr) {
        String utcStr = "GMT";
        if (neStr.equals("UTC")) {
            return "GMT";
        }
        if (neStr.equals("EASTERN")) {
            return "GMT-5";
        }
        if (neStr.equals("CENTRAL")) {
            return "GMT-6";
        }
        if (neStr.equals("MOUNTAIN")) {
            return "GMT-7";
        }
        if (neStr.equals("PACIFIC")) {
            return "GMT-8";
        }
        if (neStr.equals("ALASKA")) {
            return "GMT-9";
        }
        if (neStr.equals("HAWAII")) {
            return "GMT-10";
        }
        if (neStr.equals("SAMOA")) {
            return "GMT-11";
        }
        if (neStr.indexOf("GMT") != -1) {
            return neStr;
        }
        return utcStr;
    }

    public static Calendar getTL1NETimeFromNMTime(int neid, long nmTime) {
        TimeZone serverZone = TimeZone.getDefault();
        Date utcDate = serverZone.inDaylightTime(new Date(nmTime)) ? new Date(nmTime - (long)(serverZone.getRawOffset() + serverZone.getDSTSavings())) : new Date(nmTime - (long)serverZone.getRawOffset());
        TimeZoneDateBean timeProccessor = TETimeTocalizationSwitchBean.getTimeZoneDateInstance(neid);
        Calendar car = Calendar.getInstance();
        car.setTime(utcDate);
        timeProccessor.getNETimeParams().getTimeFromUTC(car);
        return car;
    }

    public static Calendar getTL1NETimeFromNMUTCTime(int neid, long utcTime) {
        TimeZoneDateBean timeProccessor = TETimeTocalizationSwitchBean.getTimeZoneDateInstance(neid);
        Calendar car = Calendar.getInstance();
        car.setTime(new Date(utcTime));
        timeProccessor.getNETimeParams().getTimeFromUTC(car);
        return car;
    }

    public static Calendar setUtcDateToNMTime(long utcTime) {
        TimeZone serverZone = TimeZone.getDefault();
        Date date = new Date(utcTime + (long)serverZone.getRawOffset() + (long)serverZone.getDSTSavings());
        Calendar car = Calendar.getInstance();
        car.setTime(date);
        return car;
    }

    public static Calendar byteStrToCalendar(String byteStr, int baseyear) {
        if (TEDateUtils.isNull(byteStr) || !TEDateUtils.isValid(byteStr)) {
            return null;
        }
        byte[] bytes = byteStr.getBytes();
        byte year = bytes[0];
        byte month = bytes[1];
        byte day = bytes[2];
        byte h = bytes[3];
        byte m = bytes[4];
        byte s = bytes[5];
        Calendar calendar = Calendar.getInstance();
        calendar.set(year + baseyear, month - 1, day, h, m, s);
        return calendar;
    }

    public static Calendar byteStrToCalendarYmd(String byteStr, int baseyear) {
        if (TEDateUtils.isNullThr(byteStr) || !TEDateUtils.isValidYmd(byteStr)) {
            return null;
        }
        byte[] bytes = byteStr.getBytes();
        byte year = bytes[0];
        byte month = bytes[1];
        byte day = bytes[2];
        Calendar calendar = Calendar.getInstance();
        calendar.set(year + baseyear, month - 1, day);
        return calendar;
    }

    public static String calendarToByteStr(Calendar cal, int baseyear) {
        int year = cal.get(1) - baseyear;
        int month = cal.get(2) + 1;
        int day = cal.get(5);
        int h = cal.get(11);
        int m = cal.get(12);
        int s = cal.get(13);
        if (year < 0) {
            year = 0;
            month = 1;
            day = 1;
            h = 0;
            m = 0;
            s = 0;
        }
        byte[] bDate = new byte[]{(byte)year, (byte)month, (byte)day, (byte)h, (byte)m, (byte)s};
        return new String(bDate);
    }

    public static String byteStrToDateStrYmd(String byteStr, int baseyear) {
        return TEDateUtils.calendarToStrYmd(TEDateUtils.byteStrToCalendarYmd(byteStr, baseyear));
    }

    public static String dateStrToByteStr(String dateStr, int baseyear) {
        return TEDateUtils.calendarToByteStr(TEDateUtils.strToCalendar(dateStr), baseyear);
    }
}

