/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.util.convertor;

import com.huawei.nglct.sysmanager.TESysManagerBean;

public class TETimeSlotConvertUtil {
    public static int HUIWEI_MODE = 0;
    public static int LANGXUN_MODE = 1;
    public int userSelectMode = TESysManagerBean.getInstance().getSlotMode();
    public int neMode = 0;
    public static int[] g_iSlotOrder = new int[]{1, 22, 43, 4, 25, 46, 7, 28, 49, 10, 31, 52, 13, 34, 55, 16, 37, 58, 19, 40, 61, 2, 23, 44, 5, 26, 47, 8, 29, 50, 11, 32, 53, 14, 35, 56, 17, 38, 59, 20, 41, 62, 3, 24, 45, 6, 27, 48, 9, 30, 51, 12, 33, 54, 15, 36, 57, 18, 39, 60, 21, 42, 63};

    public static int getCurrentTimeSlotMode() {
        return HUIWEI_MODE;
    }

    public static int getUserDefineTimeSlotMode() {
        return TESysManagerBean.getInstance().getSlotMode();
    }

    public static int convertHuaweiToLangxunMode(int timeslot) {
        int nCode = 0;
        if (timeslot > 65535) {
            nCode = timeslot / 65536;
            timeslot &= 0xFFFF;
        }
        if (timeslot > 0 && timeslot < 64) {
            timeslot = g_iSlotOrder[timeslot - 1];
        }
        timeslot = nCode * 65536 + timeslot;
        return timeslot;
    }

    public static int convertLangxunToHuaweiMode(int timeslot) {
        int nCode = 0;
        if (timeslot > 65535) {
            nCode = timeslot / 65536;
            timeslot &= 0xFFFF;
        }
        if (timeslot > 0 && timeslot < 64) {
            int size = g_iSlotOrder.length;
            for (int i = 0; i < size; ++i) {
                if (g_iSlotOrder[i] != timeslot) continue;
                timeslot = i + 1;
                break;
            }
        }
        timeslot = nCode * 65536 + timeslot;
        return timeslot;
    }

    public static int readMode() {
        return TESysManagerBean.getInstance().getSlotMode();
    }

    public static int convertSlotMode(int timeslot) {
        if (LANGXUN_MODE == TETimeSlotConvertUtil.readMode()) {
            return TETimeSlotConvertUtil.convertHuaweiToLangxunMode(timeslot);
        }
        return timeslot;
    }

    public static int revertSlotMode(int timeslot) {
        if (LANGXUN_MODE == TETimeSlotConvertUtil.readMode()) {
            return TETimeSlotConvertUtil.convertLangxunToHuaweiMode(timeslot);
        }
        return timeslot;
    }
}

