/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.util.convertor;

import java.util.StringTokenizer;

public class IPAddressUtil {
    public static final String INITSTRING = "   .   .   .   ";
    public static final int IP_MAX_VALUE = 255;

    public static boolean isValidIP(String szIP) {
        long ip = IPAddressUtil.convertIPStrToLong(szIP);
        if (ip <= 0L) {
            return false;
        }
        int[] ipSegment = IPAddressUtil.ipToArray(ip);
        return ipSegment[0] != 255 && ipSegment[3] != 255 && ipSegment[0] != 0 && ipSegment[3] != 0;
    }

    public static boolean isLocalLoopIP(String szIP) {
        long ip = IPAddressUtil.convertIPStrToLong(szIP);
        int[] ipSegment = IPAddressUtil.ipToArray(ip);
        return ipSegment[0] == 127;
    }

    public static String getValidIP(String szIP) {
        return IPAddressUtil.convertIPAddress(szIP);
    }

    public static long convertIPStrToLong(String ipStr) {
        if (null == ipStr) {
            return 0L;
        }
        char[] ch = ipStr.toCharArray();
        long result = 0L;
        long sum = 0L;
        int TCount = 0;
        boolean frontIsPoint = true;
        int[] T = new int[]{0x1000000, 65536, 256};
        int[] nMax = new int[]{255, 255, 255, 255};
        for (int i = 0; i < ipStr.length(); ++i) {
            if (ch[i] >= '0' && ch[i] <= '9') {
                if ((sum = sum * 10L + (long)(ch[i] - 48)) > (long)nMax[3]) {
                    return 0L;
                }
                frontIsPoint = false;
                continue;
            }
            if (ch[i] == '.') {
                if (frontIsPoint) {
                    return 0L;
                }
                frontIsPoint = true;
                if (TCount >= 3) {
                    return 0L;
                }
                if (sum > (long)nMax[TCount]) {
                    return 0L;
                }
                result += sum * (long)T[TCount++];
                sum = 0L;
                continue;
            }
            if (ch[i] == ' ') continue;
            return 0L;
        }
        if (frontIsPoint) {
            return 0L;
        }
        if (TCount != 3) {
            return 0L;
        }
        if (sum > (long)nMax[TCount]) {
            return 0L;
        }
        return result + sum;
    }

    public static int[] ipToArray(long ip) {
        int[] array = new int[]{(int)(ip >> 24 & 0xFFL), (int)(ip >> 16 & 0xFFL), (int)(ip >> 8 & 0xFFL), (int)(ip & 0xFFL)};
        return array;
    }

    public static boolean isValidSubMask(String strMask) {
        if (strMask == null) {
            return false;
        }
        String[] sSplit = strMask.split("\\.");
        int length = sSplit.length;
        int iActor = 1;
        boolean bStart = false;
        if (length != 4) {
            return false;
        }
        if (sSplit[0].trim().length() == 0 || sSplit[1].trim().length() == 0 || sSplit[2].trim().length() == 0 || sSplit[3].trim().length() == 0) {
            return false;
        }
        for (int i = 0; i < 32; ++i) {
            if ((IPAddressUtil.convertIPStrToInt(strMask) & iActor) != 0) {
                if (!bStart) {
                    bStart = true;
                }
            } else if (bStart) {
                return false;
            }
            iActor <<= 1;
        }
        return true;
    }

    public static int convertIPStrToInt(String strIP) {
        int iIP = 0;
        StringTokenizer st = new StringTokenizer(strIP, ".");
        int iCount = st.countTokens();
        for (int i = 0; i < iCount; ++i) {
            String s = st.nextToken().trim();
            iIP |= Integer.parseInt(s);
            if (i == iCount - 1) break;
            iIP <<= 8;
        }
        return iIP;
    }

    public static String convertIPIntToStr(int ip) {
        int[] oMask = new int[]{-16777216, 0xFF0000, 65280, 255};
        StringBuffer szIP = new StringBuffer();
        for (int i = 0; i < 4; ++i) {
            int iTmp = ip & oMask[i];
            szIP.append(iTmp >>>= 8 * (3 - i));
            if (i == 3) break;
            szIP.append(".");
        }
        return szIP.toString();
    }

    public static String convertIPLongToStr(long ip) {
        long ip1 = ip >> 24 & 0xFFL;
        long ip2 = ip >> 16 & 0xFFL;
        long ip3 = ip >> 8 & 0xFFL;
        long ip4 = ip & 0xFFL;
        return "" + ip1 + "." + ip2 + "." + ip3 + "." + ip4;
    }

    public static String convertIPPrototypeToStr(String ip) {
        if (ip.length() >= 8) {
            long ip1 = Long.parseLong(ip.substring(0, 2), 16);
            long ip2 = Long.parseLong(ip.substring(2, 4), 16);
            long ip3 = Long.parseLong(ip.substring(4, 6), 16);
            long ip4 = Long.parseLong(ip.substring(6, 8), 16);
            return "" + ip1 + "." + ip2 + "." + ip3 + "." + ip4;
        }
        return ip;
    }

    public static String convertIPStrToPrototype(String ipStr) {
        StringBuilder ip = new StringBuilder("");
        StringTokenizer st = new StringTokenizer(ipStr, ".");
        int iCount = st.countTokens();
        for (int i = 0; i < iCount; ++i) {
            String s = st.nextToken().trim();
            String perIP = "0" + Integer.toHexString(Integer.parseInt(s));
            ip.append(perIP.substring(perIP.length() - 2, perIP.length()));
        }
        return ip.toString();
    }

    public static String calculateStartIP(String strFromIP, String strMask) {
        int iStartIP = IPAddressUtil.convertIPStrToInt(strFromIP);
        int iMask = IPAddressUtil.convertIPStrToInt(strMask);
        return IPAddressUtil.convertIPIntToStr(iStartIP &= iMask);
    }

    public static String calculateEndIP(String strFromIP, String strMask) {
        int iStartIP = IPAddressUtil.convertIPStrToInt(strFromIP);
        int iMask = IPAddressUtil.convertIPStrToInt(strMask);
        int iEndIP = iStartIP & iMask | ~iMask;
        return IPAddressUtil.convertIPIntToStr(iEndIP);
    }

    public static boolean verifyIPSeg(String strFromIP, String strToIP, String strMask) {
        int iStartIP = IPAddressUtil.convertIPStrToInt(strFromIP);
        int iEndIP = IPAddressUtil.convertIPStrToInt(strToIP);
        int iMask = IPAddressUtil.convertIPStrToInt(strMask);
        return (iStartIP & iMask) == (iEndIP & iMask);
    }

    public static String convertIPAddress(String ips) {
        StringTokenizer st = new StringTokenizer(ips, ".");
        StringBuffer sb = new StringBuffer();
        while (st.hasMoreTokens()) {
            String str = st.nextToken();
            if (!(str = str.trim()).equals("")) {
                str = String.valueOf(Integer.parseInt(str.trim()));
            }
            sb.append(str);
            sb.append(".");
        }
        return sb.toString().substring(0, sb.toString().length() - 1);
    }

    public static String convertNumToIpaddr(long longparam) {
        String hex = Long.toHexString(longparam);
        String stadandstr = "";
        int add = 8 - hex.length();
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < add; ++i) {
            str.append(0);
        }
        str.append(hex);
        stadandstr = str.toString();
        StringBuffer restr = new StringBuffer();
        int first = 0;
        for (int j = 0; j < 4; ++j) {
            int num = Integer.parseInt(stadandstr.substring(first, first + 2), 16);
            first += 2;
            restr.append(num).append('.');
        }
        return restr.substring(0, restr.length() - 1);
    }
}

