/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.util.command;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TESMsgUtil {
    public static final String BLOCK_INDICATOR = "block";

    public static List<RowParams> getParamRows(BussinessParams bp, String blockID) {
        if (bp == null || blockID == null) {
            return null;
        }
        ArrayList<RowParams> rows = new ArrayList<RowParams>();
        boolean eligable = false;
        int rowlen = bp.getRowParamsCount();
        for (int i = 0; i < rowlen; ++i) {
            RowParams row = bp.getRowParams(i);
            if (row.getParamCount() <= 0) continue;
            Param param = row.getParam(0);
            if (eligable) {
                if (BLOCK_INDICATOR.equals(param.getName())) {
                    break;
                }
            } else if (BLOCK_INDICATOR.equals(param.getName()) && blockID.equals(param.getValue())) {
                eligable = true;
            }
            if (!eligable) continue;
            rows.add(row);
        }
        return rows;
    }

    public static void setTmpID(RowParams row, int indicator, int pos, long tmpValue, Map<String, String> mapping) {
        Param param = row.getParam(pos);
        if (Integer.parseInt(param.getValue().trim()) == indicator) {
            String value = Long.toString(tmpValue);
            param = row.getParam(pos + 1);
            param.setValue(value);
            if (mapping != null) {
                mapping.put(param.getValue().trim(), value);
            }
        }
    }

    public static void setTmpID(RowParams row, int indicator, String paramname, long tmpValue, Map<String, String> mapping) {
        String value = Long.toString(tmpValue);
        Param param = row.getParam(paramname);
        if (mapping != null) {
            mapping.put(param.getValue().trim(), value);
        }
        param.setValue(value);
    }

    public static Operation createOperation(RowParams row, int neID, String qxID) {
        Operation oper = TECreateObjectFactory.getOperation(neID, qxID);
        Input input = oper.getInput();
        int size = input.getPartCount();
        for (int i = 0; i < size; ++i) {
            Part part = input.getPart(i);
            Param param = row.getParam(part.getName());
            if (param == null || param.getValue() == null || param.getValue().equals("-")) {
                return null;
            }
            part.setValue(param.getValue());
        }
        return oper;
    }

    public static List<Operation> createOperation(List<RowParams> rows, int neID, String qxID) {
        ArrayList<Operation> opers = new ArrayList<Operation>();
        if (rows == null) {
            return opers;
        }
        int size = rows.size();
        for (int i = 0; i < size; ++i) {
            RowParams row = rows.get(i);
            Operation oper = TESMsgUtil.createOperation(row, neID, qxID);
            opers.add(oper);
        }
        return opers;
    }

    public static RowParams getRowParams(Datainterface inputData, String blockID, int rowIndex) {
        BussinessParams businessparams = inputData.getBussinessParams();
        List<RowParams> rows = TESMsgUtil.getParamRows(businessparams, blockID);
        if (rows.size() <= 0 || rowIndex >= rows.size()) {
            return null;
        }
        return rows.get(rowIndex);
    }
}

