/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.util.cache;

import com.huawei.nglct.cbb.log.TELogFactory;
import java.util.List;
import org.slf4j.Logger;

public class TETimeStatMgr {
    public static int FLAG_LOG = 1;
    public static int FLAG_NO_LOG = 0;
    private int logFlag;
    private String tipPrefix;
    private long beginTime;

    public TETimeStatMgr(int logflag) {
        this.logFlag = logflag;
    }

    public void startStat(String tip) {
        this.tipPrefix = tip;
        this.beginTime = System.nanoTime();
    }

    public void stopStat() {
        this.stopStat(TELogFactory.getNormalLogger());
    }

    public void stopStat(Logger logger) {
        double usedTime = System.nanoTime() - this.beginTime;
        if (FLAG_LOG == this.logFlag) {
            logger.info(this.tipPrefix + ": " + usedTime + "ns");
        }
    }

    public void stopStat(List<Logger> loggerList) {
        double usedTime = System.nanoTime() - this.beginTime;
        for (Logger logger : loggerList) {
            if (FLAG_LOG != this.logFlag) continue;
            logger.info(this.tipPrefix + ": " + usedTime + "ns");
        }
    }

    public static void main(String[] args) {
        TETimeStatMgr timer = new TETimeStatMgr(FLAG_LOG);
        timer.startStat("test");
        timer.stopStat();
    }
}

