/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.util.cache;

import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEPort;
import com.huawei.nglct.util.cache.TECache;
import gnu.trove.TIntObjectHashMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TEPortCache
implements TECache {
    private Map<SlotKey, TIntObjectHashMap<TEPort>> neSlotPortMap = new HashMap<SlotKey, TIntObjectHashMap<TEPort>>();

    public TEPort getPort(int neID, int slotID, int relativePortID, int boardType) {
        TEPort port = null;
        SlotKey slotKey = new SlotKey(neID, slotID);
        TIntObjectHashMap portMap = this.neSlotPortMap.get(slotKey);
        if (null == portMap) {
            portMap = new TIntObjectHashMap();
            this.neSlotPortMap.put(slotKey, (TIntObjectHashMap<TEPort>)portMap);
        }
        if (null == (port = (TEPort)portMap.get(relativePortID)) && null != (port = TEConfigurationDataMgr.getInstance().getPortOnInter(neID, slotID, boardType, relativePortID))) {
            portMap.put(relativePortID, (Object)port);
        }
        return port;
    }

    public List<TEPort> getPortList(int neID, int slotID, int boardType) {
        List<TEPort> portList = TEConfigurationDataMgr.getInstance().getPortListOnInter(neID, slotID, boardType);
        SlotKey slotKey = new SlotKey(neID, slotID);
        TIntObjectHashMap portMap = this.neSlotPortMap.get(slotKey);
        if (null == portMap) {
            portMap = new TIntObjectHashMap();
            this.neSlotPortMap.put(slotKey, (TIntObjectHashMap<TEPort>)portMap);
        }
        int relativePortID = -1;
        for (TEPort port : portList) {
            relativePortID = TEConfigurationDataMgr.getPortDomainType(port.getPortNo());
            portMap.put(relativePortID, (Object)port);
        }
        return portList;
    }

    @Override
    public void clear() {
    }

    public class SlotKey {
        public int neID;
        public int slotID;

        public SlotKey(int neID, int slotID) {
            this.neID = neID;
            this.slotID = slotID;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + this.neID;
            result = 31 * result + this.slotID;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof SlotKey)) {
                return false;
            }
            SlotKey other = (SlotKey)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.neID != other.neID) {
                return false;
            }
            return this.slotID == other.slotID;
        }

        private TEPortCache getOuterType() {
            return TEPortCache.this;
        }
    }
}

