/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.util.cache;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.po.embeddednemgrmo.TENEMOPO;
import com.huawei.nglct.util.cache.TECache;
import gnu.trove.TIntObjectHashMap;
import org.slf4j.Logger;

public class TENECache
implements TECache {
    private static Logger embededWnemgrlog = TELogFactory.getembededWnemgrLogger();
    private TIntObjectHashMap<TENEMOPO> neMap = new TIntObjectHashMap();

    public TENEMOPO getNECache(int neID) {
        TENE ne;
        TENEMOPO nemo = (TENEMOPO)this.neMap.get(neID);
        if (null == nemo && null != (ne = TENEListMgr.getInstance().getNE(neID)) && null != (nemo = TENECache.getTENEPO(neID))) {
            this.neMap.put(neID, (Object)nemo);
        }
        return nemo;
    }

    private static TENEMOPO getTENEPO(int neID) {
        TENEMOPO ne = null;
        TEDaoOperationResult drb = null;
        try {
            TENE cacheNE = TENEListMgr.getInstance().getNE(neID);
            if (null == cacheNE) {
                TELogFactory.getNormalLogger().error("The ne is not exist! neID->" + neID);
                return ne;
            }
            drb = cacheNE.isDataCfgStausNeedLock() ? TECommonDaoService.findNE(new int[]{neID}) : TECommonDaoService.findNE_NonLock(new int[]{neID});
            ne = (TENEMOPO)drb.getData().get(0);
            int result = drb.getResult();
            if (0 != result) {
                embededWnemgrlog.error("Get TENEMOPO fail! result is: " + result);
                embededWnemgrlog.error(TENECache.getTENEMOPOMessage(ne));
            }
            return ne;
        }
        catch (Exception e1) {
            embededWnemgrlog.error("Get TENEMOPO fail: " + e1);
            return null;
        }
    }

    private static String getTENEMOPOMessage(TENEMOPO ne) {
        StringBuffer sb = new StringBuffer();
        if (null == ne) {
            sb.append("The ne is null!");
        } else {
            sb.append("getCid is: ").append(ne.getCid()).append("\n");
            sb.append("getOid is: ").append(ne.getOid()).append("\n");
            sb.append("getName is: ").append(ne.getName()).append("\n");
            sb.append("getMemo is: ").append(ne.getMemo()).append("\n");
            sb.append("getType is: ").append(ne.getType()).append("\n");
            sb.append("getUserLabel is: ").append(ne.getUserLabel()).append("\n");
            sb.append("getOwner is: ").append(ne.getOwner()).append("\n");
            sb.append("getNEID is: ").append(ne.getNEID()).append("\n");
            sb.append("getPhyID is: ").append(ne.getPhyID()).append("\n");
            sb.append("getVersion is: ").append(ne.getVersion()).append("\n");
            sb.append("getAutoSync is: ").append(ne.getAutoSync()).append("\n");
            sb.append("getSyncNumber is: ").append(ne.getSyncNumber()).append("\n");
            sb.append("getEnableIntelligence is: ").append(ne.getEnableIntelligence()).append("\n");
            sb.append("getPreConfig is: ").append(ne.getPreConfig()).append("\n");
            sb.append("getConfigState is: ").append(ne.getConfigState()).append("\n");
            sb.append("getLastDBCHGSEQ is: ").append(ne.getLastDBCHGSEQ()).append("\n");
            sb.append("getLastSyncTime is: ").append(ne.getLastSyncTime()).append("\n");
            sb.append("getBuildTime is: ").append(ne.getBuildTime()).append("\n");
            sb.append("getPfmMonitor15m is: ").append(ne.getPfmMonitor15m()).append("\n");
            sb.append("getPfmMonNeverStop15m is: ").append(ne.getPfmMonNeverStop15m()).append("\n");
            sb.append("getPfmMonitor24h is: ").append(ne.getPfmMonitor24h()).append("\n");
            sb.append("getPfmMonNeverStop24h is: ").append(ne.getPfmMonNeverStop24h()).append("\n");
            sb.append("getPfmMonStartTime24h is: ").append(ne.getPfmMonStartTime24h()).append("\n");
            sb.append("getPfmMonEndTime24h is: ").append(ne.getPfmMonEndTime24h()).append("\n");
            sb.append("getNE_ATTRIB_TimeDivision is: ").append(ne.getNE_ATTRIB_TimeDivision()).append("\n");
            sb.append("getShelfType is: ").append(ne.getShelfType()).append("\n");
            sb.append("getSCBMode is: ").append(ne.getSCBMode()).append("\n");
            sb.append("getVRCBVer is: ").append(ne.getVRCBVer()).append("\n");
            sb.append("getPatchVerList is: ").append(ne.getPatchVerList()).append("\n");
            sb.append("getCodeSet is: ").append(ne.getCodeSet()).append("\n");
            sb.append("getRackType is: ").append(ne.getRackType()).append("\n");
        }
        return sb.toString();
    }

    public String getName(int neID) {
        String neName = null;
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        if (null != ne) {
            neName = ne.getNEName();
        }
        return neName;
    }

    public long getNEVersion(int neID) {
        long neVersion = -1L;
        TENEMOPO nemo = this.getNECache(neID);
        if (null != nemo) {
            neVersion = nemo.getVersion();
        }
        return neVersion;
    }

    @Override
    public void clear() {
    }
}

