/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.util.buffer;

import com.huawei.nglct.util.buffer.RefreshTimeBufferIF;
import com.huawei.nglct.util.buffer.TETimeBuffer;
import com.huawei.nglct.util.buffer.TEUnknowmKeyTypeException;
import com.huawei.nglct.util.buffer.TimesData;
import com.huawei.nglct.util.buffer.UnkownRefresherException;
import java.util.Set;

public class TETimeBufferByLoadTimes<K, VA> {
    private TETimeBuffer<K, TimesData<VA>> buffer = new TETimeBuffer();
    private int bufferCapacity = 1000;

    public int getBufferCapacity() {
        return this.bufferCapacity;
    }

    public void setBufferCapacity(int bufferCapacity) {
        this.bufferCapacity = bufferCapacity;
    }

    public void setPeriodTime(long periodTime) {
        this.buffer.setPeriodTime(periodTime);
    }

    public int size() {
        return this.buffer.size();
    }

    public boolean containsKey(K key) {
        return this.buffer.containsKey(key);
    }

    public Set<K> keySet() {
        return this.buffer.keySet();
    }

    public void remove(K key) {
        this.buffer.remove(key);
    }

    public synchronized void put(K key, VA value) throws TEUnknowmKeyTypeException, UnkownRefresherException {
        if (this.containsKey(key)) {
            this.buffer.get(key).timesAddUp();
        } else {
            if (this.size() > this.bufferCapacity) {
                return;
            }
            this.buffer.put(key, new TimesData<VA>(value));
        }
    }

    public synchronized VA get(K key) throws TEUnknowmKeyTypeException, UnkownRefresherException {
        if (!this.buffer.containsKey(key)) {
            return null;
        }
        TimesData<VA> tData = this.buffer.get(key);
        if (tData != null) {
            return (VA)tData.data;
        }
        return null;
    }

    public synchronized void setRefreshTimeBuffer(final RefreshTimeBufferIF refresher) {
        this.buffer.setRefreshTimeBuffer(new RefreshTimeBufferIF(){

            @Override
            public Object refreshTimeBuffer(Object key) throws TEUnknowmKeyTypeException {
                Object obj = refresher.refreshTimeBuffer(key);
                if (obj == null) {
                    return obj;
                }
                return new TimesData<Object>(obj);
            }
        });
    }

    public synchronized void clearData(K key) {
        if (!this.buffer.containsKey(key)) {
            return;
        }
        TimesData<VA> timesData = this.buffer.getDataNotRefresh(key);
        if (timesData.isLastTimes()) {
            this.buffer.remove(key);
        } else {
            timesData.reduceTimes();
        }
    }
}

