/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.util.buffer;

import com.huawei.nglct.util.buffer.RefreshTimeBufferIF;
import com.huawei.nglct.util.buffer.TEUnknowmKeyTypeException;
import com.huawei.nglct.util.buffer.TimeData;
import com.huawei.nglct.util.buffer.UnkownRefresherException;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class TETimeBuffer<K, V>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long periodTime = 3000L;
    private int BUFFER_LIMIT = 500;
    private Map<K, TimeData<V>> data = new ConcurrentHashMap<K, TimeData<V>>();
    private RefreshTimeBufferIF dataRefresher;

    public TETimeBuffer(int size) {
        this.BUFFER_LIMIT = size;
    }

    public TETimeBuffer() {
    }

    public void setPeriodTime(long periodTime) {
        this.periodTime = periodTime;
    }

    public int size() {
        return this.data.size();
    }

    public boolean containsKey(K key) {
        return this.data.containsKey(key);
    }

    public Set<K> keySet() {
        return this.data.keySet();
    }

    public synchronized void setBufferLimit(int size) {
        this.BUFFER_LIMIT = size;
    }

    public synchronized void put(K key, V value) {
        TimeData tData = new TimeData();
        tData.data = value;
        tData.time = System.currentTimeMillis();
        if (this.data.size() >= this.BUFFER_LIMIT) {
            this.removeOldestData();
        }
        this.data.put(key, tData);
    }

    public void remove(K key) {
        if (this.data.containsKey(key)) {
            this.data.remove(key);
        }
    }

    public void removeOldestData() {
        TimeData<V> tempValue = null;
        Object tempKey = null;
        for (Map.Entry<K, TimeData<V>> entry : this.data.entrySet()) {
            K key = entry.getKey();
            TimeData<V> value = entry.getValue();
            if (tempKey == null) {
                tempKey = key;
                tempValue = value;
                continue;
            }
            if (!value.isOlder(tempValue)) continue;
            tempValue = value;
            tempKey = key;
        }
        this.data.remove(tempKey);
    }

    public synchronized V getDataNotRefresh(K key) {
        TimeData<V> timeData = this.data.get(key);
        if (timeData != null) {
            return (V)timeData.data;
        }
        return null;
    }

    public synchronized V get(K key) throws TEUnknowmKeyTypeException, UnkownRefresherException {
        if (!this.data.containsKey(key)) {
            if (this.dataRefresher != null) {
                Object tdata = this.dataRefresher.refreshTimeBuffer(key);
                this.put(key, tdata);
                return (V)tdata;
            }
            throw new UnkownRefresherException("The buffer's RefreshTimeBufferIF is null!");
        }
        TimeData<V> timeData = this.data.get(key);
        if (this.isOutOfDateData(timeData) && this.dataRefresher != null) {
            Object obj = this.dataRefresher.refreshTimeBuffer(key);
            if (obj == null) {
                this.data.remove(key);
            } else {
                timeData.data = obj;
                timeData.time = System.currentTimeMillis();
            }
        }
        return (V)timeData.data;
    }

    private boolean isOutOfDateData(TimeData<V> timeData) {
        return System.currentTimeMillis() - timeData.time > this.periodTime;
    }

    public synchronized void setRefreshTimeBuffer(RefreshTimeBufferIF refresher) {
        this.dataRefresher = refresher;
    }

    public synchronized void refreshTimeBuffer(K key) throws TEUnknowmKeyTypeException, UnkownRefresherException {
        if (this.dataRefresher == null) {
            throw new UnkownRefresherException("The buffer's RefreshTimeBufferIF is null!");
        }
        Object tdata = this.dataRefresher.refreshTimeBuffer(key);
        this.put(key, tdata);
    }

    public String toString() {
        return this.data.toString();
    }
}

