/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.tl1.nemanager;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEFunBlockProperty;
import com.huawei.nglct.nelist.model.circuitpack.TEPortProperty;
import com.huawei.nglct.nelist.model.circuitpack.TESDCircuitPackRecord;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.tl1.TEAIDAndTypeList;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.tl1.TETL1NECommMgr;
import com.huawei.uflight.tl1.tl1operation.InMsg;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import org.slf4j.Logger;

public final class TETL1QueryLogicPort {
    private static final int TEVC4LEVEL = 4;

    public static void queryExistLogicPort(int neId, int slotId, int boardType) {
        TL1Definitions definitions = null;
        Logger log = TELogFactory.getNormalLogger();
        TL1Operation oper = null;
        TEConfigurationDataMgr mgr = TEConfigurationDataMgr.getInstance();
        try {
            definitions = TECreateObjectFactory.parseTL1DesFile(neId);
            oper = definitions.getTL1Operation("RTRV-EQPT");
            ArrayList<Object> operationList = new ArrayList<Object>();
            InMsg input = oper.getInMsg();
            Part part = input.getPart("AID");
            String shelfSlotID = TETL1CommonUtil.slotIDNMToNEShelfIDSlotID(neId, slotId);
            part.setValue("SLOT-" + shelfSlotID + "-ALL");
            operationList.add(oper.clone());
            int result = TETL1NECommMgr.getInstance().sendCommand((int)neId, operationList, (int)40).retCode;
            if (result != 0) {
                TELogFactory.getNormalLogger().info("query logic port fail,the errorCode is " + result);
                return;
            }
            int m = operationList.size();
            for (int k = 0; k < m; ++k) {
                TL1Operation tempTL1Operation = (TL1Operation)operationList.get(k);
                int n = tempTL1Operation.getOutMsgCount();
                for (int l = 0; l < n; ++l) {
                    String[] str;
                    Part AID2;
                    OutMsg output = tempTL1Operation.getOutMsg(l);
                    if (0 != output.getFault().getCompletionCode()) continue;
                    HashMap hm = TETL1CommonUtil.getOutMsgPart(output);
                    Part provType = (Part)hm.get("PROVTYPE");
                    if (provType != null && provType.getValue() != null) {
                        AID2 = (Part)hm.get("slotID");
                        str = TETL1CommonUtil.parseAID(AID2.getValue(), neId);
                        mgr.setNEType(1);
                        mgr.addLogicPort(neId, slotId, Integer.parseInt(str[3]));
                        continue;
                    }
                    AID2 = (Part)hm.get("slotID");
                    str = TETL1CommonUtil.parseAID(AID2.getValue(), neId);
                    mgr.setNEType(1);
                    mgr.deletLogicPort(neId, slotId, Integer.parseInt(str[3]));
                }
            }
        }
        catch (Exception e) {
            log.error("Parse TL1 description file fail!", (Throwable)e);
            return;
        }
    }

    public static void queryExistLogicPort1(int neId, int slotId, int boardType) {
        TL1Definitions definitions = null;
        Logger log = TELogFactory.getNormalLogger();
        TL1Operation oper = null;
        TEConfigurationDataMgr mgr = TEConfigurationDataMgr.getInstance();
        TESDCircuitPackRecord boardProperty = mgr.getBoardTypeProperty(neId, boardType);
        ArrayList portPropertyList = boardProperty.getDynPropertyList();
        try {
            int i;
            definitions = TECreateObjectFactory.parseTL1DesFile(neId);
            oper = definitions.getTL1Operation("RTRV-EQPT");
            HashSet set = new HashSet();
            ArrayList phyList = null;
            int m = portPropertyList.size();
            for (i = 0; i < m; ++i) {
                TEPortProperty portProperty = (TEPortProperty)portPropertyList.get(i);
                phyList = portProperty.getPortNoList();
                set.addAll(phyList);
            }
            if (set.size() > 0) {
                phyList = new ArrayList();
                phyList.addAll(set);
                Collections.sort(phyList);
                if (null == oper) {
                    if (mgr.getLogicPortList(neId, slotId).size() <= 0) {
                        m = phyList.size();
                        for (i = 0; i < m; ++i) {
                            int portId = (Integer)phyList.get(i);
                            mgr.addLogicPort(neId, slotId, portId);
                        }
                    }
                    return;
                }
                ArrayList<Object> operationList = new ArrayList<Object>();
                int n = phyList.size();
                for (int j = 0; j < n; ++j) {
                    int portId = (Integer)phyList.get(j);
                    InMsg input = oper.getInMsg();
                    Part part = input.getPart("AID");
                    String shelfSlotID = TETL1CommonUtil.slotIDNMToNEShelfIDSlotID(neId, slotId);
                    part.setValue("SLOT-" + shelfSlotID + "-" + portId);
                    operationList.add(oper.clone());
                }
                if (operationList.size() == 0) {
                    return;
                }
                int result = TENECommMgr.getInstance().sendCommand((int)neId, operationList, (int)20).retCode;
                if (result != 0) {
                    TELogFactory.getNormalLogger().info("query logic port fail,the errorCode is " + result);
                    return;
                }
                int m2 = operationList.size();
                for (int k = 0; k < m2; ++k) {
                    OutMsg output = ((TL1Operation)operationList.get(k)).getOutMsg(0);
                    if (0 != output.getFault().getCompletionCode()) continue;
                    HashMap hm = TETL1CommonUtil.getOutMsgPart(output);
                    Part AID2 = (Part)hm.get("slotID");
                    String[] str = TETL1CommonUtil.parseAID(AID2.getValue(), neId);
                    mgr.addLogicPort(neId, slotId, Integer.parseInt(str[3]));
                }
            }
        }
        catch (Exception e) {
            log.error("Parse TL1 description file fail!", (Throwable)e);
            return;
        }
    }

    public static void queryLogicPort(int neId, int slotId, int boardType) {
        if (!TEConfigurationDataMgr.getInstance().isDynPortBoardType(neId, boardType)) {
            return;
        }
        TL1Definitions definitions = null;
        Logger log = TELogFactory.getNormalLogger();
        TL1Operation oper = null;
        TESDCircuitPackRecord boardProperty = TEConfigurationDataMgr.getInstance().getBoardTypeProperty(neId, boardType);
        ArrayList PortPropertyList = boardProperty.getPortPropertyList();
        try {
            definitions = TECreateObjectFactory.parseTL1DesFile(neId);
            oper = definitions.getTL1Operation("RTRV-EQPT");
        }
        catch (Exception e) {
            log.error("Parse Qx description file fail!", (Throwable)e);
            return;
        }
        int size = PortPropertyList.size();
        for (int i = 0; i < size; ++i) {
            TEPortProperty PortProperty = (TEPortProperty)PortPropertyList.get(i);
            ArrayList PhyList = PortProperty.getPortNoList();
            int len = PhyList.size();
            for (int j = 0; j < len; ++j) {
                ArrayList<Object> OperationList = new ArrayList<Object>();
                int portId = (Integer)PhyList.get(j);
                InMsg input = oper.getInMsg();
                Part part = input.getPart("AID");
                String shelfSlotID = TETL1CommonUtil.slotIDNMToNEShelfIDSlotID(neId, slotId);
                part.setValue("SLOT-" + shelfSlotID + "-" + portId);
                OperationList.add(oper.clone());
                int resualt = TETL1NECommMgr.getInstance().sendCommand((int)neId, OperationList, (int)10).retCode;
                if (resualt != 0) {
                    TELogFactory.getNormalLogger().info("query logic port fail,the errorCode is " + resualt);
                    return;
                }
                OutMsg output = ((TL1Operation)OperationList.get(0)).getOutMsg(0);
                if (0 != output.getFault().getCompletionCode()) continue;
                TEConfigurationDataMgr.getInstance().addLogicPort(neId, slotId, portId);
            }
        }
    }

    public static ArrayList getLogicPortList(int neId, int slotId, int boardType) {
        return TETL1QueryLogicPort.getLogicPortList(neId, slotId, boardType, false);
    }

    public static ArrayList getLogicPortList(int neId, int slotId, int boardType, boolean isSdhPort) {
        ArrayList<Object> logicPortList = new ArrayList<Object>();
        TESDCircuitPackRecord boardProperty = TEConfigurationDataMgr.getInstance().getBoardTypeProperty(neId, boardType);
        ArrayList PortPropertyList = boardProperty.getPortPropertyList();
        if (!TEConfigurationDataMgr.getInstance().isDynPortBoardType(neId, boardType)) {
            int size = PortPropertyList.size();
            for (int i = 0; i < size; ++i) {
                TEPortProperty PortProperty = (TEPortProperty)PortPropertyList.get(i);
                ArrayList PhyList = PortProperty.getPortNoList();
                if (isSdhPort) {
                    int j;
                    ArrayList FBList = PortProperty.getFunBlockPropertyList();
                    String Vc4ListStr = "";
                    int len = FBList.size();
                    for (j = 0; j < len; ++j) {
                        TEFunBlockProperty tempFB = (TEFunBlockProperty)FBList.get(j);
                        if (4 != tempFB.getFuctionBlockType()) continue;
                        ArrayList Vc4List = tempFB.getFunctionBlockNoList();
                        Vc4ListStr = String.valueOf(Vc4List.size());
                        break;
                    }
                    if ("".equals(Vc4ListStr)) continue;
                    len = PhyList.size();
                    for (j = 0; j < len; ++j) {
                        String portId = String.valueOf(PhyList.get(j)) + "-" + Vc4ListStr;
                        logicPortList.add(portId);
                    }
                    continue;
                }
                int len = PhyList.size();
                for (int j = 0; j < len; ++j) {
                    Integer portId = new Integer(String.valueOf(PhyList.get(j)));
                    logicPortList.add(portId);
                }
            }
        } else {
            TL1Definitions definitions = null;
            Logger log = TELogFactory.getNormalLogger();
            TL1Operation oper = null;
            try {
                definitions = TECreateObjectFactory.parseTL1DesFile(neId);
                oper = definitions.getTL1Operation("RTRV-EQPT");
            }
            catch (Exception e) {
                log.error("Parse Qx description file fail!", (Throwable)e);
                return logicPortList;
            }
            int size = PortPropertyList.size();
            for (int i = 0; i < size; ++i) {
                TEPortProperty PortProperty = (TEPortProperty)PortPropertyList.get(i);
                ArrayList PhyList = PortProperty.getPortNoList();
                String Vc4ListStr = "";
                if (isSdhPort) {
                    ArrayList FBList = PortProperty.getFunBlockPropertyList();
                    int len = FBList.size();
                    for (int j = 0; j < len; ++j) {
                        TEFunBlockProperty tempFB = (TEFunBlockProperty)FBList.get(j);
                        if (4 != tempFB.getFuctionBlockType()) continue;
                        ArrayList Vc4List = tempFB.getFunctionBlockNoList();
                        Vc4ListStr = String.valueOf(Vc4List.size());
                        break;
                    }
                    if ("".equals(Vc4ListStr)) continue;
                }
                int len = PhyList.size();
                for (int j = 0; j < len; ++j) {
                    int portId = (Integer)PhyList.get(j);
                    ArrayList<Object> OperationList = new ArrayList<Object>();
                    InMsg input = oper.getInMsg();
                    Part part = input.getPart("AID");
                    String shelfSlotID = TETL1CommonUtil.slotIDNMToNEShelfIDSlotID(neId, slotId);
                    part.setValue("SLOT-" + shelfSlotID + "-" + portId);
                    OperationList.add(oper.clone());
                    int resualt = TETL1NECommMgr.getInstance().sendCommand((int)neId, OperationList, (int)10).retCode;
                    if (resualt != 0) {
                        TELogFactory.getNormalLogger().info("query logic port fail,the errorCode is " + resualt);
                        return new ArrayList();
                    }
                    int FaultCodt = 1090650120;
                    OutMsg output = ((TL1Operation)OperationList.get(0)).getOutMsg(0);
                    if (0 != output.getFault().getCompletionCode() || FaultCodt != 0) continue;
                    if (isSdhPort) {
                        String portIdStr = String.valueOf(PhyList.get(j)) + "-" + Vc4ListStr;
                        logicPortList.add(portIdStr);
                        continue;
                    }
                    logicPortList.add(portId);
                    TEConfigurationDataMgr.getInstance().addLogicPort(neId, slotId, portId);
                }
            }
        }
        return logicPortList;
    }

    public static ArrayList getLogicPortList(int neId, int slotId) {
        int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neId, slotId);
        return TETL1QueryLogicPort.getLogicPortList(neId, slotId, boardType);
    }

    public static void queryRealMod2(int neId, int slotId) {
        int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neId, slotId);
        if (boardType == 1573 && TESysManagerConstants.SYS_SINGLE_STATUS == TESysManagerBean.getInstance().getSysStauts()) {
            HashSet<Integer> slotIDSet = new HashSet<Integer>();
            slotIDSet.add(slotId);
            TEAIDAndTypeList aidTypeList = TETL1CommonUtil.queryPortType(neId, slotIDSet);
            TEConfigurationDataMgr.getInstance().addTL1PayloadTypeList(neId, slotId, aidTypeList);
        }
    }
}

