/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.tl1.nemanager;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TEParseXMLFile;
import com.huawei.nglct.tl1.nemanager.TETL1PfmBsEvent;
import com.huawei.nglct.util.xml.TEResourceManager;
import java.io.File;
import java.util.HashMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TETL1PfmEventsDataLoader {
    private static final String TL1_PFM_BASEEVENT_DATAS_FILE = "pfmbaseeventdatas_TL1";
    private static final String TL1_PFM_MARINE_BASEEVENT_DATAS_FILE = "pfmbaseeventdatas_TL1_MARINE";
    private static HashMap eventMap = new HashMap();
    private static TETL1PfmEventsDataLoader instance = null;

    public static synchronized TETL1PfmEventsDataLoader getInstance() {
        if (null == instance) {
            instance = new TETL1PfmEventsDataLoader();
        }
        return instance;
    }

    private TETL1PfmEventsDataLoader() {
        if (eventMap.isEmpty()) {
            this.loadStaticPfmBaseEventDatas(-1);
        }
    }

    public TETL1PfmBsEvent getTL1PfmBsEvent(int neid, int eventID) {
        if (eventMap.isEmpty()) {
            this.loadStaticPfmBaseEventDatas(neid);
        }
        return (TETL1PfmBsEvent)eventMap.get(eventID);
    }

    void loadStaticPfmBaseEventDatas(int neid) {
        this.parseXML(neid, TL1_PFM_BASEEVENT_DATAS_FILE);
        this.parseXML(neid, TL1_PFM_MARINE_BASEEVENT_DATAS_FILE);
    }

    void parseXML(int neid, String fileName) {
        Document doc = null;
        try {
            doc = this.getPfmXMLDoc(neid, fileName);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error(e.toString(), (Throwable)e);
            return;
        }
        NodeList children = doc.getElementsByTagName("param");
        int size = children.getLength();
        for (int i = 0; i < size; ++i) {
            Element element = (Element)children.item(i);
            TETL1PfmBsEvent event = new TETL1PfmBsEvent();
            event.setEventID(Integer.parseInt(element.getAttribute("eventID")));
            event.setEventName(element.getAttribute("eventName"));
            event.setFbType(Integer.parseInt(element.getAttribute("fbType")));
            event.setEventType(Integer.parseInt(element.getAttribute("eventType")));
            event.setValueType(Integer.parseInt(element.getAttribute("valueType")));
            event.setThresholdType(Integer.parseInt(element.getAttribute("thresholdType")));
            event.setLocation(Integer.parseInt(element.getAttribute("location")));
            event.setDirection(Integer.parseInt(element.getAttribute("direction")));
            event.setMinThr15m(Integer.parseInt(element.getAttribute("minThr15m")));
            event.setMaxThr15m(Integer.parseInt(element.getAttribute("maxThr15m")));
            event.setMinThr24h(Integer.parseInt(element.getAttribute("minThr24h")));
            event.setMaxThr24h(Integer.parseInt(element.getAttribute("maxThr24h")));
            event.setDftThr15m(Integer.parseInt(element.getAttribute("dftThr15m")));
            event.setDftThr24h(Integer.parseInt(element.getAttribute("dftThr24h")));
            event.setUnit(Float.parseFloat(element.getAttribute("unit")));
            event.setUnitName(element.getAttribute("unitName"));
            event.setPmParameterName(element.getAttribute("pmParameterName"));
            event.setDescription(element.getAttribute("description"));
            eventMap.put(event.getEventID(), event);
        }
    }

    private Document getPfmXMLDoc(int neid, String fileName) throws Exception {
        StringBuffer filepath = new StringBuffer(TEResourceManager.getPath()).append(File.separator).append("nemgr").append(File.separator).append("tl1necommon").append(File.separator).append("conf").append(File.separator).append(fileName).append(".xml");
        return TEParseXMLFile.parseFile("com.huawei.weblct.tl1necommon", filepath.toString());
    }

    public TETL1PfmBsEvent getTL1PfmBsEvent(int neid, int aidType, String eventName, int location, int direction) {
        if (eventMap.isEmpty()) {
            this.loadStaticPfmBaseEventDatas(neid);
        }
        for (Integer eventID : eventMap.keySet()) {
            TETL1PfmBsEvent event = (TETL1PfmBsEvent)eventMap.get(eventID);
            if (!event.getEventName().equals(eventName) || event.getFbType() != aidType || event.getLocation() != location || event.getDirection() != direction) continue;
            return event;
        }
        return null;
    }

    public static void main(String[] args) {
        TETL1PfmBsEvent event = TETL1PfmEventsDataLoader.getInstance().getTL1PfmBsEvent(1, 1);
        System.out.println(event.toString());
        System.out.println("The first event name is : " + event.getEventName());
    }

    public HashMap getEventMap() {
        return eventMap;
    }

    public static void setEventMap(HashMap eventMap) {
        TETL1PfmEventsDataLoader.eventMap = eventMap;
    }
}

