/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.tl1.nemanager;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.handler.TENEHandlerMgr;
import com.huawei.nglct.security.EncryptUtils;
import com.huawei.nglct.security.TEEncryptForNeListInfo;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.tl1.nemanager.TETL1NE;
import com.huawei.nglct.tl1.nemanager.TETL1NEBuildFactory;
import com.huawei.nglct.tl1.nemanager.TETL1NEStateNoticeReceiver;
import com.huawei.nglct.util.xml.TEResourceManager;
import com.huawei.uflight.qxprotocol.NENMIDHandle;
import com.huawei.uflight.tl1.NEStateNoticeHandle;
import com.huawei.uflight.tl1.TETL1NECommMgr;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Vector;

public class TETL1NEMgr {
    private static TETL1NEMgr instance = null;
    private Vector neList = new Vector();
    private static final int COMM_TCP_TYPE = 1;
    private static final int COMM_TP4_TYPE = 2;
    private static final int COMM_SERIAL_TYPE = 3;
    private static final int COMM_SSL_TYPE = 4;
    private static final int MAX_LOGIN_NUM = 32;
    private Object sendNMIDObject = new Object();
    Thread connThread = new NEConnectionThread();

    private TETL1NEMgr() {
        this.initNE();
        if (TESysManagerConstants.SYS_SINGLE_STATUS == TESysManagerBean.getInstance().getSysStauts()) {
            this.connThread.setName("connThreadOfsysINIT");
            this.connThread.start();
        }
    }

    private void initNE() {
        if (TESysManagerConstants.SYS_SINGLE_STATUS != TESysManagerBean.getInstance().getSysStauts()) {
            return;
        }
        TETL1NE ne = null;
        String neName = "";
        int neID = -1;
        int neGWType = -1;
        String neGWAddress = null;
        String port = null;
        String baudRate = null;
        int neType = -1;
        String neVersion = "";
        String userName = "";
        String userPassword = "";
        String showNEVersion = "";
        ArrayList nelistinfo = TEResourceManager.getNeListInfo(TENEListMgr.NELIST_PATH);
        if (null == nelistinfo || 0 == nelistinfo.size()) {
            TELogFactory.getNormalLogger().info("There is not NE in the system.");
            return;
        }
        HashMap htneinfo = null;
        int size = nelistinfo.size();
        for (int i = 0; i < size; ++i) {
            htneinfo = (HashMap)nelistinfo.get(i);
            if (!htneinfo.containsKey("neConnectType") || "0".equals((String)htneinfo.get("neConnectType"))) continue;
            neID = TENEListUtils.getLogicNEID();
            neName = (String)htneinfo.get("neName");
            TETL1NECommMgr.getInstance().putLogicNEIDName((long)neID, neName);
            neGWType = Integer.parseInt((String)htneinfo.get("neGWType"));
            neGWAddress = (String)htneinfo.get("neGWAddress");
            port = (String)htneinfo.get("port");
            baudRate = (String)htneinfo.get("baudRate");
            neType = Integer.parseInt((String)htneinfo.get("neType"));
            neVersion = (String)htneinfo.get("neVersion");
            userName = (String)htneinfo.get("loginName");
            userPassword = (String)htneinfo.get("loginPassword");
            showNEVersion = (String)htneinfo.get("showNEVersion");
            TEEncryptForNeListInfo des = new TEEncryptForNeListInfo();
            byte[] bytePassword = des.hex2byte(userPassword);
            bytePassword = des.doDecrypt(bytePassword);
            ne = TETL1NEBuildFactory.bulidNE(neType);
            ne.setNEID(neID);
            ne.setNEName(neName);
            ne.setNEGWType(neGWType);
            ne.setNEGWAddress(neGWAddress);
            ne.setPort(port);
            ne.setHostVersion(neVersion);
            ne.setBaudRate(baudRate);
            ne.setNEType(neType);
            ne.setCurUser(userName);
            ne.setCurUserPassword(bytePassword);
            ne.setShowNEVersion(showNEVersion);
            this.neList.add(ne);
            EncryptUtils.clearByte(bytePassword);
        }
    }

    public static synchronized TETL1NEMgr getInstance() {
        if (null == instance) {
            instance = new TETL1NEMgr();
        }
        return instance;
    }

    public Vector getNEList() {
        return this.neList;
    }

    public void setNEList(Vector v) {
        this.neList = v;
    }

    public TETL1NE getNE(String nodeID) {
        TETL1NE ne = null;
        int size = this.neList.size();
        for (int i = 0; i < size; ++i) {
            ne = (TETL1NE)this.neList.get(i);
            if (!nodeID.equals(ne.getNodeID())) continue;
            return ne;
        }
        return null;
    }

    public TETL1NE getNEByNEName(String neName) {
        TETL1NE ne = null;
        int size = this.neList.size();
        for (int i = 0; i < size; ++i) {
            ne = (TETL1NE)this.neList.get(i);
            if (!neName.equals(ne.getNEName())) continue;
            return ne;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addNE(TETL1NE ne, String sbiAddress, String sbiPor) {
        if (this.isAddedNE(ne, sbiAddress, sbiPor)) {
            return 0;
        }
        this.neList.add(ne);
        if (TESysManagerConstants.SYS_SINGLE_STATUS == TESysManagerBean.getInstance().getSysStauts()) {
            TEResourceManager.addNeListInfoNENode(TENEListMgr.NELIST_PATH, ne, false);
        } else {
            int neID = ne.getNEID();
            int neGWType = ne.getNEGWType();
            String baudRate = ne.getBaudRate();
            if (neGWType == 3) {
                TELogFactory.getNormalLogger().info("Begin to connect ne,time:" + System.currentTimeMillis());
                int result = 0;
                result = TETL1NECommMgr.getInstance().createConect((long)neID, new Integer(sbiPor).intValue(), sbiAddress, neGWType, baudRate);
                TELogFactory.getNormalLogger().info("End to connect ne,time:" + System.currentTimeMillis());
                if (result != 0) {
                    TELogFactory.getNormalLogger().debug("Connect NE Fail!");
                    ne.setComStatus(0);
                } else {
                    TELogFactory.getNormalLogger().debug("Connect NE Success!");
                    ne.setComStatus(1);
                }
            } else {
                TELogFactory.getNormalLogger().info("Go to connect ne,time3:" + System.currentTimeMillis());
                Object object = this.sendNMIDObject;
                synchronized (object) {
                    TELogFactory.getNormalLogger().info("Go to connect ne,time4:" + System.currentTimeMillis());
                    TELogFactory.getNormalLogger().info("Begin to connect ne,time: " + System.currentTimeMillis());
                    TELogFactory.getNormalLogger().debug("The SBI address = " + sbiAddress + "  port = " + sbiPor);
                    int result = TETL1NECommMgr.getInstance().createConect((long)neID, new Integer(sbiPor).intValue(), sbiAddress, neGWType);
                    TELogFactory.getNormalLogger().info("End to connect ne,time: " + System.currentTimeMillis());
                    if (result != 0) {
                        TELogFactory.getNormalLogger().debug("Connect NE Fail!");
                        ne.setComStatus(0);
                    } else {
                        TELogFactory.getNormalLogger().debug("Connect NE Success!");
                        ne.setComStatus(1);
                        try {
                            TELogFactory.getNormalLogger().info("wait before: " + System.currentTimeMillis());
                            this.sendNMIDObject.wait(30L);
                            TELogFactory.getNormalLogger().info("wait after: " + System.currentTimeMillis());
                        }
                        catch (InterruptedException ex) {
                            // empty catch block
                        }
                    }
                }
            }
            TETL1NECommMgr.getInstance().registerNEStateListener((long)neID, (NEStateNoticeHandle)new TETL1NEStateNoticeReceiver());
        }
        return 0;
    }

    public int createConnection(int neID, String port, String neGWAddress, int neGWType, String baudRate) {
        return this.createConnection(neID, port, neGWAddress, neGWType, baudRate, "", "");
    }

    public int createConnection(int neID, String port, String neGWAddress, int neGWType, String baudRate, String sbiAddress, String sbiPort) {
        int result = -1;
        TELogFactory.getNormalLogger().info("Begin to connect ne,time:" + System.currentTimeMillis());
        result = null == sbiAddress || "".equals(sbiAddress) || null == sbiPort || "".equals(sbiPort) ? TETL1NECommMgr.getInstance().createConect((long)neID, new Integer(port).intValue(), neGWAddress, neGWType, baudRate) : TETL1NECommMgr.getInstance().createConect((long)neID, new Integer(sbiPort).intValue(), sbiAddress, neGWType, baudRate);
        TELogFactory.getNormalLogger().info("End to connect ne,time:" + System.currentTimeMillis());
        TETL1NECommMgr.getInstance().registerNEStateListener((long)neID, (NEStateNoticeHandle)new TETL1NEStateNoticeReceiver());
        return result;
    }

    public int addNE(TETL1NE ne) {
        return this.addNE(ne, "", "");
    }

    public boolean isAddedNE(TETL1NE ne, String sbiAdd, String sbiPort) {
        TETL1NE tmpNE = null;
        boolean isExist = false;
        int size = this.neList.size();
        for (int i = 0; i < size; ++i) {
            tmpNE = (TETL1NE)this.neList.get(i);
            if (tmpNE.getNEID() != ne.getNEID()) continue;
            isExist = true;
            tmpNE.setNEGWAddress(sbiAdd);
            tmpNE.setPort(sbiPort);
            break;
        }
        return isExist;
    }

    public boolean isAddedNE(int neID) {
        TETL1NE tmpNE = null;
        boolean isExist = false;
        int size = this.neList.size();
        for (int i = 0; i < size; ++i) {
            tmpNE = (TETL1NE)this.neList.get(i);
            if (tmpNE.getNEID() != neID) continue;
            isExist = true;
            break;
        }
        return isExist;
    }

    public boolean isAddedNE(String neName) {
        TETL1NE tmpNE = null;
        boolean isExist = false;
        int size = this.neList.size();
        for (int i = 0; i < size; ++i) {
            tmpNE = (TETL1NE)this.neList.get(i);
            if (!neName.equals(tmpNE.getNEName())) continue;
            isExist = true;
            break;
        }
        return isExist;
    }

    public int getLogicNEID() {
        int size = this.neList.size();
        if (size == 0) {
            return 1;
        }
        ArrayList<Integer> tempList = new ArrayList<Integer>();
        for (int i = 0; i < size; ++i) {
            int existentNeID = ((TETL1NE)this.neList.get(i)).getNEID();
            tempList.add(new Integer(existentNeID));
        }
        Collections.sort(tempList);
        return (Integer)tempList.get(size - 1) + 1;
    }

    public int deleteNE(int neID, String neName) {
        for (int i = this.neList.size() - 1; i >= 0; --i) {
            TETL1NE tmpNE = (TETL1NE)this.neList.get(i);
            if (tmpNE.getNEID() != neID || tmpNE.getNEName().equals(neName)) continue;
            tmpNE.closeConnection();
            this.neList.remove(i);
        }
        return 0;
    }

    public int deleteNE(TETL1NE ne) {
        int neID = ne.getNEID();
        int result = ne.closeConnection();
        if (result < 0) {
            return result;
        }
        if (!TEResourceManager.deleteNeListInfoNENode(TENEListMgr.NELIST_PATH, neID)) {
            return 2;
        }
        TETL1NECommMgr.getInstance().unregisterNEStateListener((long)neID);
        TETL1NECommMgr.getInstance().deleteTL1NEID((long)neID);
        TENEHandlerMgr.getInstance().doNEDeleteHandle(neID);
        for (int i = this.neList.size() - 1; i >= 0; --i) {
            TETL1NE tmpNE = (TETL1NE)this.neList.get(i);
            if (tmpNE.getNEID() != ne.getNEID()) continue;
            this.neList.remove(i);
        }
        return 0;
    }

    public boolean isLogMaxNumNE() {
        int count = 0;
        TETL1NE ne = null;
        int size = this.neList.size();
        for (int i = 0; i < size; ++i) {
            ne = (TETL1NE)this.neList.get(i);
            if (1 != ne.getLogStatus()) continue;
            ++count;
        }
        return count >= 32;
    }

    class NEConnectionThread
    extends Thread {
        NEConnectionThread() {
        }

        @Override
        public void run() {
            TETL1NE tmpNE = null;
            int conStatus = -1;
            for (int i = 0; i < TETL1NEMgr.this.neList.size(); ++i) {
                tmpNE = (TETL1NE)TETL1NEMgr.this.neList.get(i);
                conStatus = TETL1NEMgr.getInstance().createConnection(tmpNE.getNEID(), tmpNE.getPort(), tmpNE.getNEGWAddress(), tmpNE.getNEGWType(), tmpNE.getBaudRate());
                tmpNE.setComStatus(conStatus == 0 ? 1 : 0);
            }
        }
    }

    class NENENMIDNoticeReceiver
    implements NENMIDHandle {
        NENENMIDNoticeReceiver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleNoticeNeNMID(int neID, boolean succToApplyNMID) {
            if (succToApplyNMID) {
                System.out.println("notifyAll before: " + System.currentTimeMillis());
                Object object = TETL1NEMgr.this.sendNMIDObject;
                synchronized (object) {
                    System.out.println("notifyAll after: " + System.currentTimeMillis());
                    TETL1NEMgr.this.sendNMIDObject.notifyAll();
                }
            }
        }
    }
}

