/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.tl1.nemanager;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TEEventBrowseMgr;
import com.huawei.nglct.nelist.model.TETL1AbNormalEvent;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.eventinterpret.TEParseEventDatasXml;
import com.huawei.nglct.tl1.eventinterpret.TETL1EventConstants;
import com.huawei.nglct.tl1.eventinterpret.TETL1EventData;
import com.huawei.nglct.tl1.nemanager.TETL1NE;
import com.huawei.nglct.util.datetime.TEDateUtils;
import com.huawei.uflight.tl1.TL1NoticeHandler;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.GregorianCalendar;
import java.util.HashMap;

public class TETL1NELogoutNoticeHandler
implements TL1NoticeHandler {
    public void handleNotice(String cmdKey, long neid, TL1Operation operation) {
        int neID = (int)neid;
        String logoutUserName = "";
        TETL1NE ne = (TETL1NE)TENEListUtils.getNEObj(neID);
        if (ne == null) {
            return;
        }
        String desc = "";
        int len = operation.getOutMsgCount();
        for (int i = 0; i < len; ++i) {
            OutMsg outmsg = operation.getOutMsg(i);
            HashMap partmap = TETL1CommonUtil.getOutMsgPart(outmsg);
            Part part = (Part)partmap.get("CONDDESCR");
            if (part == null || part.getValue() == null) continue;
            logoutUserName = part.getValue().substring(5, part.getValue().length() - 7);
            desc = part.getValue();
            break;
        }
        int eventID = TETL1EventConstants.USERLOGGEDOUT;
        TETL1EventData eventData = TEParseEventDatasXml.getInstance().getEventData(eventID);
        if (eventData == null) {
            return;
        }
        int evtSeverity = eventData.getEvtSeverity();
        TETL1AbNormalEvent abnormalEvent = new TETL1AbNormalEvent();
        abnormalEvent.eventID = eventID;
        abnormalEvent.eventName = eventData.getEvtName();
        abnormalEvent.location = "-";
        abnormalEvent.direction = "-";
        abnormalEvent.objStr = ne.getNEName();
        abnormalEvent.severityStr = "Not Alarmed";
        abnormalEvent.severityLevel = evtSeverity;
        abnormalEvent.nodeType = ne.getNEType();
        abnormalEvent.evtType = eventData.getEvtType();
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(operation.getDate());
        abnormalEvent.timeRiseStr = TEDateUtils.calendarToStr(calendar);
        abnormalEvent.comment = desc;
        TEEventBrowseMgr.getInstance().addTL1AbNormalEvent(neID, abnormalEvent);
        TELogFactory.getInterfaceLogger().info("NE:" + ne.toString() + " logout notice" + "logoutUserName=" + logoutUserName);
        if (logoutUserName.equals(ne.getCurUser())) {
            ne.setLogStatus(0);
            ne.setCurTopLevelAlm(-1);
            ne.afterLogoutNE();
        }
    }
}

