/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.tl1.nemanager;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.security.EncryptUtils;
import com.huawei.nglct.security.TEDesEnc;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.tl1.TENETypeConvertUtil;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.nemanager.TETL1NE;
import com.huawei.nglct.tl1.nemanager.TETL1NEBuildFactory;
import com.huawei.nglct.util.io.IOStreamConvertor;
import com.huawei.nglct.util.string.TEConvertUtil;
import com.huawei.nglct.util.xml.TEResourceManager;
import com.huawei.uflight.tl1.OperationResult;
import com.huawei.uflight.tl1.TETL1NECommMgr;
import com.huawei.uflight.tl1.tl1operation.DataBlock;
import com.huawei.uflight.tl1.tl1operation.InMsg;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;

public class TETL1NELoginMgr {
    public static final int TL1_COMPLD = 0;
    public static final int TL1_DENY = 1;
    public static final int LOGIN_MAXNUM = 3;
    private static TETL1NELoginMgr instance = null;
    protected String key = "OSPV1R10";

    private TETL1NELoginMgr() {
    }

    public static synchronized TETL1NELoginMgr getInstance() {
        if (null == instance) {
            instance = new TETL1NELoginMgr();
        }
        return instance;
    }

    public TETL1NE login(int neID, String neName, int neType, int neGWType, String neGWAddress, String port, String baudRate, String userName, byte[] userPassword, Fault fault) {
        String hostVersion = "";
        TETL1NE ne = null;
        if (0 == fault.getRetCode() && -1 == neType) {
            hostVersion = this.queryNESoftVer(neID, fault);
            int neVersion = TEConvertUtil.convertVerStrToInt(hostVersion);
            hostVersion = TEConvertUtil.neVersionToString(neVersion);
            if (fault.getRetCode() != 0) {
                ne = new TETL1NE();
                ne.setNEID(neID);
                ne.setLoginCode(fault.getRetCode());
                ne.setNEGWAddress(neGWAddress);
                ne.setNEGWType(neGWType);
                ne.setNEName(neName);
                ne.setNEType(neType);
                ne.setPort(port);
                ne.setIsTL1OrQX(1);
                return ne;
            }
            if (hostVersion.equals("NULL")) {
                hostVersion = "5.51.05.21";
            }
            neType = Integer.parseInt(this.queryNeType(neID, fault));
            if (hostVersion.split("\\.").length > 2) {
                ne = TETL1NEBuildFactory.bulidNE(neType);
                ne.setHostVersion(hostVersion);
                ne.setShowNEVersion(hostVersion);
                ne.setLoginCode(fault.getRetCode());
                ne.setNEGWAddress(neGWAddress);
                ne.setNEID(neID);
                ne.setNEName(neName);
                ne.setCurUser(userName);
                ne.setCurUserPassword(userPassword);
                ne.setNEGWType(neGWType);
                ne.setPort(port);
                ne.setBaudRate(baudRate);
                ne.setIsTL1OrQX(1);
                ne.setNEType(neType);
                ne.setDeviceType(neType);
                if (fault.getRetCode() != 0) {
                    return ne;
                }
                ne.setLogStatus(fault.getRetCode() == 0 ? 1 : 0);
            } else {
                ne = new TETL1NE();
                ne.setNEID(neID);
                ne.setLoginCode(Integer.parseInt(hostVersion));
                ne.setNEGWAddress(neGWAddress);
                ne.setNEName(neName);
                ne.setNEType(neType);
                ne.setNEGWType(neGWType);
                ne.setPort(port);
                ne.setIsTL1OrQX(1);
            }
        } else {
            ne = new TETL1NE();
            ne.setNEID(neID);
            ne.setNEGWAddress(neGWAddress);
            ne.setLoginCode(fault.getRetCode());
            ne.setErrorDes(fault.getErrorDes());
            ne.setErrorCode(fault.getErrorCode());
            ne.setNEName(neName);
            ne.setNEType(neType);
            ne.setPort(port);
            ne.setNEGWType(neGWType);
            ne.setIsTL1OrQX(1);
        }
        ne.queryNESysInfo();
        return ne;
    }

    public TETL1NE login(TETL1NE ne, String userName, byte[] userPassword) {
        TETL1NE subNE = null;
        if (ne.getNEType() == -1) {
            if (null == TETL1NECommMgr.getInstance().getTL1NEName((long)ne.getNEID())) {
                TETL1NECommMgr.getInstance().putLogicNEIDName((long)ne.getNEID(), ne.getNEName());
            }
            TETL1NECommMgr.getInstance().createConect((long)ne.getNEID(), Integer.parseInt(ne.getPort()), ne.getNEGWAddress(), ne.getNEGWType(), ne.getBaudRate());
        }
        Fault fault = this.sendLoginCmd(ne.getNEID(), userName, userPassword);
        int neType = ne.getNEType();
        String hostVersion = "";
        if (0 == fault.getRetCode() && -1 == neType) {
            ne = TETL1NELoginMgr.getInstance().login(ne.getNEID(), ne.getNEName(), -1, ne.getNEGWType(), ne.getNEGWAddress(), ne.getPort(), ne.getBaudRate(), userName, userPassword, fault);
            hostVersion = ne.getHostVersion();
            neType = ne.getNEType();
            if (fault.getRetCode() != 0) {
                ne.setLoginCode(fault.getRetCode());
                return ne;
            }
            if (-1 != neType) {
                subNE = TETL1NEBuildFactory.bulidNE(neType);
                subNE.setNEID(ne.getNEID());
                subNE.setNEGWType(ne.getNEGWType());
                subNE.setNEGWAddress(ne.getNEGWAddress());
                subNE.setPort(ne.getPort());
                subNE.setBaudRate(ne.getBaudRate());
                subNE.setHostVersion(hostVersion);
                subNE.setShowNEVersion(hostVersion);
                subNE.setNEType(neType);
                subNE.setDeviceType(neType);
                subNE.setCurUser(userName);
                subNE.setCurUserPassword(userPassword);
                subNE.setLoginCode(fault.getRetCode());
                subNE.setLogStatus(fault.getRetCode() == 0 ? 1 : 0);
                subNE.setNEName(ne.getNEName());
                subNE.setIsTL1OrQX(1);
                if (TESysManagerConstants.SYS_SINGLE_STATUS == TESysManagerBean.getInstance().getSysStauts()) {
                    TEResourceManager.deleteNeListInfoNENode(TENEListMgr.NELIST_PATH, subNE.getNEID());
                }
                ne = subNE;
                ne.setComStatus(1);
                ne.setDeviceType(neType);
                ne.setLoginCode(fault.getRetCode());
                ne.setErrorDes(fault.getErrorDes());
                ne.setErrorCode(fault.getErrorCode());
                ne.setLogStatus(fault.getRetCode() == 0 ? 1 : 0);
                TENEListMgr.getInstance().deleteNE(ne.getNEID(), ne.getNEName());
                TETL1NECommMgr.getInstance().putLogicNEIDName((long)ne.getNEID(), ne.getNEName());
                TENEListMgr.getInstance().addNE(ne);
                this.sendLoginCmd(ne.getNEID(), userName, userPassword);
                if (!this.isPFE(neType)) {
                    this.setDBCHG(ne.getNEID());
                }
            }
        } else {
            ne.setCurUser(userName);
            ne.setCurUserPassword(userPassword);
            hostVersion = this.queryNESoftVer(ne.getNEID(), fault);
            ne.setHostVersion(hostVersion);
            ne.setShowNEVersion(hostVersion);
            ne.setDeviceType(neType);
            ne.setLoginCode(fault.getRetCode());
            ne.setErrorDes(fault.getErrorDes());
            ne.setErrorCode(fault.getErrorCode());
            ne.setLogStatus(fault.getRetCode() == 0 ? 1 : 0);
            if (fault.getRetCode() == 0 && !this.isPFE(neType)) {
                this.setDBCHG(ne.getNEID());
            }
        }
        if (fault.getRetCode() == 0) {
            ne.queryNESysInfo();
        }
        return ne;
    }

    public int deleteNE(int neID, String neName, Vector v) {
        for (int i = v.size() - 1; i >= 0; --i) {
            TETL1NE tmpNE = (TETL1NE)v.get(i);
            if (tmpNE.getNEID() != neID || !tmpNE.getNEName().equals(neName)) continue;
            v.remove(i);
        }
        return 0;
    }

    public Fault sendLoginCmd(int neID, String userName, byte[] userPassword) {
        Fault fault = new Fault();
        if (TESysManagerConstants.SYS_SINGLE_STATUS == TESysManagerBean.getInstance().getSysStauts() && TENEListMgr.getInstance().isLogMaxNumNE()) {
            fault.setRetCode(1203);
            return fault;
        }
        ArrayList<TL1Operation> operationList = new ArrayList<TL1Operation>();
        TL1Operation oper = null;
        int retCode = 1090650120;
        try {
            oper = this.isEncrypt() ? this.getLoginOper("ACT-USER-EMS", userName, userPassword, true) : this.getLoginOper("ACT-USER-EMS", userName, userPassword, false);
            operationList.add(oper);
            int loginIndex = 0;
            OperationResult result = null;
            while (loginIndex < 3) {
                result = TETL1NECommMgr.getInstance().sendCommand(neID, operationList, 30);
                if (result.retCode == 0) break;
                TELogFactory.getNormalLogger().info("login ne failed,error:" + result.retCode + " at " + ++loginIndex);
            }
            retCode = result.retCode;
            fault.setRetCode(retCode);
            TL1Operation operation = (TL1Operation)operationList.get(0);
            if (operation.getOutMsgCount() == 0) {
                fault.setRetCode(0);
                return fault;
            }
            OutMsg outMsg = operation.getOutMsg(0);
            if (0 != outMsg.getFault().getCompletionCode() && null != outMsg.getFault().getErrCode()) {
                fault.setRetCode(outMsg.getFault().getCompletionCode());
                if (outMsg.getFault().getCompletionCode() == 1) {
                    fault.setRetCode(20489);
                } else {
                    fault.setErrorCode(outMsg.getFault().getErrCode());
                    fault.setErrorDes(outMsg.getFault().getErrDesc());
                }
            }
            TELogFactory.getNormalLogger().info("login ne has finished,error:" + retCode);
            return fault;
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().info("login ne failed", (Throwable)e);
            fault.setRetCode(1090646019);
            return fault;
        }
    }

    public String queryNeType(int neID, Fault fault) {
        ArrayList<TL1Operation> operationList = new ArrayList<TL1Operation>();
        try {
            if (fault.getRetCode() != 0) {
                return "-1";
            }
            TL1Definitions definitions = TECreateObjectFactory.parseTL1DesFile();
            TL1Operation oper = null;
            oper = definitions.getTL1Operation("RTRV-SYS");
            operationList.add(oper);
            OperationResult result = TETL1NECommMgr.getInstance().sendCommand(neID, operationList, 15);
            if (result.retCode != 0) {
                fault.setRetCode(result.retCode);
                return "-1";
            }
            oper = (TL1Operation)operationList.get(0);
            OutMsg outMsg = oper.getOutMsg(0);
            if (0 != outMsg.getFault().getCompletionCode()) {
                fault.setRetCode(24633);
                return "-1";
            }
            HashMap hm = TETL1CommonUtil.getOutMsgPart(outMsg);
            String device = ((Part)hm.get("DEVICETYPE")).getValue();
            TENETypeConvertUtil util = TENETypeConvertUtil.getInstance();
            String neTypeStr = util.getNEType(device);
            return neTypeStr;
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("parse parse fail", (Throwable)e);
            return "-1";
        }
    }

    public Fault setDBCHG(int neID) {
        Fault fault = new Fault();
        ArrayList<TL1Operation> operationList = new ArrayList<TL1Operation>();
        TL1Operation oper = null;
        int retCode = 1090650120;
        try {
            TL1Definitions definitions = TECreateObjectFactory.parseTL1DesFile();
            oper = definitions.getTL1Operation("ALW-MSG-DBCHG");
            operationList.add(oper);
            OperationResult result = TETL1NECommMgr.getInstance().sendCommand(neID, operationList, 10);
            retCode = result.retCode;
            fault.setRetCode(retCode);
            TL1Operation operation = (TL1Operation)operationList.get(0);
            if (operation.getOutMsgCount() == 0) {
                fault.setRetCode(0);
                return fault;
            }
            OutMsg outMsg = operation.getOutMsg(0);
            if (0 != outMsg.getFault().getCompletionCode() && null != outMsg.getFault().getErrCode()) {
                fault.setRetCode(outMsg.getFault().getCompletionCode());
                if (outMsg.getFault().getCompletionCode() == 1) {
                    fault.setRetCode(20489);
                } else {
                    fault.setErrorCode(outMsg.getFault().getErrCode());
                    fault.setErrorDes(outMsg.getFault().getErrDesc());
                }
            }
            TELogFactory.getNormalLogger().info("set DBCHG fail:" + retCode);
            return fault;
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().info("login ne failed", (Throwable)e);
            fault.setRetCode(1090646019);
            return fault;
        }
    }

    private String queryNESoftVer(int neID, Fault fault) {
        String hostVersion = "";
        try {
            if (fault.getRetCode() != 0) {
                return "";
            }
            TL1Definitions definitions = TECreateObjectFactory.parseTL1DesFile();
            ArrayList<TL1Operation> list = new ArrayList<TL1Operation>();
            TL1Operation oper = definitions.getTL1Operation("RTRV-NESOFT-VER");
            list.add(oper);
            OperationResult neverResult = TETL1NECommMgr.getInstance().sendCommand(neID, list, 30);
            if (neverResult.retCode != 0) {
                fault.setRetCode(neverResult.retCode);
                TELogFactory.getNormalLogger().info("query ne version fail");
                return hostVersion;
            }
            oper = (TL1Operation)list.get(0);
            OutMsg[] outMsgs = oper.getOutMsg();
            int bigErrorCode = -1;
            DataBlock dataBlock = null;
            String softName = "";
            String softStatus = "";
            int size = outMsgs.length;
            for (int i = 0; i < size && 1 != (bigErrorCode = outMsgs[i].getFault().getCompletionCode()); ++i) {
                dataBlock = outMsgs[i].getMsgBlock().getDataBlock(0);
                softName = dataBlock.getPart(0).getValue();
                softStatus = dataBlock.getPart(3).getValue();
                if (!"NSF1".equals(softName) && !"NSF2".equals(softName) || !"active".equals(softStatus)) continue;
                hostVersion = dataBlock.getPart(1).getValue();
                TELogFactory.getNormalLogger().info("neID = " + neID + ": hostVersion = " + hostVersion);
                break;
            }
        }
        catch (Exception ex) {
            TELogFactory.getNormalLogger().error("parse xml fail.", (Throwable)ex);
        }
        return hostVersion;
    }

    private String[] encUserOrPWD(String userName, byte[] userPassword) throws Exception {
        String[] userPWD = new String[2];
        TEDesEnc des = new TEDesEnc();
        byte[] inUser = new byte[16];
        byte[] inPsw = new byte[16];
        byte[] encUserByte = new byte[16];
        byte[] encPasswordByte = new byte[16];
        des.init(TEDesEnc.ENCRYPT_MODE, this.key.getBytes());
        if (userName != null && !userName.equals("")) {
            System.arraycopy(userName.getBytes(), 0, inUser, 0, userName.getBytes().length);
            des.deNCBCEncrypt(userName.getBytes(), this.key.getBytes(), 0, inUser, 16, encUserByte);
        }
        if (userPassword != null && userPassword.length > 0) {
            System.arraycopy(userPassword, 0, inPsw, 0, userPassword.length);
            des.deNCBCEncrypt(this.key.getBytes(), this.key.getBytes(), 0, inPsw, 16, encPasswordByte);
        }
        userPWD[0] = IOStreamConvertor.hexChangToString(encUserByte);
        userPWD[1] = IOStreamConvertor.hexChangToString(encPasswordByte);
        return userPWD;
    }

    private TL1Operation getLoginOper(String loginCMD, String userName, byte[] userPassword, boolean isEncrypt) throws Exception {
        TL1Definitions definitions = TECreateObjectFactory.parseTL1DesFile();
        String logUserName = userName;
        String logPWD = "";
        TL1Operation oper = definitions.getTL1Operation(loginCMD);
        InMsg inMsg = oper.getInMsg();
        Part pwdPart = inMsg.getMsgBlock().getDataBlock(0).getPart(0);
        if (isEncrypt) {
            pwdPart.setEncryptflag(false);
            String[] userPWD = this.encUserOrPWD(userName, userPassword);
            logUserName = userPWD[0];
            logPWD = userPWD[1];
        } else {
            pwdPart.setEncryptflag(true);
            logPWD = EncryptUtils.encryptAESByte2Str(userPassword);
        }
        Part userPart = inMsg.getStagBlock().getAID().getPart(0);
        userPart.setValue(logUserName);
        pwdPart.setValue(logPWD);
        return oper;
    }

    private boolean isPFE(int neType) {
        return 72 == neType || 113 == neType;
    }

    private boolean isEncrypt() {
        boolean encryLogin = false;
        return encryLogin;
    }

    public class Fault {
        int retCode;
        String errorCode;
        String errorDes;

        public int getRetCode() {
            return this.retCode;
        }

        public void setRetCode(int retCode) {
            this.retCode = retCode;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getErrorDes() {
            return this.errorDes;
        }

        public void setErrorDes(String errorDes) {
            this.errorDes = errorDes;
        }
    }
}

