/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.tl1.nemanager;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TEBoardGraphNew;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TESubBoard;
import com.huawei.nglct.nelist.model.cpnerelate.TEBoardSlotInfo;
import com.huawei.nglct.tl1.nemanager.TETL1NE;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Vector;
import org.slf4j.Logger;

public class TETL1NEBoardGraph
implements TENEMgrInterface {
    private static final String NE_NAME_PARAM = "neName";
    private static final String SLOT_ID_PARAM = "slotID";
    private static final String BOARD_TYPE_PARAM = "boardType";
    private static final String BOARD_NAME_PARAM = "boardName";
    private static final String BOARD_LOOP_PARAM = "boardLoop";
    private static final String BOARD_PG_PARAM = "boardPG";
    private static final String BOARD_STATE_PARAM = "boardState";
    private static final String TOP_ALARM_LEVEL = "topAlmLevel";
    private static final String COLOR_STATE_PARAM = "boardColor";
    private static final String BOARD_OUT = "0";
    private static final String BOARD_OUT_LOGIC = "1";
    private static final String BOARD_IN_RUN = "3";
    private static final String BOARD_IN_PHY = "2";
    private ArrayList usedSlotList = new ArrayList();
    private static final String BOARD_SLOT_LIST_PARAM = "slotList";
    private static final String SUB_CARD_SUPPORT = "issupportsubcard";
    private static final String SUPPORT_CARD_TYPES = "supportsubtypes";
    private static final String SUB_CARD_ID_PARAM = "subcardid";
    private static final String SUB_CARD_TYPE_PARAM = "subcardtype";
    private static final String SUB_CARD_NAME_PARAM = "subcardname";
    private static final String SUB_CARD_STATE_PARAM = "subcardstate";
    private Datainterface outputData = null;
    private static HashMap<String, String> convertBoardMap = new HashMap();
    private Logger log = TELogFactory.getNormalLogger();

    @Override
    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        Vector temBoardList = null;
        Vector temPhyBoardList = null;
        ArrayList boardList = new ArrayList();
        ArrayList phyBoardList = new ArrayList();
        RowParams rowparams = null;
        this.outputData = new Datainterface();
        this.outputData.setBussinessParams(new BussinessParams());
        Param manual = inputData.getBussinessParams().getRowParams(0).getParam("manual");
        boolean bCorrect = true;
        try {
            int i;
            TETL1NE currentNE = (TETL1NE)TENEListUtils.getNEObj(neid);
            if (manual != null && manual.getValue() != null && manual.getValue().equals("true")) {
                currentNE.setBoardList(new Vector());
                currentNE.setPhyBoardList(new Vector());
                currentNE.queryBoard();
            }
            RowParams inputRowParams = inputData.getBussinessParams().getRowParams(0);
            Param tmpParam = null;
            for (int i2 = inputRowParams.getParamCount() - 1; i2 >= 0; --i2) {
                tmpParam = inputRowParams.getParam(i2);
                if (!tmpParam.getName().equals("correct") || !BOARD_OUT.equals(tmpParam.getValue()) && !"false".equals(tmpParam.getValue())) continue;
                bCorrect = false;
            }
            String neName = currentNE.getNEName();
            boolean boardupdateflag = currentNE.getBoardUpdateFlag();
            rowparams = new RowParams();
            rowparams.addParam(NE_NAME_PARAM, neName);
            rowparams.addParam("boardupgateflag", String.valueOf(boardupdateflag));
            this.outputData.getBussinessParams().addRowParams(rowparams);
            temBoardList = currentNE.getClonedBoardList();
            temPhyBoardList = currentNE.getClonedPhyBoardList();
            TEBoard logicboard = null;
            TEBoard phyboard = null;
            int slotid = -1;
            int physlotid = -1;
            int physize = 0;
            int logsize = 0;
            int j = 0;
            boolean ifinputrow = false;
            String boardState = BOARD_OUT;
            if (null != temBoardList) {
                for (i = 0; i < temBoardList.size(); ++i) {
                    boardList.add(temBoardList.get(i));
                }
                Collections.sort(boardList);
                logsize = boardList.size();
                for (i = 0; i < logsize; ++i) {
                    logicboard = (TEBoard)boardList.get(i);
                    this.addUsedSlotList(neid, logicboard, bCorrect);
                }
            }
            if (null != temPhyBoardList) {
                for (i = 0; i < temPhyBoardList.size(); ++i) {
                    phyBoardList.add(temPhyBoardList.get(i));
                }
                Collections.sort(phyBoardList);
                physize = phyBoardList.size();
            }
            for (i = 0; i < logsize; ++i) {
                logicboard = (TEBoard)boardList.get(i);
                slotid = logicboard.getSlotID();
                ifinputrow = false;
                int level = currentNE.getCurTopLevelAlm(slotid);
                if (0 == slotid) continue;
                while (j < physize) {
                    phyboard = (TEBoard)phyBoardList.get(j);
                    physlotid = phyboard.getSlotID();
                    if (slotid > physlotid) {
                        if (this.checkSlotIdle(neid, phyboard, bCorrect)) {
                            boardState = BOARD_IN_PHY;
                            this.createOutputData(neid, phyboard, boardState, phyboard.getState(), bCorrect, level);
                        }
                        ++j;
                        continue;
                    }
                    if (slotid == physlotid) {
                        if (logicboard.compareTo(phyboard) == 0) {
                            boardState = BOARD_IN_RUN;
                            this.createOutputData(neid, logicboard, boardState, logicboard.getState(), bCorrect, level);
                        } else {
                            boardState = BOARD_OUT_LOGIC;
                            this.createOutputData(neid, logicboard, boardState, logicboard.getState(), bCorrect, level);
                        }
                        ifinputrow = true;
                        ++j;
                        break;
                    }
                    if (slotid >= physlotid) continue;
                    boardState = BOARD_OUT_LOGIC;
                    this.createOutputData(neid, logicboard, boardState, logicboard.getState(), bCorrect, level);
                    ifinputrow = true;
                    break;
                }
                if (j < physize || ifinputrow) continue;
                boardState = BOARD_OUT_LOGIC;
                this.createOutputData(neid, logicboard, boardState, logicboard.getState(), bCorrect, level);
            }
            while (j < physize) {
                phyboard = (TEBoard)phyBoardList.get(j);
                if (this.checkSlotIdle(neid, phyboard, bCorrect)) {
                    boardState = BOARD_IN_PHY;
                    int level = currentNE.getCurTopLevelAlm(phyboard.getSlotID());
                    this.createOutputData(neid, phyboard, boardState, phyboard.getState(), bCorrect, level);
                }
                ++j;
            }
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(0));
        }
        catch (Exception e) {
            this.log.error("Get boart error\u00a3\u00ba", (Throwable)e);
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(1090646019));
            return this.outputData;
        }
        return this.outputData;
    }

    @Override
    public boolean isNeedOperationlog() {
        return false;
    }

    private void createOutputData(int neid, TEBoard board, String boardState, int color, boolean bCorrect, int topAlmLevel) {
        TEBoardSlotInfo slotInfo;
        if (null == board) {
            return;
        }
        Param neNameParam = null;
        Param slotidparam = null;
        Param boardtypeparam = null;
        Param boardnameparam = null;
        Param boardloopparam = null;
        Param boardpgparam = null;
        Param boardstateparam = null;
        Param boardslotlist = null;
        Param boardcolorparam = null;
        String slotList = "";
        int slotid = -1;
        int boardtype = -1;
        RowParams rowparams = null;
        rowparams = new RowParams();
        slotid = board.getSlotID();
        boardtype = board.getBoardType();
        neNameParam = new Param(NE_NAME_PARAM, board.getBoardName());
        rowparams.addParam(neNameParam);
        slotidparam = new Param(SLOT_ID_PARAM, String.valueOf(slotid));
        rowparams.addParam(slotidparam);
        boardtypeparam = new Param(BOARD_TYPE_PARAM, String.valueOf(boardtype));
        rowparams.addParam(boardtypeparam);
        boardnameparam = new Param(BOARD_NAME_PARAM, board.getBoardTypeName());
        rowparams.addParam(boardnameparam);
        boardloopparam = new Param(BOARD_LOOP_PARAM, String.valueOf(board.getBoardLoop()));
        rowparams.addParam(boardloopparam);
        boardpgparam = new Param(BOARD_PG_PARAM, String.valueOf(board.getBoardPG()));
        rowparams.addParam(boardpgparam);
        boardstateparam = new Param(BOARD_STATE_PARAM, boardState);
        rowparams.addParam(boardstateparam);
        boardstateparam = new Param(TOP_ALARM_LEVEL, String.valueOf(topAlmLevel));
        rowparams.addParam(boardstateparam);
        boardcolorparam = new Param(COLOR_STATE_PARAM, String.valueOf(color));
        rowparams.addParam(boardcolorparam);
        int subrackId = 0;
        if (bCorrect) {
            subrackId = TEBoardUtil.getSubrackIDFromSlot(neid, slotid);
            slotid = TEBoardUtil.getSlotIDFromSlot(neid, slotid);
        }
        slotList = null != (slotInfo = TEConfigurationDataMgr.getInstance().getBoardSlotInfo(neid, subrackId, boardtype, slotid)) ? slotInfo.toString() : slotid + "";
        boolean isSupport = TEBoardUtil.isSupportSubCard(boardtype);
        Param isSupportSubcard = new Param(SUB_CARD_SUPPORT, String.valueOf(isSupport));
        rowparams.addParam(isSupportSubcard);
        Param supportCardTypes = new Param(SUPPORT_CARD_TYPES, TEBoardUtil.getSupportSubCardTypes(neid, boardtype));
        rowparams.addParam(supportCardTypes);
        if (!board.getSubBoardList().isEmpty()) {
            TESubBoard subboard = (TESubBoard)board.getSubBoardList().get(0);
            Param subcardid = new Param(SUB_CARD_ID_PARAM, String.valueOf(subboard.getSubSlotID()));
            rowparams.addParam(subcardid);
            Param subcardtype = new Param(SUB_CARD_TYPE_PARAM, String.valueOf(subboard.getSubBoardType()));
            rowparams.addParam(subcardtype);
            Param subcardname = new Param(SUB_CARD_NAME_PARAM, subboard.getSubBoardName());
            rowparams.addParam(subcardname);
            Param subcardstate = new Param(SUB_CARD_STATE_PARAM, String.valueOf(subboard.getState()));
            rowparams.addParam(subcardstate);
        }
        String[] slotArr = slotList.split(",");
        StringBuffer slotListStr = new StringBuffer();
        for (int i = 0; i < slotArr.length; ++i) {
            slotListStr.append(",").append(Integer.parseInt(slotArr[i]));
        }
        boardslotlist = new Param(BOARD_SLOT_LIST_PARAM, slotListStr.toString().substring(1));
        rowparams.addParam(boardslotlist);
        this.outputData.getBussinessParams().addRowParams(rowparams);
    }

    public void addUsedSlotList(int neid, TEBoard board, boolean bCorrect) {
        TEBoardGraphNew.addUsedSlotList(neid, board, bCorrect, this.usedSlotList);
    }

    public boolean checkSlotIdle(int neid, TEBoard board, boolean bCorrect) {
        return TEBoardGraphNew.checkSlotIdle(neid, board, bCorrect, this.usedSlotList);
    }

    static {
        convertBoardMap.put("53NQ2(COMP)", "53NQ2");
        convertBoardMap.put("53ND2(COMP)", "53ND2");
        convertBoardMap.put("53NS2(COMP)", "53NS2");
        convertBoardMap.put("55NPO2(STND)", "55NPO2");
        convertBoardMap.put("54ENQ2(STND)", "54ENQ2");
    }
}

