/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.tl1.nemanager;

import com.huawei.nglct.bscfg.equipment.TEEquipmentDescription;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.gencfg.TETimeTocalizationSwitchBean;
import com.huawei.nglct.nelist.TEAlarmData;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEAlarmAnalyse;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.TESubrack;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEPortIndex;
import com.huawei.nglct.nelist.model.TESubBoard;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.tl1.TEBoardNameConvertUtil;
import com.huawei.nglct.tl1.TEBoardState;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.TETL1DBCHGData;
import com.huawei.nglct.tl1.nemanager.TENEImplInterface_TL1NE;
import com.huawei.nglct.tl1.nemanager.TENEInterImpl_TL1NE;
import com.huawei.nglct.tl1.nemanager.TENESingleImpl_TL1NE;
import com.huawei.nglct.tl1.nemanager.TETL1Alarm;
import com.huawei.nglct.tl1.nemanager.TETL1FaultUtil;
import com.huawei.nglct.tl1.nemanager.TETL1NELoginNoticeHandler;
import com.huawei.nglct.tl1.nemanager.TETL1NELogoutNoticeHandler;
import com.huawei.nglct.tl1.nemanager.TETL1QueryLogicPort;
import com.huawei.nglct.tl1.nemanager.TETL1QueryLogicPortRunnable;
import com.huawei.nglct.tl1.nemgr.nebasefun.fault.TETL1AlarmNoticeHandler;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.login.TELoginNEManager;
import com.huawei.nglct.util.string.TEConvertUtil;
import com.huawei.uflight.qxprotocol.definitions.Definitions;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.tl1.OperationResult;
import com.huawei.uflight.tl1.TETL1NECommMgr;
import com.huawei.uflight.tl1.TL1NoticeHandler;
import com.huawei.uflight.tl1.tl1operation.InMsg;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class TETL1NE
extends TENE {
    protected static final int TIMEOUT = 20;
    protected static final int TERMINAL_TYPE = 1;
    protected long lastBoardModifyTime = 0L;
    protected Vector alarmList = new Vector();
    protected Hashtable alarmAttrDataMap = null;
    protected static final int FB_PANEL = 53;
    protected static final int FB_OTHER = 30;
    protected static final int BOARD_STANDBY = 1;
    protected static final int STATUS_ADD = 1;
    protected static final int STATUS_DEL = 2;
    protected static final String STATUS_ACTIVE = "3";
    protected static final int NE_ALM_ANALYSE = -1;
    protected static final int NO_PORT_FLAG = 255;
    protected int BOARD_QUERY_PERIOD = 10000;
    protected int BOARD_QUERY_DELAY = 10000;
    protected Vector boardList = new Vector();
    protected Vector phyBoardList = new Vector();
    public TENEAlarmAnalyse alarmAnalyse = new TENEAlarmAnalyse();
    protected Hashtable pfmThrsDataMap = new Hashtable();
    protected Vector cpThrshDataList = new Vector();
    protected TETL1NELoginNoticeHandler loginNoticeHandler = new TETL1NELoginNoticeHandler();
    protected TETL1NELogoutNoticeHandler logoutNoticeHandler = new TETL1NELogoutNoticeHandler();
    protected TETL1AlarmNoticeHandler almNoticeHandler = new TETL1AlarmNoticeHandler();
    protected int loginCode = -2;
    protected Vector subrackList = new Vector();
    protected int TIME_OUT = 30;
    protected String TL1_DES_PATH = "";
    protected String errorCode;
    protected String errorDes;
    public boolean isQueryAlarmSucc = true;
    private String startAsonFlag = "";
    public static final String DLT_EQPT = "DLT-EQPT";
    public static final String ENT_EQPT = "ENT-EQPT";
    public static final String ED_EQPT = "ED-EQPT";

    public TETL1NE() {
        if (this.isInterrationStatus()) {
            this.setNeImplInterface(new TENEInterImpl_TL1NE(this.neID));
        } else {
            this.setNeImplInterface(new TENESingleImpl_TL1NE(this.neID));
        }
    }

    @Override
    public void initNEData() {
        this.registerEvent();
        TENEImplInterface_TL1NE neImpl = (TENEImplInterface_TL1NE)this.getNeImplInterface();
        neImpl.setTL1_DES_PATH(TETL1CommonUtil.TL1_DES_PATH);
        this.queryNEInfo();
        this.setTimeTask();
        this.startNESysTimeTask();
    }

    protected void startNESysTimeTask() {
    }

    protected void cancelNESysTimeTask() {
    }

    public void initNEDataInte() {
        TENEImplInterface_TL1NE neImpl = (TENEImplInterface_TL1NE)this.getNeImplInterface();
        neImpl.setBOARD_QUERY_PERIOD(60000);
        this.registerEvent();
        this.queryNEInfo();
        this.setTimeTask();
    }

    public void queryNEInfo() {
        this.queryTimeZome();
        this.queryBoard();
        this.queryPMDay();
    }

    @Override
    public void queryBoard() {
        this.querySubrack();
        this.queryLPBoard();
        this.queryLogicPort();
    }

    public void queryNESysInfo() {
        ArrayList<TL1Operation> operationList = new ArrayList<TL1Operation>();
        try {
            TL1Definitions definitions = TECreateObjectFactory.parseTL1DesFile();
            TL1Operation oper = null;
            oper = definitions.getTL1Operation("RTRV-SYS");
            operationList.add(oper);
            OperationResult result = TETL1NECommMgr.getInstance().sendCommand(this.neID, operationList, 30);
            if (result.retCode != 0) {
                return;
            }
            oper = (TL1Operation)operationList.get(0);
            OutMsg outMsg = oper.getOutMsg(0);
            if (0 != outMsg.getFault().getCompletionCode()) {
                return;
            }
            HashMap hm = TETL1CommonUtil.getOutMsgPart(outMsg);
            TENEImplInterface_TL1NE neImpl = (TENEImplInterface_TL1NE)this.getNeImplInterface();
            neImpl.setNeState("runstate");
            this.setShelfType(136);
            if (hm.get("NODEID") != null) {
                String nodeid = ((Part)hm.get("NODEID")).getValue();
                this.setNodeID(nodeid);
            }
            if (hm.get("ASON") != null) {
                String asonFlag = ((Part)hm.get("ASON")).getValue();
                this.setStartAsonFlag(asonFlag);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("parse parse fail", (Throwable)e);
        }
    }

    public void queryTimeZome() {
        ArrayList<TL1Operation> operationList = new ArrayList<TL1Operation>();
        try {
            TL1Definitions definitions = TECreateObjectFactory.parseTL1DesFile();
            TL1Operation oper = null;
            oper = definitions.getTL1Operation("RTRV-DAT");
            operationList.add(oper);
            OperationResult result = TETL1NECommMgr.getInstance().sendCommand(this.neID, operationList, 20);
            if (result.retCode != 0) {
                return;
            }
            oper = (TL1Operation)operationList.get(0);
            OutMsg outMsg = oper.getOutMsg(0);
            if (0 != outMsg.getFault().getCompletionCode()) {
                return;
            }
            HashMap dataBlock = TETL1CommonUtil.getOutMsgPart(outMsg);
            Part tmPart = (Part)dataBlock.get("TMZONE");
            String timeZone = tmPart.getValue();
            this.setTimeZome(timeZone);
            TETimeTocalizationSwitchBean.getTimeZoneDateInstance(this.neID).getNETimeZone();
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("parse parse fail", (Throwable)e);
        }
    }

    public void queryPMDay() {
        ArrayList<TL1Operation> operationList = new ArrayList<TL1Operation>();
        try {
            TL1Definitions definitions = TECreateObjectFactory.parseTL1DesFile();
            TL1Operation oper = null;
            oper = definitions.getTL1Operation("RTRV-PMDAY");
            operationList.add(oper);
            OperationResult result = TETL1NECommMgr.getInstance().sendCommand(this.neID, operationList, 20);
            if (result.retCode != 0) {
                return;
            }
            oper = (TL1Operation)operationList.get(0);
            OutMsg outMsg = oper.getOutMsg(0);
            if (0 != outMsg.getFault().getCompletionCode()) {
                return;
            }
            HashMap dataBlock = TETL1CommonUtil.getOutMsgPart(outMsg);
            Part tmPart = (Part)dataBlock.get("PMDAY");
            String pmday = tmPart.getValue();
            this.setPmdaytime(Integer.parseInt(pmday));
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("parse parse fail", (Throwable)e);
        }
    }

    public int getPmdaytime() {
        TENEImplInterface_TL1NE neImpl = (TENEImplInterface_TL1NE)this.getNeImplInterface();
        return neImpl.getPmdaytime();
    }

    public void setPmdaytime(int pmdaytime) {
        TENEImplInterface_TL1NE neImpl = (TENEImplInterface_TL1NE)this.getNeImplInterface();
        neImpl.setPmdaytime(pmdaytime);
    }

    @Override
    public void setLastBoardModifyTime() {
        TENEImplInterface_TL1NE neImpl = (TENEImplInterface_TL1NE)this.getNeImplInterface();
        neImpl.setLastBoardModifyTime(System.currentTimeMillis());
    }

    @Override
    public boolean isCanUpdateBoardList() {
        if (TESysManagerConstants.SYS_SINGLE_STATUS != TESysManagerBean.getInstance().getSysStauts()) {
            return true;
        }
        TENEImplInterface_TL1NE neImplInterface = (TENEImplInterface_TL1NE)this.getNeImplInterface();
        return (double)Math.abs(System.currentTimeMillis() - neImplInterface.getLastBoardModifyTime()) > (double)neImplInterface.getBOARD_QUERY_PERIOD() * 1.5;
    }

    public void queryLPBoard() {
        ArrayList operationList = TETL1CommonUtil.createQueryBoardOperList(this.getNEID(), "SLOT-ALL");
        if (operationList == null || operationList.isEmpty()) {
            return;
        }
        OperationResult result = TETL1NECommMgr.getInstance().sendCommand(this.neID, (List)operationList, 60);
        if (result.retCode != 0) {
            TELogFactory.getNormalLogger().info("query board fail,the errorCode is " + result.retCode);
            this.setLoginCode(result.retCode);
            return;
        }
        this.setBoardToMemory(operationList);
    }

    public void setBoardToMemory(ArrayList operationList) {
        boolean querySucc = false;
        HashMap<String, TEBoard> queryboardMap = new HashMap<String, TEBoard>();
        Vector<TEBoard> newPhyBoardList = new Vector<TEBoard>();
        OutMsg[] outMsgs = ((TL1Operation)operationList.get(0)).getOutMsg();
        int slotID = -1;
        String boardName = "";
        int boardType = -1;
        TEBoard board = null;
        String sst = "";
        String pst = "";
        int size = outMsgs.length;
        for (int i = 0; i < size; ++i) {
            if (0 != outMsgs[i].getFault().getCompletionCode()) {
                this.setLoginCode(outMsgs[i].getFault().getCompletionCode());
                this.setErrorCode(outMsgs[i].getFault().getErrCode());
                this.setErrorDes(outMsgs[i].getFault().getErrDesc());
                return;
            }
            querySucc = true;
            HashMap dataBlock = TETL1CommonUtil.getOutMsgPart(outMsgs[i]);
            String[] tempSlots = ((Part)dataBlock.get("slotID")).getValue().split("SLOT-");
            if (2 != tempSlots.length) continue;
            slotID = TETL1CommonUtil.neShelfIDSlotIDToSlotIDNM(tempSlots[1]);
            boardName = ((Part)dataBlock.get("PROVTYPE")).getValue();
            pst = ((Part)dataBlock.get("PST")).getValue();
            sst = ((Part)dataBlock.get("SST")).getValue();
            int state = TEBoardState.setStateInPSTANDSST(pst, sst);
            TEBoardNameConvertUtil boardNameConvertUtil = TEBoardNameConvertUtil.getInstance();
            boardNameConvertUtil.setNeType(this.getNeImplInterface().getNeType());
            boardNameConvertUtil.setHostVersion(this.getNeImplInterface().getHostVersion());
            if (null != boardName && !"".equals(boardName)) {
                String convertName = boardNameConvertUtil.nameToNM(boardName);
                boardType = TEConfigurationDataMgr.getInstance().getBoardType(this.getNeImplInterface().getNeType(), boardName, convertName);
                if (boardType == -1) continue;
                board = new TEBoard(this.neID, slotID, boardType, boardName);
                board.setState(state);
                if (sst != null && sst.indexOf("STBYH") != -1) {
                    board.setBoardPG(1);
                }
                if (TEBoardUtil.isSupportSubCard(boardType)) {
                    this.querySubCard(board);
                }
                queryboardMap.put(String.valueOf(slotID), board);
            }
            if (null == (boardName = ((Part)dataBlock.get("ACTTYPE")).getValue()) || "".equals(boardName)) continue;
            String convertBoardName = boardNameConvertUtil.nameToNM(boardName);
            boardType = TEConfigurationDataMgr.getInstance().getBoardType(this.getNeImplInterface().getNeType(), boardName, convertBoardName);
            if (boardType == -1) continue;
            board = new TEBoard(this.neID, slotID, boardType, boardName);
            if (sst != null && sst.indexOf("STBYH") != -1) {
                board.setBoardPG(1);
            }
            board.setState(state);
            newPhyBoardList.add(board);
        }
        this.reNewMemoryPhyBoard(newPhyBoardList);
        if (querySucc) {
            TENEImplInterface_TL1NE neImpl = (TENEImplInterface_TL1NE)this.getNeImplInterface();
            Vector boardList = neImpl.getBoardList();
            if (queryboardMap.size() != boardList.size()) {
                this.setBoardUpdateFlag(true);
            } else {
                int i = 0;
                int len = boardList.size();
                for (i = 0; i < len; ++i) {
                    TEBoard board1 = (TEBoard)boardList.get(i);
                    if (queryboardMap.containsValue(board1)) continue;
                    this.setBoardUpdateFlag(true);
                    break;
                }
                if (i >= len) {
                    this.setBoardUpdateFlag(false);
                }
            }
            Vector<TEBoard> tmpBoardVec = new Vector<TEBoard>();
            Iterator iter = queryboardMap.values().iterator();
            while (iter.hasNext()) {
                tmpBoardVec.add((TEBoard)iter.next());
            }
            this.reNewMemoryLogBoard(tmpBoardVec);
            Collections.sort(boardList);
        }
        queryboardMap.clear();
    }

    private void deleteSubCard(TEBoard board) {
        board.getSubBoardList().clear();
    }

    private void querySubCard(TEBoard board) {
        ArrayList<Object> operationList = new ArrayList<Object>();
        try {
            TL1Definitions definitions = TECreateObjectFactory.parseTL1DesFile();
            TL1Operation oper = null;
            oper = definitions.getTL1Operation("RTRV-EQPT");
            InMsg input = oper.getInMsg();
            StringBuffer sb = new StringBuffer();
            sb.append("SLOT-").append(TETL1CommonUtil.slotIDNMToNEShelfIDSlotID(this.neID, board.getSlotID())).append("-ALL");
            input.getPart("AID").setValue(sb.toString());
            operationList.add(oper.clone());
            OperationResult result = TETL1NECommMgr.getInstance().sendCommand(this.neID, operationList, 30);
            if (result.retCode != 0) {
                return;
            }
            ArrayList<TESubBoard> subBoardList = new ArrayList<TESubBoard>();
            for (int ii = 0; ii < operationList.size(); ++ii) {
                int subCardType;
                String convertBoardName;
                oper = (TL1Operation)operationList.get(ii);
                OutMsg outMsg = oper.getOutMsg(ii);
                if (0 != outMsg.getFault().getCompletionCode()) {
                    return;
                }
                HashMap hm = TETL1CommonUtil.getOutMsgPart(outMsg);
                String[] tempSlots = ((Part)hm.get("slotID")).getValue().split("SLOT-");
                int slotID = -1;
                if (2 == tempSlots.length) {
                    slotID = TETL1CommonUtil.neShelfIDSlotIDToSlotIDNM(tempSlots[1]);
                }
                TESubBoard subBoard = new TESubBoard(board, this.neID, slotID, -1);
                String subBoardName = ((Part)hm.get("PROVTYPE")).getValue();
                if (null != subBoardName && !"".equals(subBoardName)) {
                    subBoard.setSubBoardName(subBoardName);
                    convertBoardName = TEBoardNameConvertUtil.getInstance().nameToNM(subBoardName);
                    subCardType = TEConfigurationDataMgr.getInstance().getBoardType(this.getNeImplInterface().getNeType(), subBoardName, convertBoardName);
                    subBoard.setSubBoardType(subCardType);
                    subBoard.setState(1);
                    subBoardList.add(subBoard);
                }
                if (null == (subBoardName = ((Part)hm.get("ACTTYPE")).getValue()) || "".equals(subBoardName)) continue;
                convertBoardName = TEBoardNameConvertUtil.getInstance().nameToNM(subBoardName);
                subCardType = TEConfigurationDataMgr.getInstance().getBoardType(this.getNeImplInterface().getNeType(), subBoardName, convertBoardName);
                if (subBoardList.isEmpty()) {
                    subBoard.setSubBoardName(subBoardName);
                    subBoard.setSubBoardType(subCardType);
                    subBoard.setState(2);
                    subBoardList.add(subBoard);
                    continue;
                }
                subBoard.setState(3);
            }
            board.addSubBoardList(subBoardList);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("parse parse fail", (Throwable)e);
        }
    }

    private void reNewMemoryLogBoard(Vector tmpBoardVec) {
        TENEImplInterface_TL1NE neImpl = (TENEImplInterface_TL1NE)this.getNeImplInterface();
        Vector boardList = neImpl.getBoardList();
        if (tmpBoardVec.size() > 1) {
            this.setBoardList(tmpBoardVec);
        } else {
            int m = tmpBoardVec.size();
            for (int j = 0; j < m; ++j) {
                TEBoard newBoard = (TEBoard)tmpBoardVec.get(j);
                TEBoard oldBoard = this.getBoard(newBoard.getSlotID());
                if (oldBoard == null || newBoard.getBoardType() != oldBoard.getBoardType()) {
                    if (oldBoard != null) {
                        boardList.remove(oldBoard);
                    }
                    boardList.add(newBoard);
                    if (!TEConfigurationDataMgr.getInstance().isDynPortBoardType(this.neID, newBoard.getBoardType())) continue;
                    TETL1QueryLogicPort.queryExistLogicPort(this.neID, newBoard.getSlotID(), newBoard.getBoardType());
                    continue;
                }
                if (oldBoard.getState() == newBoard.getState()) continue;
                oldBoard.setState(newBoard.getState());
            }
        }
    }

    private void reNewMemoryPhyBoard(Vector newPhyBoardList) {
        TENEImplInterface_TL1NE neImpl = (TENEImplInterface_TL1NE)this.getNeImplInterface();
        Vector phyBoardList = neImpl.getPhyBoardList();
        if (newPhyBoardList.size() > 1) {
            this.setPhyBoardList(newPhyBoardList);
        } else {
            int m = newPhyBoardList.size();
            for (int j = 0; j < m; ++j) {
                TEBoard newBoard = (TEBoard)newPhyBoardList.get(j);
                TEBoard oldBoard = this.getPhyBoard(newBoard.getSlotID());
                if (oldBoard == null || newBoard.getBoardType() != oldBoard.getBoardType()) {
                    if (oldBoard != null) {
                        phyBoardList.remove(oldBoard);
                    }
                    phyBoardList.add(newBoard);
                    continue;
                }
                if (oldBoard.getState() == newBoard.getState()) continue;
                oldBoard.setState(newBoard.getState());
            }
        }
    }

    @Override
    public void update(TETL1DBCHGData data) {
        String aid = data.getDbchgAID();
        String[] aids = TETL1CommonUtil.parseAID(aid, this.neID);
        int type = this.getAIDType(aids);
        if (data.getDbchgCMDCode().equalsIgnoreCase(ENT_EQPT)) {
            if (type == 1) {
                this.queryCurSubrack(aid);
            } else if (type == 2) {
                boolean flag;
                this.queryBoard(aid);
                TENE ne = TENEListUtils.getNEObj(this.neID);
                int slotID = TETL1CommonUtil.getNMSlotStr(aid, this.neID);
                TEBoard board = ne.getBoard(slotID);
                int boardType = -1;
                if (board != null) {
                    boardType = board.getBoardType();
                }
                if (flag = TEConfigurationDataMgr.getInstance().isDynPortBoardType(slotID, boardType)) {
                    TETL1QueryLogicPort.queryExistLogicPort(this.neID, slotID, boardType);
                }
            } else if (type == 3) {
                int slotid = TETL1CommonUtil.getNMSlotStr(aid, this.neID);
                TEBoard board = this.getBoard(slotid);
                if (board != null && TEBoardUtil.isSupportSubCard(board.getBoardType())) {
                    this.querySubCard(board);
                } else {
                    this.queryDynPort(aid);
                }
            }
        } else if (data.getDbchgCMDCode().equalsIgnoreCase(DLT_EQPT)) {
            if (type == 1) {
                this.delCurSubrack(aid);
            } else if (type == 2 && TESysManagerConstants.SYS_SINGLE_STATUS == TESysManagerBean.getInstance().getSysStauts()) {
                this.delBoard(aid);
            } else if (type == 3) {
                int slotid = TETL1CommonUtil.getNMSlotStr(aid, this.neID);
                TEBoard board = this.getBoard(slotid);
                if (board != null && TEBoardUtil.isSupportSubCard(board.getBoardType()) && TESysManagerConstants.SYS_SINGLE_STATUS == TESysManagerBean.getInstance().getSysStauts()) {
                    this.deleteSubCard(board);
                } else {
                    this.delDynPort(aid);
                }
            }
        } else if (data.getDbchgCMDCode().equalsIgnoreCase(ED_EQPT)) {
            if (type == 1) {
                this.modifyCurSubrack(aid);
            } else if (type == 2 && TESysManagerConstants.SYS_SINGLE_STATUS == TESysManagerBean.getInstance().getSysStauts()) {
                this.modifyBoard(aid);
            } else if (type == 3) {
                this.modifyDynPort(aid);
            }
        }
    }

    private void modifyDynPort(String aid) {
    }

    private void modifyBoard(String aid) {
        this.queryBoard(aid);
        TENE ne = TENEListUtils.getNEObj(this.neID);
        int slotID = TETL1CommonUtil.getNMSlotStr(aid, this.neID);
        TEBoard board = ne.getBoard(slotID);
        int boardType = -1;
        if (board != null) {
            boardType = board.getBoardType();
        }
        TETL1QueryLogicPort.queryExistLogicPort(this.neID, slotID, boardType);
        TETL1QueryLogicPort.queryRealMod2(this.neID, slotID);
    }

    protected void modifyCurSubrack(String aid) {
    }

    private void delDynPort(String aid) {
        String[] aids = TETL1CommonUtil.parseAID(aid, this.neID);
        int slotID = TETL1CommonUtil.getNMSlotStr(aid, this.neID);
        TEConfigurationDataMgr.getInstance().delLogicPort(this.neID, slotID, Integer.parseInt(aids[3]));
    }

    private void delBoard(String aid) {
        TENE ne = TENEListUtils.getNEObj(this.neID);
        int slotid = TETL1CommonUtil.getNMSlotStr(aid, this.neID);
        Vector boardList = ne.getBoardList();
        TEBoard board = ne.getBoard(slotid);
        int boradType = -1;
        TEBoard phyBoard = ne.getPhyBoard(slotid);
        if (board != null) {
            boradType = board.getBoardType();
            boardList.remove(board);
            if (phyBoard != null && board.getBoardType() == phyBoard.getBoardType() && board.getState() == 16) {
                ne.getPhyBoardList().remove(board);
            }
        }
        ne.removeAlarm(slotid, 0);
        ne.removeLogicPortBySlot(this.neID, slotid, boradType);
        ne.setLastBoardModifyTime();
        ne.setBoardList(boardList);
        this.queryBoard(aid);
    }

    private void queryDynPort(String aid) {
        String[] aids = TETL1CommonUtil.parseAID(aid, this.neID);
        int slotID = TETL1CommonUtil.getNMSlotStr(aid, this.neID);
        TEConfigurationDataMgr.getInstance().addLogicPort(this.neID, slotID, Integer.parseInt(aids[3]));
    }

    private void queryBoard(String aid) {
        if (TESysManagerBean.getInstance().isIntegratedStatus()) {
            return;
        }
        TENEImplInterface_TL1NE neImpl = (TENEImplInterface_TL1NE)this.getNeImplInterface();
        ArrayList<TL1Operation> operList = new ArrayList<TL1Operation>();
        try {
            TL1Definitions definitions = TECreateObjectFactory.parseTL1DesFile(null, neImpl.getTL1_DES_PATH());
            TL1Operation queryOper = definitions.getTL1Operation("RTRV-EQPT");
            InMsg input = queryOper.getInMsg();
            input.getPart("AID").setValue(aid);
            operList.add(queryOper);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("tl1 describe parse error", (Throwable)e);
        }
        OperationResult result = TETL1NECommMgr.getInstance().sendCommand(this.neID, operList, 30);
        if (result.retCode != 0) {
            TELogFactory.getNormalLogger().error("Query board fail, the errorCode is" + result.retCode);
            TENE ne = TENEListUtils.getNEObj(this.neID);
            int slotid = TETL1CommonUtil.getNMSlotStr(aid, this.neID);
            TEBoard board = ne.getBoard(slotid);
            if (board != null) {
                board.setState(7);
            }
            return;
        }
        this.setBoardToMemory(operList);
    }

    private int getAIDType(String[] aids) {
        int type = 0;
        type = aids[0].equals("SHELF") ? 1 : (!aids[3].equals("-1") ? 3 : 2);
        return type;
    }

    protected void delCurSubrack(String aid) {
    }

    protected void queryCurSubrack(String aid) {
    }

    public void queryPortIndex() {
        TENEImplInterface_TL1NE neImpl = (TENEImplInterface_TL1NE)this.getNeImplInterface();
        TEConfigurationDataMgr.getInstance().removePortIndex(this.neID);
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        try {
            Definitions definitions = TECreateObjectFactory.parseQxDesFile();
            Operation oper = definitions.getOperation("NSCMD_ION_LIM_GET_TE_BOARDPORT");
            if (null == oper) {
                return;
            }
            operationList.add(oper);
            oper = definitions.getOperation("NSCMD_ION_NBASE_GET_NODE_ID");
            operationList.add(oper);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TETL1NE.queryPortIndex() fail!", (Throwable)e);
        }
        OperationResult result = TETL1NECommMgr.getInstance().sendCommand(this.neID, operationList, 20);
        if (result.retCode != 0) {
            return;
        }
        long index = -1L;
        int slotid = 1;
        int portid = -1;
        int signalType = -1;
        int linkLevel = -1;
        TEPortIndex portIndex = null;
        Operation operation = (Operation)operationList.get(0);
        for (Output output : operation.getOutput()) {
            if (!output.getFault()[0].getCode().equals("0")) continue;
            index = Long.parseLong(output.getPartValue("index"));
            slotid = Integer.parseInt(output.getPartValue("slotid"));
            portid = Integer.parseInt(output.getPartValue("port"));
            signalType = Integer.parseInt(output.getPartValue("signaltype"));
            linkLevel = Integer.parseInt(output.getPartValue("linklevel"));
            portIndex = new TEPortIndex(index, slotid, portid, signalType, linkLevel);
            TEConfigurationDataMgr.getInstance().addPortIndex(this.neID, index, portIndex);
        }
        operation = (Operation)operationList.get(1);
        Output output = operation.getOutput(0);
        if (output.getFault(0).getCode().equals("0")) {
            neImpl.setNodeID(output.getPartValue("nodeID"));
        }
    }

    @Override
    public int logout() {
        ArrayList<TL1Operation> operationList = new ArrayList<TL1Operation>();
        int retCode = -1;
        try {
            TL1Definitions definitions = TECreateObjectFactory.parseTL1DesFile();
            TL1Operation oper = definitions.getTL1Operation("CANC-USER");
            oper.getInMsg().getStagBlock().getAID().getPart(0).setValue(this.getCurUser());
            operationList.add(oper);
            OperationResult result = TETL1NECommMgr.getInstance().sendCommand(this.neID, operationList, 20);
            if (result.retCode == 1090650120) {
                this.afterLogoutNE();
                return 0;
            }
            oper = (TL1Operation)operationList.get(0);
            if (oper.getOutMsgCount() == 0) {
                this.setLogStatus(0);
                return 0;
            }
            OutMsg outMsg = oper.getOutMsg(0);
            retCode = outMsg.getFault().getCompletionCode();
            if (0 != retCode && "LOGIN NOT ACTIVE".equalsIgnoreCase(outMsg.getFault().getErrDesc())) {
                TELogFactory.getNormalLogger().info("logout ne fail,retCODE:" + retCode);
                return 1092091911;
            }
            this.afterLogoutNE();
            this.setLogStatus(retCode != 0 ? 1 : 0);
            this.setCurTopLevelAlm(-1);
            TELogFactory.getNormalLogger().info("logout ne successed");
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().info("logout ne failed", (Throwable)e);
        }
        return retCode;
    }

    @Override
    public Vector getAlarmList() {
        TENEImplInterface_TL1NE neImpl = (TENEImplInterface_TL1NE)this.getNeImplInterface();
        return neImpl.getAlarmList();
    }

    @Override
    public Vector getBoardList() {
        TENEImplInterface_TL1NE neImpl = (TENEImplInterface_TL1NE)this.getNeImplInterface();
        return neImpl.getBoardList();
    }

    @Override
    public Vector getPhyBoardList() {
        TENEImplInterface_TL1NE neImpl = (TENEImplInterface_TL1NE)this.getNeImplInterface();
        return neImpl.getPhyBoardList();
    }

    @Override
    public Vector getThrshData() {
        TENEImplInterface_TL1NE neImpl = (TENEImplInterface_TL1NE)this.getNeImplInterface();
        return neImpl.getThrshDataList();
    }

    public void setThrshData(Vector _thrshDataList) {
        TENEImplInterface_TL1NE neImpl = (TENEImplInterface_TL1NE)this.getNeImplInterface();
        neImpl.setThrshDataList(_thrshDataList);
    }

    public void setDeviceType(int nType) {
        String deviceTypeStr = TEEquipmentDescription.getInstance().getDeviceTypeName(nType);
        TENEImplInterface_TL1NE neImpl = (TENEImplInterface_TL1NE)this.getNeImplInterface();
        neImpl.setDeviceType(deviceTypeStr);
    }

    public int closeConnection() {
        TENEImplInterface_TL1NE neImpl = (TENEImplInterface_TL1NE)this.getNeImplInterface();
        return TETL1NECommMgr.getInstance().closeConnect((long)this.neID, new Integer(neImpl.getPort()).intValue(), neImpl.getNeGWAddress(), neImpl.getNeGWType());
    }

    protected void registerEvent() {
        try {
            TL1Definitions definitions = TECreateObjectFactory.parseTL1DesFile();
            TL1Operation oper = definitions.getTL1Operation("NSEVENT_SM_LOGIN");
            if (null != oper) {
                TETL1NECommMgr.getInstance().registerListener(oper, (TL1NoticeHandler)this.loginNoticeHandler);
            }
            if (null != (oper = definitions.getTL1Operation("REPT_LOGOFF"))) {
                TETL1NECommMgr.getInstance().registerListener(oper, (TL1NoticeHandler)this.logoutNoticeHandler);
            }
            if (null != (oper = definitions.getTL1Operation("REPT_ALM_MOD2"))) {
                TETL1CommonUtil.registerAlmMod2Listener(oper, this.almNoticeHandler);
            }
            if (null != (oper = definitions.getTL1Operation("REPT_ALM_ENV"))) {
                TETL1NECommMgr.getInstance().registerListener(oper, (TL1NoticeHandler)this.almNoticeHandler);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("parse file fail", (Throwable)e);
        }
    }

    protected void unregisterEvent() {
        TL1Operation oper = null;
        try {
            TL1Definitions definitions = TECreateObjectFactory.parseTL1DesFile();
            oper = definitions.getTL1Operation("REPT_ALM_MOD2");
            if (null != oper) {
                TETL1CommonUtil.unregisterAlmMod2Listener(oper, this.almNoticeHandler);
            }
            if (null != (oper = definitions.getTL1Operation("NSEVENT_SM_LOGIN"))) {
                TETL1NECommMgr.getInstance().unregisterListener(oper, (TL1NoticeHandler)this.loginNoticeHandler);
            }
            if (null != (oper = definitions.getTL1Operation("NSEVENT_SM_LOGOUT_V01"))) {
                TETL1NECommMgr.getInstance().unregisterListener(oper, (TL1NoticeHandler)this.logoutNoticeHandler);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("parse file fail", (Throwable)e);
        }
    }

    @Override
    public void afterLogoutNE() {
        this.unregisterEvent();
        if (this.alarmList.size() > 0) {
            this.alarmList.clear();
        }
        this.cancelTimeTask();
        this.alarmAnalyse.setExigenceAlmCount(0);
        this.alarmAnalyse.setPrimaryAlmCount(0);
        this.alarmAnalyse.setSecondaryAlmCount(0);
        this.alarmAnalyse.setPromptAlmCount(0);
        this.alarmAnalyse.setNotReportAlmCount(0);
        this.alarmAnalyse.setTopAlmLevel(-1);
        this.cancelNESysTimeTask();
    }

    private void queryLogicPort() {
        TENEImplInterface_TL1NE neImpl = (TENEImplInterface_TL1NE)this.getNeImplInterface();
        Vector boardList = neImpl.getBoardList();
        int size = boardList.size();
        for (int i = 0; i < size; ++i) {
            TEBoard board1 = (TEBoard)boardList.get(i);
            int boardType = board1.getBoardType();
            if (!TEConfigurationDataMgr.getInstance().isDynPortBoardType(this.neID, boardType)) continue;
            int slotID = board1.getSlotID();
            TELoginNEManager.getInstance().getChanel().putRequest(new TETL1QueryLogicPortRunnable(this.neID, slotID, boardType));
        }
    }

    public ArrayList queryTL1Alarm() {
        TENEImplInterface_TL1NE neImpl = (TENEImplInterface_TL1NE)this.getNeImplInterface();
        Vector alarmList = neImpl.getAlarmList();
        if (alarmList != null && alarmList.size() > 0) {
            alarmList.clear();
        }
        ArrayList<TL1Operation> operationList = new ArrayList<TL1Operation>();
        ArrayList<TL1Operation> operLogList = new ArrayList<TL1Operation>();
        try {
            TL1Definitions definitions = TECreateObjectFactory.parseTL1DesFile();
            TL1Operation oper = definitions.getTL1Operation("RTRV-COND-ALL");
            TL1Operation operEnv = definitions.getTL1Operation("RTRV-ALM-ENV");
            operationList.add(oper);
            operationList.add(operEnv);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TETL1NE.queryTL1Alarm() fail!", (Throwable)e);
        }
        OperationResult result = TETL1NECommMgr.getInstance().sendCommand(this.neID, operationList, 40);
        if (result.retCode != 0) {
            neImpl.setQueryAlarmSucc(false);
            return operationList;
        }
        neImpl.setQueryAlarmSucc(true);
        TL1Operation tl1oper = (TL1Operation)operationList.get(0);
        OutMsg[] output = tl1oper.getOutMsg();
        String slotAid = "";
        String slotAidType = "";
        String alarmLevel = "";
        String alarmName = "";
        String alarmSRVEFF = "";
        String alarmDate = "";
        String alarmTime = "";
        String location = "";
        String direction = "";
        String alarmCause = "";
        String alarmSN = "";
        String alarmReason = "";
        int alarmType = 0;
        TEAlarmData almData = null;
        int fbType = 0;
        boolean flag = false;
        Part part = null;
        int len = output.length;
        for (int j = 0; j < len; ++j) {
            int almdirection;
            HashMap partMap = TETL1CommonUtil.getOutMsgPart(output[j]);
            part = (Part)partMap.get("aid");
            slotAid = TETL1CommonUtil.isNull(part.getValue());
            part = (Part)partMap.get("aidtype");
            slotAidType = TETL1CommonUtil.isNull(part.getValue());
            part = (Part)partMap.get("ntfcncde");
            alarmLevel = TETL1CommonUtil.isNull(part.getValue());
            part = (Part)partMap.get("typereq");
            alarmName = TETL1CommonUtil.isNull(part.getValue());
            part = (Part)partMap.get("srveff");
            alarmSRVEFF = TETL1CommonUtil.isNull(part.getValue());
            part = (Part)partMap.get("ocrdat");
            alarmDate = TETL1CommonUtil.isNull(part.getValue());
            part = (Part)partMap.get("ocrtm");
            alarmTime = TETL1CommonUtil.isNull(part.getValue());
            part = (Part)partMap.get("locn");
            location = TETL1CommonUtil.isNull(part.getValue());
            part = (Part)partMap.get("dirn");
            direction = TETL1CommonUtil.isNull(part.getValue());
            part = (Part)partMap.get("conddesc");
            alarmCause = TETL1CommonUtil.isNull(part.getValue());
            part = (Part)partMap.get("SN");
            alarmSN = TETL1CommonUtil.isNull(part.getValue());
            int almlocation = TETL1FaultUtil.getTL1AlarmLocation(location);
            almData = TETL1FaultUtil.getAlarmDataFromStatic(slotAidType, almlocation, almdirection = TETL1FaultUtil.getTL1AlarmDirection(direction), alarmName);
            if (null == almData) continue;
            alarmReason = almData.getAeReasion();
            alarmType = almData.getAeType();
            fbType = almData.getAIDType();
            TETL1Alarm alarm = new TETL1Alarm(slotAid, slotAidType, alarmName, alarmLevel, alarmSRVEFF, alarmDate, alarmTime, location, direction, alarmSN, alarmCause, alarmReason, alarmType, fbType, this.neID);
            TEConfigurationDataMgr.getInstance().setNEType(1);
            TETL1Alarm.parseAlarmParam(alarm, this.neID);
            if (alarm.getAlarmSN().equals("-1")) continue;
            TETL1Alarm tmpAlm = null;
            int size2 = alarmList.size();
            for (int n = 0; n < size2; ++n) {
                tmpAlm = (TETL1Alarm)alarmList.get(n);
                if (!tmpAlm.getAlarmSN().equals(alarm.getAlarmSN())) continue;
                flag = true;
                break;
            }
            if (flag) continue;
            alarmList.add(alarm);
        }
        operLogList.add((TL1Operation)tl1oper.clone());
        this.parseEnvAlarmData((TL1Operation)operationList.get(1), operLogList);
        return operLogList;
    }

    private void parseEnvAlarmData(TL1Operation operation, ArrayList operLogList) {
        TENEImplInterface_TL1NE neImpl = (TENEImplInterface_TL1NE)this.getNeImplInterface();
        Vector alarmList = neImpl.getAlarmList();
        OutMsg[] output = operation.getOutMsg();
        String slotAid = "";
        String slotAidType = "";
        String alarmLevel = "";
        String alarmName = "";
        String alarmSRVEFF = "";
        String alarmDate = "";
        String alarmTime = "";
        String almmsg = "";
        String alarmSN = "";
        String alarmReason = "";
        int alarmType = 0;
        TEAlarmData almData = null;
        int fbType = 0;
        boolean flag = false;
        Part part = null;
        int len = output.length;
        for (int j = 0; j < len; ++j) {
            HashMap partMap = TETL1CommonUtil.getOutMsgPart(output[j]);
            if (partMap.size() <= 0) continue;
            part = (Part)partMap.get("aid");
            slotAid = TETL1CommonUtil.isNull(part.getValue());
            part = (Part)partMap.get("ntfcncde");
            alarmLevel = TETL1CommonUtil.isNull(part.getValue());
            part = (Part)partMap.get("almtype");
            alarmName = TETL1CommonUtil.isNull(part.getValue());
            part = (Part)partMap.get("ocrdat");
            alarmDate = TETL1CommonUtil.isNull(part.getValue());
            part = (Part)partMap.get("ocrtm");
            alarmTime = TETL1CommonUtil.isNull(part.getValue());
            part = (Part)partMap.get("almmsg");
            almmsg = TETL1CommonUtil.isNull(part.getValue());
            part = (Part)partMap.get("SN");
            alarmSN = TETL1CommonUtil.isNull(part.getValue());
            almData = TETL1FaultUtil.getAlarmDataFromStatic("ENV", 1, 0, alarmName);
            if (null == almData) continue;
            alarmReason = almData.getAeReasion();
            alarmType = almData.getAeType();
            fbType = almData.getAIDType();
            TETL1Alarm alarm = new TETL1Alarm(slotAid, slotAidType, alarmName, alarmLevel, alarmSRVEFF, alarmDate, alarmTime, "NEND", "", alarmSN, almmsg, alarmReason, alarmType, fbType, this.neID);
            TEConfigurationDataMgr.getInstance().setNEType(1);
            TETL1Alarm.parseENVAlarmParam(alarm, this.neID);
            if (alarm.getAlarmSN().equals("-1")) continue;
            TETL1Alarm tmpAlm = null;
            int size2 = alarmList.size();
            for (int n = 0; n < size2; ++n) {
                tmpAlm = (TETL1Alarm)alarmList.get(n);
                if (!tmpAlm.getAlarmSN().equals(alarm.getAlarmSN())) continue;
                flag = true;
                break;
            }
            if (flag) continue;
            alarmList.add(alarm);
        }
        operLogList.add((TL1Operation)operation.clone());
    }

    public TENEAlarmAnalyse alarmAnalyse(int slotID) {
        TENEImplInterface_TL1NE neImpl = (TENEImplInterface_TL1NE)this.getNeImplInterface();
        Vector alarmList = neImpl.getAlarmList();
        TENEAlarmAnalyse almAnalyse = null;
        if (slotID == -1) {
            almAnalyse = this.almAnalyse(alarmList);
        } else {
            Vector<TETL1Alarm> slotAlmList = new Vector<TETL1Alarm>();
            int size = alarmList.size();
            for (int i = 0; i < size; ++i) {
                TETL1Alarm alarm = (TETL1Alarm)alarmList.get(i);
                if (alarm.getSlotID() != slotID) continue;
                slotAlmList.add(alarm);
            }
            almAnalyse = this.almAnalyse(slotAlmList);
        }
        return almAnalyse;
    }

    public TENEAlarmAnalyse almAnalyse(Vector alarmList) {
        TENEAlarmAnalyse almAnalyse = new TENEAlarmAnalyse();
        int exigenceAlmCount = 0;
        int primaryAlmCount = 0;
        int secondaryAlmCount = 0;
        int promptAlmCount = 0;
        int notReportAlmCount = 0;
        int topAlmLevel = -1;
        int size = alarmList.size();
        block7: for (int i = 0; i < size; ++i) {
            TETL1Alarm tempAlm = (TETL1Alarm)alarmList.get(i);
            int level = TETL1FaultUtil.getTL1AlarmLevel(tempAlm.getAlarmLevel());
            switch (level) {
                case 1: {
                    ++exigenceAlmCount;
                    continue block7;
                }
                case 2: {
                    ++primaryAlmCount;
                    continue block7;
                }
                case 3: {
                    ++secondaryAlmCount;
                    continue block7;
                }
                case 4: {
                    ++promptAlmCount;
                    continue block7;
                }
                case 5: {
                    ++notReportAlmCount;
                }
            }
        }
        topAlmLevel = exigenceAlmCount != 0 ? 1 : (primaryAlmCount != 0 ? 2 : (secondaryAlmCount != 0 ? 3 : (promptAlmCount != 0 ? 4 : (notReportAlmCount != 0 ? 5 : 0))));
        almAnalyse.setExigenceAlmCount(exigenceAlmCount);
        almAnalyse.setPrimaryAlmCount(primaryAlmCount);
        almAnalyse.setSecondaryAlmCount(secondaryAlmCount);
        almAnalyse.setPromptAlmCount(promptAlmCount);
        almAnalyse.setNotReportAlmCount(notReportAlmCount);
        almAnalyse.setTopAlmLevel(topAlmLevel);
        return almAnalyse;
    }

    @Override
    public void removeAlarm(int slotID, int portID) {
        for (int j = this.alarmList.size() - 1; j >= 0; --j) {
            TETL1Alarm alarm = (TETL1Alarm)this.alarmList.get(j);
            if (alarm.getSlotID() != slotID || 0 != portID) continue;
            this.alarmList.remove(j);
        }
    }

    @Override
    public int[] deleteAlm(int[] evtSerialNums) {
        return new int[10];
    }

    @Override
    public synchronized Vector getClonedBoardList() {
        TENEImplInterface_TL1NE neImpl = (TENEImplInterface_TL1NE)this.getNeImplInterface();
        Vector boardList = neImpl.getBoardList();
        Vector<Object> clonedBoardList = new Vector<Object>();
        for (int i = 0; i < boardList.size(); ++i) {
            clonedBoardList.add(((TEBoard)boardList.get(i)).clone());
        }
        return clonedBoardList;
    }

    @Override
    public synchronized void setBoardList(Vector newBoardList) {
        TENEImplInterface_TL1NE neImpl = (TENEImplInterface_TL1NE)this.getNeImplInterface();
        neImpl.setBoardList(newBoardList);
    }

    @Override
    public synchronized Vector getClonedPhyBoardList() {
        TENEImplInterface_TL1NE neImpl = (TENEImplInterface_TL1NE)this.getNeImplInterface();
        Vector phyBoardList = neImpl.getPhyBoardList();
        Vector<Object> clonedBoardList = new Vector<Object>();
        for (int i = 0; i < phyBoardList.size(); ++i) {
            clonedBoardList.add(((TEBoard)phyBoardList.get(i)).clone());
        }
        return clonedBoardList;
    }

    @Override
    public synchronized void setPhyBoardList(Vector newBoardList) {
        TENEImplInterface_TL1NE neImpl = (TENEImplInterface_TL1NE)this.getNeImplInterface();
        neImpl.setPhyBoardList(newBoardList);
    }

    @Override
    public TEBoard getPhyBoard(int slotID) {
        if (TESysManagerConstants.SYS_SINGLE_STATUS == TESysManagerBean.getInstance().getSysStauts()) {
            TENEImplInterface_TL1NE neImpl = (TENEImplInterface_TL1NE)this.getNeImplInterface();
            Vector phyBoardList = neImpl.getPhyBoardList();
            if (phyBoardList != null && phyBoardList.size() > 0) {
                int size = phyBoardList.size();
                for (int i = 0; i < size; ++i) {
                    TEBoard board = (TEBoard)phyBoardList.get(i);
                    if (board.getSlotID() != slotID) continue;
                    return board;
                }
            }
        } else {
            return this.querySingleSlotBoard(slotID);
        }
        return null;
    }

    private TEBoard querySingleSlotBoard(int slotID) {
        ArrayList<Object> operationList = new ArrayList<Object>();
        TL1Operation oper1 = null;
        try {
            TL1Definitions definitions = TECreateObjectFactory.parseTL1DesFile();
            oper1 = definitions.getTL1Operation("RTRV-EQPT");
            InMsg input = oper1.getInMsg();
            String neSlot = TETL1CommonUtil.slotIDNMToNEShelfIDSlotID(this.neID, slotID);
            StringBuffer sb = new StringBuffer("SLOT-");
            sb.append(neSlot);
            input.getPart("AID").setValue(sb.toString());
            operationList.add(oper1.clone());
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("parse file fail", (Throwable)e);
        }
        OperationResult result = TETL1NECommMgr.getInstance().sendCommand(this.neID, operationList, 40);
        if (result.retCode != 0) {
            TELogFactory.getNormalLogger().info("query single slot board fail,the errorCode is " + result.retCode);
            return null;
        }
        OutMsg[] outMsgs = ((TL1Operation)operationList.get(0)).getOutMsg();
        String boardName = "";
        int boardType = -1;
        TEBoard board = null;
        String sst = "";
        String pst = "";
        if (outMsgs.length == 0) {
            return null;
        }
        int slotid = -1;
        if (0 == outMsgs[0].getFault().getCompletionCode()) {
            HashMap dataBlock = TETL1CommonUtil.getOutMsgPart(outMsgs[0]);
            String[] tempSlots = ((Part)dataBlock.get("slotID")).getValue().split("SLOT-");
            if (2 == tempSlots.length) {
                slotid = TETL1CommonUtil.neShelfIDSlotIDToSlotIDNM(tempSlots[1]);
            }
            pst = ((Part)dataBlock.get("PST")).getValue();
            sst = ((Part)dataBlock.get("SST")).getValue();
            int state = TEBoardState.setStateInPSTANDSST(pst, sst);
            TEBoardNameConvertUtil boardNameConvertUtil = TEBoardNameConvertUtil.getInstance();
            boardName = ((Part)dataBlock.get("ACTTYPE")).getValue();
            if (null != boardName && !"".equals(boardName)) {
                String convertBoardName = boardNameConvertUtil.nameToNM(boardName);
                boardType = TEConfigurationDataMgr.getInstance().getBoardType(this.getNEType(), boardName, convertBoardName);
                board = new TEBoard(this.neID, slotid, boardType, boardName);
                if (sst != null && sst.indexOf("STBYH") != -1) {
                    board.setBoardPG(1);
                }
                board.setState(state);
                return board;
            }
        }
        return null;
    }

    @Override
    public void setCurTopLevelAlm(int almLevel) {
        this.alarmAnalyse.setTopAlmLevel(almLevel);
    }

    @Override
    public int getCurTopLevelAlm(int slotID) {
        if (this.getNeImplInterface().getLogStatus() == 1) {
            this.getNeImplInterface().setAlarmAnalyse(this.alarmAnalyse(slotID));
            return this.getNeImplInterface().getAlarmAnalyse().getTopAlmLevel();
        }
        return this.alarmAnalyse.getTopAlmLevel();
    }

    @Override
    public TENEAlarmAnalyse getCurTopLevelAlmOnSubrack(int subrackID) {
        return this.alarmAnalyseOnSubrack(subrackID);
    }

    private TENEAlarmAnalyse alarmAnalyseOnSubrack(int subrack) {
        TENEImplInterface_TL1NE neImplInterface = (TENEImplInterface_TL1NE)this.getNeImplInterface();
        Vector alarmList = neImplInterface.getAlarmList();
        Vector<TETL1Alarm> subrackAlmList = new Vector<TETL1Alarm>();
        int size = alarmList.size();
        for (int i = 0; i < size; ++i) {
            TETL1Alarm alarm = (TETL1Alarm)alarmList.get(i);
            int subrackId = TEBoardUtil.getSubrackIDFromSlot(this.neID, alarm.getSlotID());
            if (subrackId != subrack) continue;
            subrackAlmList.add(alarm);
        }
        TENEAlarmAnalyse almAnalyse = this.almAnalyse(subrackAlmList);
        return almAnalyse;
    }

    public boolean isThisSlotAlm(int slotID) {
        TEBoard board = null;
        Vector boardList = this.getBoardList();
        int boardListSize = boardList.size();
        for (int k = 0; k < boardListSize; ++k) {
            board = (TEBoard)boardList.get(k);
            if (slotID != board.getSlotID()) continue;
            return true;
        }
        return false;
    }

    public void setTimeTask() {
        if (!this.getNeImplInterface().isSchedule()) {
            TELoginNEManager.getInstance().registerNe(this, 3600000, 3600000);
            TELogFactory.getNormalLogger().info("NEname: " + this.getNEName() + " start boardTimerTask ");
            this.getNeImplInterface().setSchedule(true);
        }
    }

    public void cancelTimeTask() {
        TELoginNEManager.getInstance().removeNe(this);
        this.getNeImplInterface().setSchedule(false);
    }

    public int getLoginCode() {
        TENEImplInterface_TL1NE neImpl = (TENEImplInterface_TL1NE)this.getNeImplInterface();
        return neImpl.getLoginCode();
    }

    public void setLoginCode(int _loginCode) {
        TENEImplInterface_TL1NE neImpl = (TENEImplInterface_TL1NE)this.getNeImplInterface();
        neImpl.setLoginCode(_loginCode);
    }

    @Override
    public Vector getCpThrshDataList() {
        TENEImplInterface_TL1NE neImpl = (TENEImplInterface_TL1NE)this.getNeImplInterface();
        return neImpl.getCpThrshDataList();
    }

    public void setCpThrshDataList(Vector cpThrshDataList) {
        TENEImplInterface_TL1NE neImpl = (TENEImplInterface_TL1NE)this.getNeImplInterface();
        neImpl.setCpThrshDataList(cpThrshDataList);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TENE)) {
            return false;
        }
        TENE ne = (TENE)obj;
        return ne.getNEID() == this.neID;
    }

    @Override
    public int hashCode() {
        return this.neID;
    }

    @Override
    public String toString() {
        return "neid:" + this.neID + ",nename:" + this.getNeImplInterface().getNeName();
    }

    @Override
    public synchronized Vector getSubrackList() {
        TENEImplInterface_TL1NE neImpl = (TENEImplInterface_TL1NE)this.getNeImplInterface();
        return neImpl.getSubrackList();
    }

    @Override
    public synchronized Vector getClonedSubrackList() {
        TENEImplInterface_TL1NE neImpl = (TENEImplInterface_TL1NE)this.getNeImplInterface();
        Vector subrackList = neImpl.getSubrackList();
        Vector<Object> clonedSubrackList = new Vector<Object>();
        for (int i = 0; i < subrackList.size(); ++i) {
            clonedSubrackList.add(((TESubrack)subrackList.get(i)).clone());
        }
        return clonedSubrackList;
    }

    @Override
    public synchronized void setSubrackList(Vector newSubrackList) {
        TENEImplInterface_TL1NE neImpl = (TENEImplInterface_TL1NE)this.getNeImplInterface();
        neImpl.setSubrackList(newSubrackList);
    }

    public synchronized void addSubrackList(TESubrack subrack) {
        TENEImplInterface_TL1NE neImpl = (TENEImplInterface_TL1NE)this.getNeImplInterface();
        Vector subrackList = neImpl.getSubrackList();
        subrackList.add(subrack);
    }

    public boolean isExistSubrack(String subrackID) {
        TENEImplInterface_TL1NE neImpl = (TENEImplInterface_TL1NE)this.getNeImplInterface();
        Vector subrackList = neImpl.getSubrackList();
        boolean flag = true;
        int n = subrackList.size();
        for (int i = 0; i < n; ++i) {
            TESubrack tempSubrack = (TESubrack)subrackList.get(i);
            if (!tempSubrack.getSubrackID().equals(subrackID)) continue;
            flag = false;
        }
        return flag;
    }

    @Override
    public void querySubrack() {
    }

    public String getErrorCode() {
        TENEImplInterface_TL1NE neImpl = (TENEImplInterface_TL1NE)this.getNeImplInterface();
        return neImpl.getErrorCode();
    }

    public void setErrorCode(String errorCode) {
        TENEImplInterface_TL1NE neImpl = (TENEImplInterface_TL1NE)this.getNeImplInterface();
        neImpl.setErrorCode(errorCode);
    }

    public String getErrorDes() {
        TENEImplInterface_TL1NE neImpl = (TENEImplInterface_TL1NE)this.getNeImplInterface();
        return neImpl.getErrorDes();
    }

    public void setErrorDes(String errorDes) {
        TENEImplInterface_TL1NE neImpl = (TENEImplInterface_TL1NE)this.getNeImplInterface();
        neImpl.setErrorDes(errorDes);
    }

    public Hashtable getAlarmAttrDataMap() {
        TENEImplInterface_TL1NE neImpl = (TENEImplInterface_TL1NE)this.getNeImplInterface();
        return neImpl.getAlarmAttrDataMap();
    }

    public void setAlarmAttrDataMap(Hashtable alarmAttrDataMap) {
        TENEImplInterface_TL1NE neImpl = (TENEImplInterface_TL1NE)this.getNeImplInterface();
        neImpl.setAlarmAttrDataMap(alarmAttrDataMap);
    }

    public Hashtable getPfmThrsDataMap() {
        TENEImplInterface_TL1NE neImpl = (TENEImplInterface_TL1NE)this.getNeImplInterface();
        return neImpl.getPfmThrsDataMap();
    }

    public void setPfmThrsDataMap(Hashtable pfmThrsDataMap) {
        TENEImplInterface_TL1NE neImpl = (TENEImplInterface_TL1NE)this.getNeImplInterface();
        neImpl.setPfmThrsDataMap(pfmThrsDataMap);
    }

    public boolean isDstEnable() {
        TENEImplInterface_TL1NE neImpl = (TENEImplInterface_TL1NE)this.getNeImplInterface();
        return neImpl.isBDstEnable();
    }

    public void setDstEnable(boolean dstEnable) {
        TENEImplInterface_TL1NE neImpl = (TENEImplInterface_TL1NE)this.getNeImplInterface();
        neImpl.setBDstEnable(dstEnable);
    }

    public int getDstOffset() {
        TENEImplInterface_TL1NE neImpl = (TENEImplInterface_TL1NE)this.getNeImplInterface();
        return neImpl.getDstOffset();
    }

    public void setDstOffset(int dstOffset) {
        TENEImplInterface_TL1NE neImpl = (TENEImplInterface_TL1NE)this.getNeImplInterface();
        neImpl.setDstOffset(dstOffset);
    }

    public void setStartAsonFlag(String startAsonFlag) {
        this.startAsonFlag = startAsonFlag;
    }

    public String getStartAsonFlag() {
        return this.startAsonFlag;
    }

    public boolean isQueryAlarmSucc() {
        TENEImplInterface_TL1NE neImpl = (TENEImplInterface_TL1NE)this.getNeImplInterface();
        return neImpl.isQueryAlarmSucc();
    }

    @Override
    public String getTimeZome() {
        TENEImplInterface_TL1NE neImpl = (TENEImplInterface_TL1NE)this.getNeImplInterface();
        return neImpl.getTimeZome();
    }

    @Override
    public void initInterNEDataAfterLogin() {
        TENEInterImpl_TL1NE neImpl = (TENEInterImpl_TL1NE)this.getNeImplInterface();
        neImpl.initTL1TimeZone();
        String showNEVersion = TEConvertUtil.neVersionToString(this.neImplInterface.getNeVersion());
        TELogFactory.getNormalLogger().info("initInterTL1NEDataAfterLogin,neid = " + neImpl.getNeID() + ",Set TL1 NEVersion = " + showNEVersion);
        this.neImplInterface.setShowNEVersion(showNEVersion);
        neImpl.queryNodeID();
    }
}

