/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.tl1.nemanager;

import com.huawei.nglct.common.TEParseXMLFile;
import com.huawei.nglct.nelist.TEAlarmData;
import com.huawei.nglct.nelist.TENEListConstant;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TECircuitPackDescription;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEFuncBlockDescription;
import com.huawei.nglct.nelist.model.TESDFuncBlockRecord;
import com.huawei.nglct.nelist.model.alarm.TEAlarmsdInterpreter;
import com.huawei.nglct.tl1.TEAIDAndTypeList;
import com.huawei.nglct.tl1.TEBoardSupportAlarmAID;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.util.xml.TEResourceManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TETL1FaultUtil {
    public static final int NEAR_END = 1;
    public static final int FAR_END = 2;
    public static final int NONE_DIRECTION = 0;
    public static final int RECEIVE = 1;
    public static final int TRANSMIT = 2;
    public static final int CRITICAL = 1;
    public static final int MAJOR = 2;
    public static final int MINOR = 3;
    public static final int NOT_ALARM = 4;
    public static final int NOT_REPORT = 5;
    public static final int COMMUNICATION = 1;
    public static final int SERVICE = 2;
    public static final int EQUIPMENT = 3;
    public static final int PROCESS = 4;
    public static final int SECURITY = 5;
    public static final int ENVIROMENT = 6;
    public static final String ALARM_SOURCE_FILE = "res" + File.separator + "alarmsource_" + TENEListUtils.getLanguage() + ".ini";
    private static TEAlarmsdInterpreter alarmsdInterpreter = new TEAlarmsdInterpreter();
    private static ArrayList OTUBoardList = new ArrayList();

    public static int getTL1AlarmLocation(String location) {
        if (location == null) {
            return -1;
        }
        if (location.equals("NEND")) {
            return 1;
        }
        if (location.equals("FEND")) {
            return 2;
        }
        if (location.equals("")) {
            return 0;
        }
        return -1;
    }

    public static int getTL1AlarmDirection(String direction) {
        if (direction == null) {
            return -1;
        }
        if (direction.equals("ALL") || direction.equals("") || direction.equals("NODRCN")) {
            return 0;
        }
        if (direction.equals("RCV")) {
            return 1;
        }
        if (direction.equals("TRMT")) {
            return 2;
        }
        return -1;
    }

    public static String getTL1ArarmLocationStr(int loc) {
        if (loc == 1) {
            return "NEND";
        }
        if (2 == loc) {
            return "FEND";
        }
        return "";
    }

    public static String getTL1ArarmDirectionStr(int dir) {
        if (0 == dir) {
            return "";
        }
        if (1 == dir) {
            return "RCV";
        }
        if (2 == dir) {
            return "TRMT";
        }
        return "";
    }

    public static int getTL1AlarmLevel(String level) {
        if (level == null) {
            return 0;
        }
        if (level.equals("CR")) {
            return 1;
        }
        if (level.equals("MJ")) {
            return 2;
        }
        if (level.equals("MN")) {
            return 3;
        }
        if (level.equals("NA")) {
            return 4;
        }
        if (level.equals("NR")) {
            return 5;
        }
        return 0;
    }

    public static String convertAlarmTypeToStr(int aeType2) {
        return TENEListUtils.getString("alarmType_" + aeType2, ALARM_SOURCE_FILE);
    }

    public static String converAlarmLocation(String alarmLocation) {
        if (alarmLocation == null) {
            return "-";
        }
        if (alarmLocation.equals("NEND")) {
            return TENEListUtils.getString("NEND_LOCATION", ALARM_SOURCE_FILE);
        }
        if (alarmLocation.equals("FEND")) {
            return TENEListUtils.getString("FEND_LOCATION", ALARM_SOURCE_FILE);
        }
        return "-";
    }

    public static String convertAlarmDirection(String alarmDirection) {
        if (alarmDirection == null) {
            return "-";
        }
        if (alarmDirection.equals("RCV")) {
            return TENEListUtils.getString("RCV_DIRECTION", ALARM_SOURCE_FILE);
        }
        if (alarmDirection.equals("TRMT")) {
            return TENEListUtils.getString("TRMT_DIRECTION", ALARM_SOURCE_FILE);
        }
        return "-";
    }

    public static String convertAlarmLevel(String alarmLevel2) {
        return TENEListUtils.getString("alarmLevel_" + alarmLevel2, ALARM_SOURCE_FILE);
    }

    public static String convertAlarmLevel(int alarmLevel) {
        return TENEListUtils.getString("alarmLevel_" + alarmLevel, ALARM_SOURCE_FILE);
    }

    public static Calendar strToCalendarDateTime(String alarmTime2, String alarmDate2) {
        if (alarmTime2 == null || alarmDate2 == null) {
            return null;
        }
        String[] strTime = alarmTime2.split("-");
        String[] strDate = alarmDate2.split("-");
        if (strTime.length > 2 && strDate.length > 2) {
            Calendar calendar = Calendar.getInstance();
            int hour = Integer.parseInt(strTime[0]);
            int minuter = Integer.parseInt(strTime[1]);
            int second = Integer.parseInt(strTime[2]);
            int year = Integer.parseInt(strDate[0]);
            int month = Integer.parseInt(strDate[1]);
            int day = Integer.parseInt(strDate[2]);
            calendar.set(year, month - 1, day, hour, minuter, second);
            return calendar;
        }
        return null;
    }

    public static TEAlarmData getAlarmDataFromStatic(String MOD2, int location, int direction, String AeName) {
        TEFuncBlockDescription fbDesc = TEFuncBlockDescription.getInstance();
        Object[] fbAllList = fbDesc.getFBRecord().getValues();
        int[] aidTypeArray = new int[12];
        int k = 0;
        int size = fbAllList.length;
        for (int i = 0; i < size; ++i) {
            TESDFuncBlockRecord fbRecord = (TESDFuncBlockRecord)fbAllList[i];
            if (!fbRecord.strMOD2.equals(MOD2)) continue;
            aidTypeArray[k] = fbRecord.fbType;
            ++k;
        }
        HashMap almDataMap = TENEListConstant.getInstance().getTL1AlmData();
        ArrayList<TEAlarmData> tempAlmList = new ArrayList<TEAlarmData>();
        for (Map.Entry entry : almDataMap.entrySet()) {
            TEAlarmData tmpData = (TEAlarmData)entry.getValue();
            int len = aidTypeArray.length;
            for (int i = 0; i < len; ++i) {
                if (tmpData.getAIDType() != aidTypeArray[i] || !tmpData.getAeName().equals(AeName)) continue;
                tempAlmList.add(tmpData);
            }
        }
        int size2 = tempAlmList.size();
        for (int i = 0; i < size2; ++i) {
            TEAlarmData almData = (TEAlarmData)tempAlmList.get(i);
            if (almData.getLocation() != location || almData.getDirection() != direction) continue;
            return almData;
        }
        return null;
    }

    public static TEAlarmData getAlarmDataFromStatic(int location, int direction, String AeName) {
        HashMap almDataMap = TENEListConstant.getInstance().getTL1AlmData();
        for (Map.Entry entry : almDataMap.entrySet()) {
            TEAlarmData almData = (TEAlarmData)entry.getValue();
            if (almData.getLocation() != location || almData.getDirection() != direction || !almData.getAeName().equals(AeName)) continue;
            return almData;
        }
        return null;
    }

    public static String subStringSpecial(String str) {
        String newStr = str.trim();
        return newStr.replaceAll("\\\\\"", "");
    }

    public static String getBoardStructFromAID(String fac, int neid, boolean isShowNE, String mod2Name) {
        String[] aid = TETL1CommonUtil.parseAID(fac, neid);
        int slotNMID = TETL1CommonUtil.getNMSlotStr(fac, neid);
        String showSlot = TETL1CommonUtil.getShelfSlotName(neid, slotNMID);
        int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neid, slotNMID);
        String boardName = TEConfigurationDataMgr.getInstance().getBoardTypeName(neid, boardType);
        int portID = Integer.parseInt(aid[3]);
        int pathID = Integer.parseInt(aid[4]);
        if (isShowNE) {
            StringBuffer sb = new StringBuffer();
            String neName = TEConfigurationDataMgr.getInstance().getNE(neid).getNEName();
            sb.append(neName);
            sb.append("-");
            sb.append(showSlot);
            sb.append("-");
            sb.append(boardName);
            if (portID != -1) {
                String portName = TETL1CommonUtil.getPortNameFromNEPort(aid[0], slotNMID, portID, neid);
                sb.append("-");
                sb.append(portName);
                if (!mod2Name.equals("")) {
                    sb.append("-");
                }
                sb.append(mod2Name);
            }
            if (pathID != -1) {
                sb.append(":");
                sb.append(pathID);
            }
            return sb.toString();
        }
        StringBuffer sb = new StringBuffer();
        sb.append(slotNMID);
        sb.append("-");
        sb.append(boardName);
        if (portID != -1) {
            String portName = TETL1CommonUtil.getPortNameFromNEPort(aid[0], slotNMID, portID, neid);
            sb.append("-");
            sb.append(portName);
        }
        if (pathID != -1) {
            sb.append(":");
            sb.append(pathID);
        }
        return sb.toString();
    }

    public static ArrayList constructPfmMonObj(String strMonObj) {
        ArrayList<TEBoardSupportAlarmAID> list = new ArrayList<TEBoardSupportAlarmAID>();
        for (String monObj : strMonObj.split(",")) {
            String[] objStruct = monObj.split("&");
            if (objStruct.length < 4) continue;
            int portID = Integer.parseInt(objStruct[0]);
            int pathID = Integer.parseInt(objStruct[1]);
            String mod2Name = objStruct[2];
            boolean supportTAlm = Integer.parseInt(objStruct[3]) == 1;
            TEBoardSupportAlarmAID monObjID = new TEBoardSupportAlarmAID(mod2Name, portID, pathID);
            monObjID.setSupportT_Alm(supportTAlm);
            if (monObjID.getPortID() == -2) continue;
            list.add(monObjID);
        }
        return list;
    }

    public static ArrayList getUseableModName(TEAIDAndTypeList aidAndTypeList, int neid, int slotid, int portID, int pathID) {
        String modifier;
        StringTokenizer st;
        String temp;
        ArrayList<String> list = new ArrayList<String>();
        int bdtype = TEConfigurationDataMgr.getInstance().getBoardType(neid, slotid);
        list.add("");
        String tempActMod = "";
        String tempPldMod = "";
        String tempSfpMod = "";
        if (pathID == 0 || pathID == -1) {
            tempActMod = aidAndTypeList.getMod2(neid, slotid, portID);
            tempPldMod = aidAndTypeList.getPayLoadMod2(neid, slotid, portID);
            if (!tempActMod.equals("UNEQ")) {
                tempSfpMod = aidAndTypeList.getMod2("SLOT", neid, slotid, portID);
            }
            if (TETL1FaultUtil.isClientPort(neid, slotid, portID) && tempPldMod.indexOf(temp = aidAndTypeList.getPayLoadMod2(neid, slotid, portID, 1)) == -1) {
                tempPldMod = tempPldMod + "|" + temp;
            }
        } else {
            tempActMod = aidAndTypeList.getMod2(neid, slotid, portID, pathID);
            tempPldMod = aidAndTypeList.getPayLoadMod2(neid, slotid, portID, pathID);
            if (TETL1FaultUtil.isClientPort(neid, slotid, portID) && pathID == 1 && tempPldMod.indexOf(temp = aidAndTypeList.getPayLoadMod2(neid, slotid, portID)) == -1) {
                tempPldMod = tempPldMod + "|" + temp;
            }
        }
        if (TETL1FaultUtil.isSupportPLDODU(neid, slotid, portID, pathID, aidAndTypeList)) {
            return list;
        }
        if (!tempActMod.equals("")) {
            st = new StringTokenizer(tempActMod, "|");
            if (bdtype == 60003 || bdtype == 60028 || bdtype == 1206 || bdtype == 1207 || bdtype == 60008 || bdtype == 1560 || bdtype == 1561 || bdtype == 1562) {
                if (st.countTokens() == 1) {
                    modifier = st.nextToken();
                    if (!list.contains(modifier)) {
                        list.add(modifier);
                    }
                } else {
                    while (st.hasMoreTokens()) {
                        modifier = st.nextToken();
                        if (!modifier.equals("WDM") || list.contains(modifier)) continue;
                        list.add(modifier);
                    }
                }
            } else {
                while (st.hasMoreTokens()) {
                    modifier = st.nextToken();
                    if (list.contains(modifier)) continue;
                    list.add(modifier);
                }
            }
        }
        if (!tempPldMod.equals("")) {
            StringTokenizer st1 = new StringTokenizer(tempPldMod, "|");
            while (st1.hasMoreTokens()) {
                modifier = st1.nextToken();
                if (list.contains(modifier)) continue;
                list.add(modifier);
            }
        }
        if (!tempSfpMod.equals("") && !tempActMod.equals("")) {
            st = new StringTokenizer(tempSfpMod, "|");
            while (st.hasMoreTokens()) {
                modifier = st.nextToken();
                if (list.contains(modifier)) continue;
                list.add(modifier);
            }
        }
        TETL1FaultUtil.addTcmMod2(list);
        return list;
    }

    private static boolean isSupportPLDODU(int neid, int slotid, int portID, int pathID, TEAIDAndTypeList aidAndTypeList) {
        String mod;
        int bdtype = TEConfigurationDataMgr.getInstance().getBoardType(neid, slotid);
        if (TETL1FaultUtil.isNotOTUBoard(bdtype)) {
            return false;
        }
        return TETL1FaultUtil.isOTUBoardPort(bdtype, portID) && (mod = aidAndTypeList.getMod2(neid, slotid, portID, 1)).indexOf("OTU") != -1 && (pathID == 2 || pathID == 3 || pathID == 4 || pathID == 5 || pathID == 6 || pathID == 7 || pathID == 8);
    }

    private static void addTcmMod2(ArrayList list) {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            ArrayList tcmmod;
            String tempstr = (String)list.get(i);
            if (tempstr.equals("ODU0")) {
                tcmmod = TETL1FaultUtil.getODUTCMMod2("ODU0");
                list.addAll(tcmmod);
                continue;
            }
            if (tempstr.equals("ODU1")) {
                tcmmod = TETL1FaultUtil.getODUTCMMod2("ODU1");
                list.addAll(tcmmod);
                continue;
            }
            if (tempstr.equals("ODU2")) {
                tcmmod = TETL1FaultUtil.getODUTCMMod2("ODU2");
                list.addAll(tcmmod);
                continue;
            }
            if (tempstr.equals("ODU3")) {
                tcmmod = TETL1FaultUtil.getODUTCMMod2("ODU3");
                list.addAll(tcmmod);
                continue;
            }
            if (tempstr.equals("ODU4")) {
                tcmmod = TETL1FaultUtil.getODUTCMMod2("ODU4");
                list.addAll(tcmmod);
                continue;
            }
            if (!tempstr.equals("ODU5G")) continue;
            tcmmod = TETL1FaultUtil.getODUTCMMod2("ODU5G");
            list.addAll(tcmmod);
        }
    }

    private static ArrayList getODUTCMMod2(String odu) {
        ArrayList<String> list = new ArrayList<String>(6);
        list.add(odu + "TCM1");
        list.add(odu + "TCM2");
        list.add(odu + "TCM3");
        list.add(odu + "TCM4");
        list.add(odu + "TCM5");
        list.add(odu + "TCM6");
        return list;
    }

    private static boolean isClientPort(int neid, int slotid, int portid) {
        String clnt = TETL1CommonUtil.getAIDFrefix(neid, slotid, portid);
        return clnt.equals("CLNT");
    }

    public static boolean isSupportODUTCMService(TEAIDAndTypeList aidAndTypeList, int neid, int slot, int portid) {
        int bdtype = TEConfigurationDataMgr.getInstance().getBoardType(neid, slot);
        if (TETL1FaultUtil.isNotOTUBoard(bdtype)) {
            return true;
        }
        if (TETL1FaultUtil.isOTUBoardPort(bdtype, portid)) {
            ArrayList mod = null;
            mod = bdtype == 1568 || bdtype == 2278 || bdtype == 1600 || bdtype == 1542 || bdtype == 1543 || bdtype == 2210 || bdtype == 2315 || bdtype == 2297 || bdtype == 2480 || bdtype == 2479 || bdtype == 2576 ? aidAndTypeList.getAllMod2(neid, slot, portid) : aidAndTypeList.getAllMod2(neid, slot, portid, 1);
            boolean flag = false;
            int size = mod.size();
            for (int i = 0; i < size; ++i) {
                String tmpmod = (String)mod.get(i);
                if (tmpmod.indexOf("OTU") == -1) continue;
                flag = true;
                break;
            }
            return flag;
        }
        return true;
    }

    private static boolean isOTUBoardPort(int bdtype, int portid) {
        return bdtype == 2480 || bdtype == 2479 || bdtype == 2481 || bdtype == 2482 || bdtype == 2576 || bdtype == 2370 ? portid >= 3 && portid <= 18 : portid >= 201 && portid <= 216;
    }

    private static boolean isNotOTUBoard(int _bdtype) {
        return !OTUBoardList.contains(_bdtype);
    }

    public static boolean isNotSupport52TomODU(TEAIDAndTypeList aidAndTypeList, int neid, int slot, int portid, int pathid, String currMod2) {
        int bdtype = TEConfigurationDataMgr.getInstance().getBoardType(neid, slot);
        if (bdtype != 1573) {
            return false;
        }
        if ((portid == 201 || portid == 202 || portid == 203 || portid == 204 || portid == 205 || portid == 206 || portid == 207 || portid == 208) && pathid == 2 && currMod2.equalsIgnoreCase("ODU1")) {
            return true;
        }
        if (currMod2.equals("ODU1")) {
            if (portid == 51) {
                String vclntmod = aidAndTypeList.getMod2(neid, slot, 233, 1);
                if (vclntmod.indexOf("ODU1") != -1) {
                    return true;
                }
                String mod = aidAndTypeList.getMod2(neid, slot, 201, 1);
                return mod.indexOf("OTU") == -1;
            }
            if (portid == 52) {
                String vclntmod = aidAndTypeList.getMod2(neid, slot, 234, 1);
                if (vclntmod.indexOf("ODU1") != -1) {
                    return true;
                }
                String mod = aidAndTypeList.getMod2(neid, slot, 203, 1);
                return mod.indexOf("OTU") == -1;
            }
            if (portid == 53) {
                String vclntmod = aidAndTypeList.getMod2(neid, slot, 235, 1);
                if (vclntmod.indexOf("ODU1") != -1) {
                    return true;
                }
                String mod = aidAndTypeList.getMod2(neid, slot, 205, 1);
                return mod.indexOf("OTU") == -1;
            }
            if (portid == 54) {
                String vclntmod = aidAndTypeList.getMod2(neid, slot, 236, 1);
                if (vclntmod.indexOf("ODU1") != -1) {
                    return true;
                }
                String mod = aidAndTypeList.getMod2(neid, slot, 207, 1);
                return mod.indexOf("OTU") == -1;
            }
            if (portid == 201 || portid == 202) {
                String mod = aidAndTypeList.getMod2(neid, slot, 233, 1);
                String modsrv1 = aidAndTypeList.getMod2(neid, slot, 161);
                return mod.indexOf("ODU1") != -1 || modsrv1.indexOf("ODU1") != -1;
            }
            if (portid == 203 || portid == 204) {
                String mod = aidAndTypeList.getMod2(neid, slot, 234, 1);
                String modsrv1 = aidAndTypeList.getMod2(neid, slot, 162);
                return mod.indexOf("ODU1") != -1 || modsrv1.indexOf("ODU1") != -1;
            }
            if (portid == 205 || portid == 206) {
                String mod = aidAndTypeList.getMod2(neid, slot, 235, 1);
                String modsrv1 = aidAndTypeList.getMod2(neid, slot, 163);
                return mod.indexOf("ODU1") != -1 || modsrv1.indexOf("ODU1") != -1;
            }
            if (portid == 207 || portid == 208) {
                String mod = aidAndTypeList.getMod2(neid, slot, 236, 1);
                String modsrv1 = aidAndTypeList.getMod2(neid, slot, 164);
                return mod.indexOf("ODU1") != -1 || modsrv1.indexOf("ODU1") != -1;
            }
        }
        return false;
    }

    public static void parseTL1AlarmBit(int bdType) {
        String macroName = TECircuitPackDescription.getInstance().getTypeDefineName(bdType);
        String desFileName = TEResourceManager.getPath() + "core/conf/xml/pnp/core/" + macroName + ".xml";
        Document doc = TEParseXMLFile.parseFile(desFileName);
        if (null != doc) {
            NodeList nodeList = doc.getElementsByTagName("package");
            int len = nodeList.getLength();
            for (int i = 0; i < len; ++i) {
                Node node = nodeList.item(i);
                String interperterName = node.getAttributes().getNamedItem("interpreter").getNodeValue();
                if (!interperterName.equalsIgnoreCase("alarm_interpreter")) continue;
                alarmsdInterpreter.parsePortFunction(node, true);
            }
        }
    }

    static {
        OTUBoardList.add(1185);
        OTUBoardList.add(1186);
        OTUBoardList.add(1187);
        OTUBoardList.add(1188);
        OTUBoardList.add(1189);
        OTUBoardList.add(1190);
        OTUBoardList.add(1191);
        OTUBoardList.add(1193);
        OTUBoardList.add(60034);
        OTUBoardList.add(1278);
        OTUBoardList.add(1568);
        OTUBoardList.add(2278);
        OTUBoardList.add(1600);
        OTUBoardList.add(1573);
        OTUBoardList.add(1542);
        OTUBoardList.add(1543);
        OTUBoardList.add(2109);
        OTUBoardList.add(2210);
        OTUBoardList.add(2280);
        OTUBoardList.add(2279);
        OTUBoardList.add(2315);
        OTUBoardList.add(2297);
        OTUBoardList.add(2296);
        OTUBoardList.add(2481);
        OTUBoardList.add(2482);
        OTUBoardList.add(2480);
        OTUBoardList.add(2479);
        OTUBoardList.add(2370);
        OTUBoardList.add(2576);
    }
}

