/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.tl1.nemanager;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.nemanager.TETL1FaultUtil;
import com.huawei.nglct.util.datetime.TEDateUtils;
import java.io.File;
import java.util.Calendar;

public class TETL1Alarm {
    private String slotAid = "";
    private String slotAidType = "";
    private String alarmLevel = "";
    private String alarmName = "";
    private String alarmDate = "";
    private String alarmTime = "";
    private String location = "";
    private String direction = "";
    private String almDetail = "";
    private String alarmSN = "";
    private int aeType = -1;
    private int mod2Type = -1;
    private int neID = -1;
    private Calendar startDateTime = null;
    private Calendar endTime = null;
    private String almReason = null;
    private String MonObject = "";
    private static final int INVALID_BDTYPE = -1;
    public static final String ALARM_SOURCE_FILE = "res" + File.separator + "alarmsource_" + TENEListUtils.getLanguage() + ".ini";
    private static TEConfigurationDataMgr configDataMgr = TEConfigurationDataMgr.getInstance();

    public TETL1Alarm() {
    }

    public TETL1Alarm(String slotAid, String slotAidType, String alarmName, String alarmLevel, String alarmSRVEFF, String alarmDate, String alarmTime, String location, String direction, String alarmSN, String almDetail, String almReason, int aeType, int mod2Type, int neid) {
        this.neID = neid;
        this.slotAid = slotAid;
        this.slotAidType = slotAidType;
        this.alarmName = alarmName;
        this.alarmLevel = alarmLevel;
        this.alarmDate = alarmDate;
        this.alarmTime = alarmTime;
        this.location = location;
        this.direction = direction;
        this.alarmSN = alarmSN;
        this.almDetail = almDetail;
        this.almReason = almReason;
        this.aeType = aeType;
        this.startDateTime = TEDateUtils.getTL1NMTimeFromNETime(neid, this.strToCalendarDateTime(this.alarmTime, this.alarmDate).getTimeInMillis());
        this.mod2Type = mod2Type;
    }

    private Calendar strToCalendarDateTime(String alarmTime2, String alarmDate2) {
        if (alarmTime2 == null || alarmDate2 == null) {
            return null;
        }
        String[] strTime = alarmTime2.split("-");
        String[] strDate = alarmDate2.split("-");
        if (strTime.length > 2 && strDate.length > 2) {
            Calendar calendar = Calendar.getInstance();
            int hour = Integer.parseInt(strTime[0]);
            int minuter = Integer.parseInt(strTime[1]);
            int second = Integer.parseInt(strTime[2]);
            int year = Integer.parseInt(strDate[0]);
            int month = Integer.parseInt(strDate[1]);
            int day = Integer.parseInt(strDate[2]);
            calendar.set(year, month - 1, day, hour, minuter, second);
            return calendar;
        }
        return null;
    }

    public void setEndTime(Calendar endTime) {
        this.endTime = endTime;
    }

    public Calendar getEndTime() {
        return this.endTime;
    }

    public void setAlarmName(String alarmName) {
        this.alarmName = alarmName;
    }

    public void setAlarmLevel(String alarmLevel) {
        this.alarmLevel = alarmLevel;
    }

    public void setStartTime(Calendar startDateTime) {
        this.startDateTime = startDateTime;
    }

    public void setAlmDetail(String almDetail) {
        this.almDetail = almDetail;
    }

    public void setAlmReason(String almReason) {
        this.almReason = almReason;
    }

    public String getAlarmName() {
        return this.alarmName;
    }

    public String getAlarmLevel() {
        return this.alarmLevel;
    }

    public Calendar getStartDateTime() {
        return this.startDateTime;
    }

    public String getAlmDetail() {
        return TETL1FaultUtil.subStringSpecial(this.almDetail);
    }

    public String getAlmReason() {
        String reason = "";
        int length = this.almReason.length();
        int sonet = this.almReason.indexOf("[SONET]");
        int wdm = this.almReason.indexOf("[WDM]");
        int wdmLength = wdm + "[WDM]".length() + 1;
        int sonetLength = sonet + "[SONET]".length() + 1;
        if (-1 == sonet && wdm != -1) {
            reason = this.almReason.substring(wdmLength, length);
        } else if (-1 != sonet && wdm == -1) {
            reason = this.almReason.substring(sonetLength, length);
        } else if (-1 == sonet && -1 == wdm) {
            reason = this.almReason;
        } else if (sonet != -1 && wdm != -1) {
            reason = wdm > sonet ? this.almReason.substring(wdmLength, length) : this.almReason.substring(wdmLength, sonet);
        }
        return reason;
    }

    public String getSlotAid() {
        return this.slotAid;
    }

    public String getSlotAidType() {
        return this.slotAidType;
    }

    public String getAlarmLocation() {
        return this.location;
    }

    public String getAlarmDirection() {
        return this.direction;
    }

    public int getAlarmType() {
        return this.aeType;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TETL1Alarm)) {
            return false;
        }
        TETL1Alarm alm = (TETL1Alarm)obj;
        return alm.getAlarmSN().equals(this.alarmSN);
    }

    public int hashCode() {
        return Integer.parseInt(this.alarmSN);
    }

    public String toString() {
        return "TEALarm (AID:" + this.slotAid + ")";
    }

    public String getMonObject() {
        return this.MonObject;
    }

    public void setMonObject(String monObject) {
        this.MonObject = monObject;
    }

    public static void parseENVAlarmParam(TETL1Alarm alarm, int neID) {
        String aid = alarm.getSlotAid();
        StringBuffer sb = new StringBuffer();
        if (aid == null) {
            return;
        }
        String neName = configDataMgr.getNEName(neID);
        sb.append(neName);
        sb.append("-");
        sb.append(aid);
        alarm.setMonObject(sb.toString());
    }

    public static void parseAlarmParam(TETL1Alarm alarm, int neID) {
        String aid = alarm.getSlotAid();
        StringBuffer sb = new StringBuffer();
        if (aid == null) {
            return;
        }
        String[] aidarr = TETL1CommonUtil.parseAID(aid, neID);
        String neName = configDataMgr.getNEName(neID);
        if (TETL1Alarm.isValidAid(aidarr)) {
            sb.append(neName);
            if (aid.equals("COM")) {
                sb.append("-");
                sb.append(aid);
            }
            alarm.setMonObject(sb.toString());
            return;
        }
        int slotNMID = TETL1CommonUtil.getNMSlotStr(aid, neID);
        String newSlotID = TETL1CommonUtil.getShelfSlotName(neID, slotNMID);
        int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neID, slotNMID);
        if (boardType == -1) {
            TELogFactory.getNormalLogger().info("TETL1Alarm get boardType fail! slotid=" + newSlotID);
        }
        String boardName = TEConfigurationDataMgr.getInstance().getBoardTypeName(neID, boardType);
        int portID = Integer.parseInt(aidarr[3]);
        int pathID = Integer.parseInt(aidarr[4]);
        sb.append(neName);
        sb.append("-");
        sb.append(newSlotID);
        sb.append("-");
        sb.append(boardName);
        if (portID != -1) {
            sb.append("-");
            String portName = alarm.getSlotAidType().equals("EQPT") ? TETL1CommonUtil.getPortNameFromNEPort("FAC", slotNMID, portID, neID) : TETL1CommonUtil.getPortNameFromNEPort(aidarr[0], slotNMID, portID, neID);
            sb.append(portName);
        }
        if (!alarm.getSlotAidType().equals("")) {
            sb.append("-");
            sb.append(alarm.getSlotAidType());
        }
        if (pathID != -1) {
            sb.append(":");
            sb.append(pathID);
        }
        alarm.setMonObject(sb.toString());
    }

    private static boolean isValidAid(String[] aid) {
        int len = aid.length;
        for (int i = 1; i < len; ++i) {
            if (Integer.parseInt(aid[i]) == -1) continue;
            return false;
        }
        return true;
    }

    public RowParams toRowParam() {
        RowParams row1 = new RowParams();
        Param param = new Param();
        param.setName("alarmLevel");
        param.setValue(this.convertAlarmLevel(this.getAlarmLevel()));
        row1.addParam(param);
        param = new Param();
        param.setName("level");
        param.setValue(String.valueOf(TETL1FaultUtil.getTL1AlarmLevel(this.getAlarmLevel())));
        row1.addParam(param);
        param = new Param();
        param.setName("alarmName");
        param.setValue(this.getAlarmName());
        row1.addParam(param);
        param = new Param();
        param.setName("alarmLocation");
        param.setValue(this.converAlarmLocation(this.getAlarmLocation()));
        row1.addParam(param);
        param = new Param();
        param.setName("alarmDirection");
        param.setValue(this.convertAlarmDirection(this.getAlarmDirection()));
        row1.addParam(param);
        param = new Param();
        param.setName("monObj");
        param.setValue(this.getMonObject());
        row1.addParam(param);
        param = new Param();
        param.setName("startTime");
        long date = this.getStartDateTime().getTimeInMillis();
        param.setValue(String.valueOf(date));
        row1.addParam(param);
        param = new Param();
        param.setName("almReason");
        param.setValue(this.getAlmReason());
        row1.addParam(param);
        param = new Param();
        param.setName("alarmDetail");
        param.setValue(this.getAlmDetail());
        row1.addParam(param);
        param = new Param();
        param.setName("alarmType");
        param.setValue(this.convertAlarmTypeToStr(this.aeType));
        row1.addParam(param);
        param = new Param();
        param.setName("evtSerialNum");
        param.setValue(this.alarmSN);
        row1.addParam(param);
        return row1;
    }

    private String convertAlarmTypeToStr(int aeType2) {
        return TENEListUtils.getString("alarmType_" + aeType2, ALARM_SOURCE_FILE);
    }

    private String converAlarmLocation(String alarmLocation) {
        if (alarmLocation.equals("NEND")) {
            return TENEListUtils.getString("NEND_LOCATION", ALARM_SOURCE_FILE);
        }
        if (alarmLocation.equals("FEND")) {
            return TENEListUtils.getString("FEND_LOCATION", ALARM_SOURCE_FILE);
        }
        return "";
    }

    private String convertAlarmDirection(String alarmDirection) {
        if (alarmDirection.equals("RCV")) {
            return TENEListUtils.getString("RCV_DIRECTION", ALARM_SOURCE_FILE);
        }
        if (alarmDirection.equals("TRMT")) {
            return TENEListUtils.getString("TRMT_DIRECTION", ALARM_SOURCE_FILE);
        }
        return "-";
    }

    private String convertAlarmLevel(String alarmLevel2) {
        return TENEListUtils.getString("alarmLevel_" + alarmLevel2, ALARM_SOURCE_FILE);
    }

    public RowParams toPrintRow() {
        RowParams row = new RowParams();
        Param param = new Param();
        param.setName("alarmLevel");
        param.setValue(this.convertAlarmLevel(this.getAlarmLevel()));
        row.addParam(param);
        param = new Param();
        param.setName("level");
        param.setValue(String.valueOf(TETL1FaultUtil.getTL1AlarmLevel(this.getAlarmLevel())));
        row.addParam(param);
        param = new Param();
        param.setName("alarmName");
        param.setValue(this.getAlarmName());
        row.addParam(param);
        param = new Param();
        param.setName("alarmLocation");
        param.setValue(this.converAlarmLocation(this.getAlarmLocation()));
        row.addParam(param);
        param = new Param();
        param.setName("alarmDirection");
        param.setValue(this.convertAlarmDirection(this.getAlarmDirection()));
        row.addParam(param);
        param = new Param();
        param.setName("monObj");
        param.setValue(this.getMonObject());
        row.addParam(param);
        param = new Param();
        param.setName("startTime");
        String date = TEDateUtils.calendarToStr(this.getStartDateTime());
        param.setValue(date);
        row.addParam(param);
        param = new Param();
        param.setName("almReason");
        param.setValue(this.getAlmReason());
        row.addParam(param);
        param = new Param();
        param.setName("alarmDetail");
        param.setValue(this.getAlmDetail());
        row.addParam(param);
        param = new Param();
        param.setName("alarmType");
        param.setValue(this.convertAlarmTypeToStr(this.aeType));
        row.addParam(param);
        param = new Param();
        param.setName("evtSerialNum");
        param.setValue(this.alarmSN);
        row.addParam(param);
        return row;
    }

    public String getAlarmSN() {
        return this.alarmSN;
    }

    public int getSlotID() {
        int slotid = 0;
        try {
            String[] slotstr = TETL1CommonUtil.parseAID(this.slotAid, this.neID);
            slotid = Integer.parseInt(slotstr[1]) == -1 ? Integer.parseInt(slotstr[2]) : TETL1CommonUtil.neShelfIDSlotIDToSlotIDNM(slotstr[1] + "-" + slotstr[2]);
        }
        catch (Exception e) {
            slotid = -1;
        }
        return slotid;
    }

    public int getPort() {
        int portID = 0;
        try {
            String[] slotstr = TETL1CommonUtil.parseAID(this.slotAid, this.neID);
            portID = Integer.parseInt(slotstr[3]);
            if (-1 == portID) {
                portID = 0;
            }
        }
        catch (Exception e) {
            portID = -1;
        }
        return portID;
    }

    public int getPath() {
        int pathID = 0;
        try {
            String[] slotstr = TETL1CommonUtil.parseAID(this.slotAid, this.neID);
            pathID = Integer.parseInt(slotstr[4]);
            if (-1 == pathID) {
                pathID = 0;
            }
        }
        catch (Exception e) {
            pathID = -1;
        }
        return pathID;
    }

    public void setAlarmSN(String alarmSn) {
        this.alarmSN = alarmSn;
    }

    public int getMod2Type() {
        return this.mod2Type;
    }

    public void setMod2Type(int mod2Type) {
        this.mod2Type = mod2Type;
    }

    public int getNeID() {
        return this.neID;
    }

    public void setNeID(int neID) {
        this.neID = neID;
    }
}

