/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.tl1.nemanager;

import com.huawei.nglct.cbb.log.TELogInfo;
import com.huawei.nglct.cbb.log.TELogMgr;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TENEListInterface;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.tl1.nemanager.TETL1NE;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.util.Vector;

public class TELogoutTL1NEBean
implements TENEListInterface {
    private boolean allSuccess = true;
    private boolean allFailed = true;
    private static final int ALL_SUCCESS = 0;
    private static final int ALL_FAILED = 2;
    private static final int PORTION_SUCCESS = 1;
    private TELogInfo loginfo = new TELogInfo();

    @Override
    public Datainterface subFuncProcessed(SubFunc subFunc, Datainterface inputData, String ipAddress) {
        Datainterface rtnDatainterface = new Datainterface();
        BussinessParams rtnBParams = new BussinessParams();
        int neID = 0;
        RowParams[] rowParamsArr = inputData.getBussinessParams().getRowParams();
        StringBuffer filePath = new StringBuffer();
        filePath.append(TEPathManager.RESOURCE_PROFILE_PATH).append("funcdesres_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        TEResourceUtil res = TEResourceUtil.getInstance(filePath.toString());
        int len = rowParamsArr.length;
        for (int i = 0; i < len; ++i) {
            for (Param tmpParam : rowParamsArr[i].getParam()) {
                if (!tmpParam.getName().equals("neID")) continue;
                neID = new Integer(tmpParam.getValue());
            }
            TETL1NE ne = (TETL1NE)TENEListUtils.getNEObj(neID);
            if (ne == null) {
                return null;
            }
            this.loginfo.setOperateName(res.getString(subFunc.getDes()));
            this.loginfo.setUserName("admin");
            this.loginfo.setLocation(ipAddress);
            this.loginfo.setOperateObject(ne.getNEName());
            this.loginfo.setCmdID(subFunc.getCode());
            int retCode = ne.logout();
            if (retCode == 0) {
                this.allFailed = false;
                this.loginfo.setResult(0);
                this.loginfo.setErrCode(retCode);
                this.loginfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot(neID, retCode));
                this.loginfo.setOperateDesc(res.getString("LOG_OUT_NE"));
                TELogMgr.writeLog(this.loginfo);
                ne.setBoardList(new Vector());
                ne.setPhyBoardList(new Vector());
                ne.setSubrackList(new Vector());
                continue;
            }
            this.allSuccess = false;
            RowParams rowParam = new RowParams();
            RowErrors rowErr = new RowErrors();
            Param errParam = new Param();
            errParam.setName("nename");
            errParam.setValue(ne.getNEName());
            rowErr.addParam(errParam);
            rowErr.setErrorMessage(TEErrorResourceUtil.getErrorMessage(neID, retCode));
            rowParam.addRowErrors(rowErr);
            rtnBParams.addRowParams(rowParam);
            this.loginfo.setResult(2);
            this.loginfo.setErrCode(retCode);
            this.loginfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot(neID, retCode));
            this.loginfo.setOperateDesc(res.getString("LOG_OUT_NE") + " " + res.getString("ERRORCODE") + retCode + " " + res.getString("ERRORINFO") + TEErrorResourceUtil.getErrCodeResWithDot(neID, retCode));
            TELogMgr.writeLog(this.loginfo);
        }
        ErrorMessage bigErr = new ErrorMessage();
        if (this.allSuccess) {
            bigErr.setErrorcode(new Integer(0).toString());
            bigErr.setErrorinfo(TEErrorResourceUtil.getErrCodeResWithDot(0));
        } else if (this.allFailed) {
            bigErr.setErrorcode(new Integer(2).toString());
            bigErr.setErrorinfo(TEErrorResourceUtil.getErrCodeResWithDot(2));
        } else {
            bigErr.setErrorcode(new Integer(1).toString());
            bigErr.setErrorinfo(TEErrorResourceUtil.getErrCodeResWithDot(1));
        }
        rtnDatainterface.setBussinessParams(rtnBParams);
        rtnDatainterface.setErrorMessage(bigErr);
        return rtnDatainterface;
    }
}

