/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.tl1.eventinterpret.prbs;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.ngwdm_pub.TEOTNModelShowPathMgr;
import com.huawei.nglct.ngwdm_pub.TETL1SimpleAID;
import com.huawei.nglct.tl1.TEAIDAndTypeList;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.eventinterpret.prbs.TEPRBSCache;
import com.huawei.nglct.tl1.eventinterpret.prbs.TEPRBSData;
import com.huawei.nglct.tl1.eventinterpret.prbs.TEPRBSSupportPortMgr;
import com.huawei.nglct.util.datetime.TEDateUtils;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.uflight.tl1.TETL1NECommMgr;
import com.huawei.uflight.tl1.TL1NoticeHandler;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;

public class TEPRBSUtility {
    private static TENormalTestNoticeHandler normalNotice = new TENormalTestNoticeHandler();

    public static ArrayList getQueryPRBSMod2(int neid, int slotID, TEAIDAndTypeList aidAndTypeList, TL1Operation tl1Operation, String[] portChannel, String mod2) {
        TENE ne = TENEListUtils.getNEObj(neid);
        if (ne.getNEType() == 66) {
            return TEPRBSUtility.get1800PRBSMod2(neid, slotID, aidAndTypeList, tl1Operation, portChannel, mod2);
        }
        return TEPRBSUtility.getPRBSMod2(neid, slotID, aidAndTypeList, tl1Operation, portChannel, mod2);
    }

    private static ArrayList get1800PRBSMod2(int neid, int slotID, TEAIDAndTypeList aidAndTypeList, TL1Operation tl1Operation, String[] portChannel, String mod2) {
        String mod2s;
        ArrayList<String> mode2List = new ArrayList<String>();
        if (portChannel.length > 1) {
            mod2s = aidAndTypeList.getPayLoadMod2(neid, slotID, Integer.parseInt(portChannel[0]), Integer.parseInt(portChannel[1]));
            tl1Operation.getInMsg().getPart("AID").setValue(aidAndTypeList.getAID(neid, slotID, Integer.parseInt(portChannel[0]), Integer.parseInt(portChannel[1])));
        } else {
            mod2s = aidAndTypeList.getPayLoadMod2(neid, slotID, Integer.parseInt(portChannel[0]));
            tl1Operation.getInMsg().getPart("AID").setValue(aidAndTypeList.getAID(neid, slotID, Integer.parseInt(portChannel[0])));
        }
        ArrayList mod2List = TETL1CommonUtil.parseString(mod2s, "|");
        int bdtype = TEConfigurationDataMgr.getInstance().getBoardType(neid, slotID);
        ArrayList suppMod2List = TEPRBSSupportPortMgr.getInstance(neid).getBoardSupportMod2s(neid, String.valueOf(bdtype));
        if (suppMod2List == null) {
            suppMod2List = TEPRBSSupportPortMgr.getInstance(neid).getSupportPrbsMod2();
        }
        int n = mod2List.size();
        for (int i = 0; i < n; ++i) {
            String tempMod2 = (String)mod2List.get(i);
            if (!suppMod2List.contains(tempMod2) || mode2List.contains(tempMod2)) continue;
            mode2List.add(tempMod2);
        }
        return mode2List;
    }

    private static ArrayList getPRBSMod2(int neid, int slotID, TEAIDAndTypeList aidAndTypeList, TL1Operation tl1Operation, String[] portChannel, String mod2) {
        ArrayList<String> mode2List = new ArrayList<String>();
        TENE ne = TENEListUtils.getNEObj(neid);
        TEBoard board = ne.getBoard(slotID);
        if (portChannel.length > 1) {
            String mod2s = aidAndTypeList.getPayLoadMod2(neid, slotID, Integer.parseInt(portChannel[0]), Integer.parseInt(portChannel[1]));
            ArrayList mod2List = TETL1CommonUtil.parseString(mod2s, "|");
            int n = mod2List.size();
            for (int i = 0; i < n; ++i) {
                String tempMod2 = (String)mod2List.get(i);
                if ((board.getBoardType() == 1196 || board.getBoardType() == 60035) && tempMod2.indexOf("ODU") != -1) {
                    if (mode2List.contains(tempMod2)) continue;
                    mode2List.add(tempMod2);
                    continue;
                }
                if (tempMod2.indexOf("OTU") == -1 && (tempMod2.indexOf("OC") == -1 || tempMod2.equalsIgnoreCase("OCH")) && tempMod2.indexOf("STM") == -1 || mode2List.contains(tempMod2)) continue;
                mode2List.add(tempMod2);
            }
            tl1Operation.getInMsg().getPart("AID").setValue(aidAndTypeList.getAID(neid, slotID, Integer.parseInt(portChannel[0]), Integer.parseInt(portChannel[1])));
        } else {
            String mod2s = aidAndTypeList.getPayLoadMod2(neid, slotID, Integer.parseInt(portChannel[0]));
            ArrayList mod2List = TETL1CommonUtil.parseString(mod2s, "|");
            int n = mod2List.size();
            for (int i = 0; i < n; ++i) {
                String tempMod2 = (String)mod2List.get(i);
                if ((board.getBoardType() == 1196 || board.getBoardType() == 60035) && tempMod2.indexOf("ODU") != -1) {
                    if (mode2List.contains(tempMod2)) continue;
                    mode2List.add(tempMod2);
                    continue;
                }
                if (tempMod2.indexOf("OTU") == -1 && tempMod2.indexOf("OC") == -1 && tempMod2.indexOf("STM") == -1 || mode2List.contains(tempMod2)) continue;
                mode2List.add(tempMod2);
            }
            tl1Operation.getInMsg().getPart("AID").setValue(aidAndTypeList.getAID(neid, slotID, Integer.parseInt(portChannel[0])));
        }
        return mode2List;
    }

    public static String getSetPRBSMod2(int neid, int slotID, TEAIDAndTypeList aidAndTypeList, int portid, int channelId, String mod2, String testMod) {
        String mod2s = "";
        TENE ne = TENEListUtils.getNEObj(neid);
        TEBoard board = ne.getBoard(slotID);
        mod2s = channelId != -1 ? aidAndTypeList.getPayLoadMod2(neid, slotID, portid, channelId) : aidAndTypeList.getPayLoadMod2(neid, slotID, portid);
        ArrayList mod2List = TETL1CommonUtil.parseString(mod2s, "|");
        if (board.getBoardType() == 1196 || board.getBoardType() == 60035) {
            if (testMod != null && testMod.equals("SPLTF")) {
                mod2 = "ODU2";
                return mod2;
            }
            if (testMod != null && testMod.equals("SPLTE")) {
                if (mod2List.contains("OC192")) {
                    mod2 = "OC192";
                } else if (mod2List.contains("STM64")) {
                    mod2 = "STM64";
                }
                return mod2;
            }
        }
        int n = mod2List.size();
        for (int i = 0; i < n; ++i) {
            String tempMod2 = (String)mod2List.get(i);
            if (tempMod2.indexOf("OTU") == -1 && tempMod2.indexOf("OC") == -1 && tempMod2.indexOf("STM") == -1) continue;
            mod2 = tempMod2;
        }
        return mod2;
    }

    public static String getPortNameFormAid(int neid, String aid, String mode2) {
        TETL1SimpleAID sAid = new TETL1SimpleAID(aid, neid);
        String aidPref = sAid.getAidPre();
        int slot = sAid.getNmSlotID();
        int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neid, slot);
        int port = sAid.getPortID();
        int path = sAid.getNmPath(mode2);
        StringBuffer buffer = new StringBuffer();
        String neName = TEConfigurationDataMgr.getInstance().getNEName(neid);
        buffer.append(neName).append("-");
        String shelfName = TEBoardUtil.getSubrackNameFromSlot(neid, slot);
        buffer.append(shelfName).append("-");
        int showSlot = TEBoardUtil.getSlotIDFromSlot(neid, slot);
        buffer.append(showSlot).append("-");
        String boardName = TEConfigurationDataMgr.getInstance().getBoardTypeName(neid, boardType);
        buffer.append(boardName).append("-");
        String portName = TETL1CommonUtil.getPortNameFromNEPort(aidPref, slot, port, neid);
        buffer.append(portName);
        int neType = TENEListUtils.getNEObj(neid).getNEType();
        if ((mode2.indexOf("OTU") != -1 || mode2.indexOf("ODU") != -1 || mode2.equalsIgnoreCase("OCH")) && sAid.isSimplesBoard() && sAid.getAidPre().equalsIgnoreCase("FAC") && path > 0) {
            buffer.append("-");
            String showPath = TEOTNModelShowPathMgr.getInstance().getOTNModelShowPath(path);
            buffer.append(showPath);
        } else {
            if (!mode2.equals("") && neType != 66) {
                buffer.append("-");
                buffer.append(mode2);
            }
            if (path > 0) {
                buffer.append("-");
                buffer.append(path);
            }
        }
        return buffer.toString();
    }

    public static void registerListener() {
        try {
            String TL1_DES_PATH_MAIN = "conf" + File.separator + "eventtl1describ.xml";
            TL1Definitions definitions = TECreateObjectFactory.parseTL1DesFile("com.huawei.weblct.common", TL1_DES_PATH_MAIN);
            TL1Operation oper = definitions.getTL1Operation("REPT_EVT_PRBS");
            TETL1NECommMgr.getInstance().registerListener(oper, (TL1NoticeHandler)normalNotice);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEBitTestCache registerListener error", (Throwable)e);
        }
    }

    public static void unregisterListener(int neID) {
        try {
            TL1Definitions definitions = TECreateObjectFactory.parseTL1DesFile(neID);
            TL1Operation oper = definitions.getTL1Operation("REPT_EVT_PRBS");
            TETL1NECommMgr.getInstance().registerListener(oper, (TL1NoticeHandler)normalNotice);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEBitTestCache registerListener error", (Throwable)e);
        }
    }

    public static void setCurrentTestMod2(String currMod2) {
        TEPRBSUtility.normalNotice.setMod2(currMod2);
    }

    static class TENormalTestNoticeHandler
    implements TL1NoticeHandler {
        private String mod2 = "";
        private int slotid = 0;
        private String portid = "";
        private int pathid = 0;
        private int testtime = 0;
        private String aid = "";

        TENormalTestNoticeHandler() {
        }

        private void setMod2(String testMod2) {
            this.mod2 = testMod2;
        }

        public void handleNotice(String cmdKey, long neid, TL1Operation oper) {
            int neID = (int)neid;
            long st = 0L;
            String et = "";
            String eslss = "";
            String tbe = "";
            String starttime = "";
            long totalerrnum = 0L;
            String testStatus = "";
            OutMsg[] outmsg = oper.getOutMsg();
            TENE ne = TENEListUtils.getNEObj(neID);
            for (int i = 0; i < outmsg.length; ++i) {
                long starttimeL;
                HashMap hm = TETL1CommonUtil.getOutMsgPart(outmsg[i]);
                Part part = (Part)hm.get("AID");
                this.aid = part.getValue();
                TETL1SimpleAID sAid = new TETL1SimpleAID(this.aid, neID);
                this.slotid = sAid.getNmSlotID();
                this.portid = String.valueOf(sAid.getPortID());
                st = !ne.getServerOrClient() && ne.getTimeZome() != null ? TEDateUtils.getTL1NMTimeFromNETime(neID, oper.getDate().getTime()).getTimeInMillis() : oper.getDate().getTime();
                part = (Part)hm.get("MOD2");
                if (part != null && part.getValue() != null && !part.getValue().isEmpty()) {
                    this.mod2 = part.getValue();
                }
                this.pathid = sAid.getNmPath(this.mod2);
                part = (Part)hm.get("ST");
                starttime = part.getValue();
                part = (Part)hm.get("ET");
                et = part.getValue();
                part = (Part)hm.get("ESLSS");
                eslss = part.getValue();
                part = (Part)hm.get("TBE");
                tbe = part.getValue();
                part = (Part)hm.get("IPFLAG");
                testStatus = part.getValue();
                TEPRBSCache testcache = TEPRBSCache.getInstance();
                String hashvalue = TEPRBSUtility.getPortNameFormAid(neID, this.aid, this.mod2);
                if (!ne.getServerOrClient()) {
                    starttimeL = TEDateUtils.getTL1NMTimeFromNETime(neID, oper.getDate().getTime()).getTimeInMillis();
                } else {
                    Calendar cal = TEDateUtils.strToCalendar(starttime, "yyyy-MM-dd HH-mm-ss");
                    starttimeL = cal.getTimeInMillis();
                }
                TEPRBSData testdata = testcache.getCahce(hashvalue);
                if (testdata == null) {
                    testdata = this.createPRBSTestData(neID);
                    TEPRBSCache.getInstance().addCahce(hashvalue, testdata);
                    return;
                }
                if (totalerrnum <= 0L) {
                    totalerrnum = 0L;
                }
                if (testStatus.equals("COMPLD")) {
                    testdata.setTeststate(10);
                }
                testdata.setElapsedperiod(et);
                testdata.setStartTime(starttimeL);
                testdata.refreshdata(st, this.testtime, Long.parseLong(tbe), eslss, testStatus, et);
            }
        }

        private TEPRBSData createPRBSTestData(int neID) {
            TEPRBSData testdata = new TEPRBSData();
            testdata.setNeid(neID);
            testdata.setSlotid(this.slotid);
            testdata.setPortid(Integer.parseInt(this.portid));
            testdata.setPath(this.pathid);
            testdata.setTimeUnit(3);
            testdata.setTesttime(1);
            testdata.setAccumulation(1);
            testdata.setTeststate(1);
            testdata.setSumTime(0);
            return testdata;
        }
    }
}

