/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.tl1.eventinterpret.prbs;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.xmlinterpreter.SDXMLInterpreterMgr;
import com.huawei.nglct.common.TEParseXMLFile;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.eventinterpret.prbs.TEPRBSObjectID;
import com.huawei.nglct.util.xml.TEResourceManager;
import gnu.trove.TIntArrayList;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TEPRBSSupportPortMgr {
    private static final String path = "conf" + File.separator + "portsuppprbs.xml";
    private static TEPRBSSupportPortMgr instance = null;
    private Map boardPortMap = new HashMap();
    private ArrayList supportPrbsMod2List = new ArrayList();
    private Map<String, String> boardMod2Map = new HashMap<String, String>();
    private SDXMLInterpreterMgr mgr = SDXMLInterpreterMgr.getInstance();

    private TEPRBSSupportPortMgr(int neid) {
        this.boardPortMap = this.getSupportBoardList(neid);
    }

    public static synchronized TEPRBSSupportPortMgr getInstance(int neid) {
        if (instance == null) {
            instance = new TEPRBSSupportPortMgr(neid);
        }
        return instance;
    }

    private Map getSupportBoardList(int neid) {
        try {
            StringBuffer filepath = new StringBuffer(TEResourceManager.getPath()).append(File.separator).append("nemgr").append(File.separator).append("tl1ngwdm").append(File.separator).append(path);
            Document doc = TEParseXMLFile.parseFile("com.huawei.weblct.tl1ngwdm", TEResourceManager.getPath() + filepath.toString());
            if (null == doc) {
                return null;
            }
            NodeList nodeList = doc.getElementsByTagName("board");
            int size = nodeList.getLength();
            for (int i = 0; i < size; ++i) {
                Element boardElement = (Element)nodeList.item(i);
                String name = boardElement.getAttribute("name");
                String boardType = boardElement.getAttribute("type");
                String suppPort = boardElement.getAttribute("prbsportlist");
                String suppPath = boardElement.getAttribute("pathlist");
                TIntArrayList pathList = new TIntArrayList();
                this.mgr.parseIntList(suppPath, pathList);
                String suppMod2 = boardElement.getAttribute("supportmod2");
                if (suppMod2 == null) {
                    suppMod2 = "";
                }
                if (!name.equals("SUPPORTMOD2")) {
                    if (this.boardPortMap.get(boardType) != null) continue;
                    TEPRBSObjectID prbsObj = new TEPRBSObjectID();
                    prbsObj.setPortList(suppPort.split(","));
                    prbsObj.setPathList(pathList);
                    this.boardPortMap.put(boardType, prbsObj);
                    this.boardMod2Map.put(boardType, suppMod2);
                    continue;
                }
                String[] supportList = suppPort.split(",");
                int len = supportList.length;
                for (int j = 0; j < len; ++j) {
                    this.supportPrbsMod2List.add(supportList[j]);
                }
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEPRBSSupportPortMgr.getSupportBoardList() fail!", (Throwable)e);
        }
        return this.boardPortMap;
    }

    public String[] getBoardSupportPorts(int neid, String boardType) {
        String[] portList = new String[]{};
        this.boardPortMap = this.getSupportBoardList(neid);
        if (this.boardPortMap.containsKey(boardType)) {
            TEPRBSObjectID boardPorts = (TEPRBSObjectID)this.boardPortMap.get(boardType);
            return boardPorts.getObjectIDList();
        }
        return portList;
    }

    public ArrayList getBoardSupportMod2s(int neid, String boardType) {
        ArrayList portList = new ArrayList();
        this.getSupportBoardList(neid);
        if (this.boardMod2Map.containsKey(boardType)) {
            String boardMod2s = this.boardMod2Map.get(boardType);
            if (boardMod2s == null || boardMod2s.equals("")) {
                return null;
            }
            portList = TETL1CommonUtil.parseString(boardMod2s, ",");
        }
        return portList;
    }

    public Map getBoardPortMap(int neid) {
        if (this.boardPortMap == null) {
            this.boardPortMap = this.getSupportBoardList(neid);
        }
        return this.boardPortMap;
    }

    public ArrayList getSupportPrbsMod2() {
        return this.supportPrbsMod2List;
    }
}

