/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.tl1.eventinterpret.oam;

import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TEEventBrowseMgr;
import com.huawei.nglct.nelist.model.TETL1AbNormalEvent;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.eventinterpret.TEParseEventDatasXml;
import com.huawei.nglct.tl1.eventinterpret.TETL1EventConstants;
import com.huawei.nglct.tl1.eventinterpret.TETL1EventData;
import com.huawei.nglct.tl1.nemanager.TETL1FaultUtil;
import com.huawei.nglct.tl1.nemanager.TETL1NE;
import com.huawei.nglct.util.datetime.TEDateUtils;
import com.huawei.uflight.tl1.TL1NoticeHandler;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.Calendar;
import java.util.HashMap;

public class TEOAMEventNoticeHandler
implements TL1NoticeHandler {
    public void handleNotice(String cmdKey, long neid, TL1Operation oper) {
        int neID = (int)neid;
        String slotAid = "";
        String port = "";
        String direction = "";
        StringBuffer comment = new StringBuffer();
        Part part = null;
        OutMsg[] output = oper.getOutMsg();
        TETL1NE ne = (TETL1NE)TENEListUtils.getNEObj(neID);
        if (ne == null) {
            return;
        }
        int len = output.length;
        for (int i = 0; i < len; ++i) {
            HashMap partMap = TETL1CommonUtil.getOutMsgPart(output[i]);
            part = (Part)partMap.get("AID");
            slotAid = part.getValue();
            part = (Part)partMap.get("DIR");
            if (part != null && part.getValue() != null) {
                direction = part.getValue();
            }
            part = (Part)partMap.get("PORT");
            port = part.getValue();
        }
        TETL1AbNormalEvent abnormalEvent = new TETL1AbNormalEvent();
        abnormalEvent.eventID = TETL1EventConstants.ETHEROAMSERVICE;
        TETL1EventData eventData = TEParseEventDatasXml.getInstance().getEventData(TETL1EventConstants.ETHEROAMSERVICE);
        if (eventData == null) {
            return;
        }
        abnormalEvent.eventName = eventData.getEvtName();
        abnormalEvent.location = "-";
        abnormalEvent.direction = direction;
        abnormalEvent.objStr = slotAid == null ? "" : ne.getNEName();
        abnormalEvent.severityStr = TETL1FaultUtil.convertAlarmLevel(eventData.getEvtSeverity());
        abnormalEvent.severityLevel = eventData.getEvtSeverity();
        abnormalEvent.nodeType = ne.getNEType();
        abnormalEvent.evtType = eventData.getEvtType();
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(oper.getDate().getTime());
        abnormalEvent.timeRiseStr = TEDateUtils.calendarToStr(calendar);
        String[] mpAid = TETL1CommonUtil.parseAID(slotAid, neID);
        comment.append("MPID: ").append(mpAid[3]);
        comment.append(" , ");
        comment.append("Port: ").append(TETL1CommonUtil.getBoardStructFromAID(port, neID, true));
        abnormalEvent.comment = comment.toString();
        TEEventBrowseMgr.getInstance().addTL1AbNormalEvent(neID, abnormalEvent);
    }
}

