/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.tl1.eventinterpret.dlag;

import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEEventBrowseMgr;
import com.huawei.nglct.nelist.model.TETL1AbNormalEvent;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.eventinterpret.TEParseEventDatasXml;
import com.huawei.nglct.tl1.eventinterpret.TETL1EventConstants;
import com.huawei.nglct.tl1.eventinterpret.TETL1EventData;
import com.huawei.nglct.tl1.nemanager.TETL1FaultUtil;
import com.huawei.nglct.tl1.nemanager.TETL1NE;
import com.huawei.nglct.util.datetime.TEDateUtils;
import com.huawei.uflight.tl1.TL1NoticeHandler;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.Calendar;
import java.util.HashMap;

public class TEDLAGEventNoticeHandler
implements TL1NoticeHandler {
    public void handleNotice(String cmdKey, long neid, TL1Operation oper) {
        int neID = (int)neid;
        String workPort = "";
        String protectPort = "";
        StringBuffer comment = new StringBuffer();
        Part part = null;
        OutMsg[] output = oper.getOutMsg();
        TETL1NE ne = (TETL1NE)TENEListUtils.getNEObj(neID);
        if (ne == null) {
            return;
        }
        int len = output.length;
        for (int i = 0; i < len; ++i) {
            HashMap partMap = TETL1CommonUtil.getOutMsgPart(output[i]);
            part = (Part)partMap.get("PORT1");
            workPort = part.getValue();
            part = (Part)partMap.get("PORT2");
            protectPort = part.getValue();
        }
        TETL1AbNormalEvent abnormalEvent = new TETL1AbNormalEvent();
        abnormalEvent.eventID = TETL1EventConstants.DLAGPROSWITCH;
        TETL1EventData eventData = TEParseEventDatasXml.getInstance().getEventData(TETL1EventConstants.DLAGPROSWITCH);
        if (eventData == null) {
            return;
        }
        abnormalEvent.eventName = eventData.getEvtName();
        abnormalEvent.location = "-";
        abnormalEvent.direction = "-";
        abnormalEvent.objStr = workPort == null ? "" : ne.getNEName();
        abnormalEvent.severityStr = TETL1FaultUtil.convertAlarmLevel(eventData.getEvtSeverity());
        abnormalEvent.severityLevel = eventData.getEvtSeverity();
        abnormalEvent.nodeType = ne.getNEType();
        abnormalEvent.evtType = eventData.getEvtType();
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(oper.getDate().getTime());
        abnormalEvent.timeRiseStr = TEDateUtils.calendarToStr(calendar);
        int slotID = TETL1CommonUtil.getNMSlotStr(workPort, neID);
        int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neID, slotID);
        String boardName = TEConfigurationDataMgr.getInstance().getBoardTypeName(neID, boardType);
        comment.append("Work Port: " + slotID + "-" + boardName + "-");
        String[] aid = TETL1CommonUtil.parseAID(workPort, neID);
        String portName = "UNKNOWN";
        if (aid[0].equals("FAC")) {
            portName = "PORT";
        } else if (aid[0].equals("ACC")) {
            portName = "VCTRUNCK";
        }
        comment.append(portName).append(aid[3]);
        comment.append(" , ");
        slotID = TETL1CommonUtil.getNMSlotStr(protectPort, neID);
        boardType = TEConfigurationDataMgr.getInstance().getBoardType(neID, slotID);
        boardName = TEConfigurationDataMgr.getInstance().getBoardTypeName(neID, boardType);
        comment.append("Protect Port: " + slotID + "-" + boardName + "-");
        aid = TETL1CommonUtil.parseAID(protectPort, neID);
        portName = "UNKNOWN";
        if (aid[0].equals("FAC")) {
            portName = "PORT";
        } else if (aid[0].equals("FAC")) {
            portName = "VCTRUNCK";
        }
        comment.append(portName).append(aid[3]);
        abnormalEvent.comment = comment.toString();
        TEEventBrowseMgr.getInstance().addTL1AbNormalEvent(neID, abnormalEvent);
    }
}

