/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.tl1.eventinterpret;

import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEEventBrowseMgr;
import com.huawei.nglct.nelist.model.TETL1AbNormalEvent;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.eventinterpret.TEParseEventDatasXml;
import com.huawei.nglct.tl1.eventinterpret.TETL1EventConstants;
import com.huawei.nglct.tl1.eventinterpret.TETL1EventData;
import com.huawei.nglct.tl1.nemanager.TETL1FaultUtil;
import com.huawei.nglct.tl1.nemanager.TETL1NE;
import com.huawei.nglct.util.datetime.TEDateUtils;
import com.huawei.uflight.tl1.TL1NoticeHandler;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.Calendar;
import java.util.HashMap;

public class TETL1RmonUpperThrsEventNoticeHandler
implements TL1NoticeHandler {
    public void handleNotice(String cmdKey, long neid, TL1Operation oper) {
        int neID = (int)neid;
        String slotAid = "";
        String eventName = "";
        String eventDate = "";
        String eventTime = "";
        String location = "";
        String direction = "";
        String tmpValue = "";
        String tmpFthr = "";
        Part part = null;
        OutMsg[] output = oper.getOutMsg();
        TETL1NE ne = (TETL1NE)TENEListUtils.getNEObj(neID);
        if (ne == null) {
            return;
        }
        int len = output.length;
        for (int i = 0; i < len; ++i) {
            HashMap partMap = TETL1CommonUtil.getOutMsgPart(output[i]);
            part = (Part)partMap.get("AID");
            slotAid = part.getValue();
            part = (Part)partMap.get("MONTYPE");
            if (part != null && part.getValue() != null) {
                eventName = part.getValue();
            }
            if ((part = (Part)partMap.get("LOCN")) != null && part.getValue() != null) {
                location = part.getValue();
            }
            if ((part = (Part)partMap.get("DIRN")) != null && part.getValue() != null) {
                direction = part.getValue();
            }
            if ((part = (Part)partMap.get("OCRDAT")) != null && part.getValue() != null) {
                eventDate = part.getValue();
            }
            if ((part = (Part)partMap.get("OCRTM")) != null && part.getValue() != null) {
                eventTime = part.getValue();
            }
            if ((part = (Part)partMap.get("VALUE")) != null && part.getValue() != null) {
                tmpValue = part.getValue();
            }
            if ((part = (Part)partMap.get("FTHR")) == null || part.getValue() == null) continue;
            tmpFthr = TETL1FaultUtil.subStringSpecial(part.getValue());
        }
        TETL1AbNormalEvent abnormalEvent = new TETL1AbNormalEvent();
        abnormalEvent.eventID = this.getEventID();
        TETL1EventData eventData = TEParseEventDatasXml.getInstance().getEventData(this.getEventID());
        if (eventData == null) {
            return;
        }
        abnormalEvent.eventName = eventData.getEvtName();
        abnormalEvent.location = TETL1FaultUtil.converAlarmLocation(location);
        abnormalEvent.direction = TETL1FaultUtil.convertAlarmDirection(direction);
        abnormalEvent.objStr = slotAid == null ? "" : ne.getNEName();
        abnormalEvent.severityStr = TETL1FaultUtil.convertAlarmLevel(eventData.getEvtSeverity());
        abnormalEvent.severityLevel = eventData.getEvtSeverity();
        abnormalEvent.nodeType = ne.getNEType();
        abnormalEvent.evtType = eventData.getEvtType();
        Calendar calendar = TETL1FaultUtil.strToCalendarDateTime(eventTime, eventDate);
        abnormalEvent.timeRiseStr = TEDateUtils.calendarToStr(calendar);
        abnormalEvent.comment = this.parseComment(tmpValue, slotAid, neID, tmpFthr, eventName);
        TEEventBrowseMgr.getInstance().addTL1AbNormalEvent(neID, abnormalEvent);
    }

    protected int getEventID() {
        return TETL1EventConstants.RMONUPPERTHRS;
    }

    private String parseComment(String value, String fac, int neid, String frth, String eventName) {
        StringBuffer sb = new StringBuffer();
        String[] aid = TETL1CommonUtil.parseAID(fac, neid);
        int slotNMID = TETL1CommonUtil.getNMSlotStr(fac, neid);
        String showslotID = TETL1CommonUtil.getShelfSlotName(neid, slotNMID);
        int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neid, slotNMID);
        String boardName = TEConfigurationDataMgr.getInstance().getBoardTypeName(neid, boardType);
        sb.append("Slot: ");
        sb.append(showslotID);
        sb.append("-");
        sb.append(boardName);
        sb.append(",");
        int portID = Integer.parseInt(aid[3]);
        int pathID = Integer.parseInt(aid[4]);
        if (portID != -1) {
            String portName = TETL1CommonUtil.getPortNameFromNEPort(aid[0], slotNMID, portID, neid);
            sb.append("Port: ");
            sb.append(portName);
            sb.append(",");
        }
        if (pathID != -1) {
            sb.append("Path: ");
            sb.append(pathID);
            sb.append(",");
        }
        sb.append("Detail Description: ");
        sb.append(eventName + " Errors: Current Performance value: " + value + ", " + "Perform Up-ThresHold: " + frth);
        return sb.toString();
    }
}

